/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class NestedIterator<IE, OE, RE>
implements Iterator<RE> {
    private final Iterator<IE> mInnerIterator;
    private IE mCurrentInnerElement;
    private Iterator<OE> mOuterIterator;
    private final Function<IE, Iterator<OE>> mNextOuterIteratorProvider;
    private final Function<IE, Function<OE, RE>> mResultProvider;

    public NestedIterator(Iterator<IE> iterator, Function<IE, Iterator<OE>> function, Function<IE, Function<OE, RE>> function2) {
        this.mInnerIterator = iterator;
        this.mNextOuterIteratorProvider = function;
        this.mResultProvider = function2;
        this.nextLetter();
    }

    private void nextLetter() {
        if (this.mInnerIterator.hasNext()) {
            do {
                this.mCurrentInnerElement = this.mInnerIterator.next();
                this.mOuterIterator = this.mNextOuterIteratorProvider.apply(this.mCurrentInnerElement);
            } while (!this.mOuterIterator.hasNext() && this.mInnerIterator.hasNext());
            if (!this.mOuterIterator.hasNext()) {
                this.mCurrentInnerElement = null;
                this.mOuterIterator = null;
            }
        } else {
            this.mCurrentInnerElement = null;
            this.mOuterIterator = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.mCurrentInnerElement != null;
    }

    @Override
    public RE next() {
        if (this.mCurrentInnerElement == null) {
            throw new NoSuchElementException();
        }
        OE OE = this.mOuterIterator.next();
        RE RE = this.mResultProvider.apply(this.mCurrentInnerElement).apply(OE);
        if (!this.mOuterIterator.hasNext()) {
            this.nextLetter();
        }
        return RE;
    }
}

