/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonCoreBooleanSubTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbolFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PolyPacSimplificationTermWalker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SimplifyDDA2;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UndoableWrapperScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.CnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.DnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.UnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineSubtermNormalizer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify.SimplifyDDAWithTimeout;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify.SimplifyQuick;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class SmtUtils {
    private static final String[] EMPTY_INDICES = new String[0];
    private static final BigInteger[] EMPTY_INDICES_BI = new BigInteger[0];
    private static final String ERROR_MESSAGE_UNKNOWN_ENUM_CONSTANT = "unknown enum constant ";
    private static final String ERROR_MSG_UNKNOWN_SORT = "unknown sort ";
    private static final boolean BINARY_BITVECTOR_SUM_WORKAROUND = false;
    public static final String FP_TO_IEEE_BV_EXTENSION = "fp.to_ieee_bv";
    private static final boolean EXTENDED_LOCAL_SIMPLIFICATION = true;
    private static final boolean FLATTEN_ARRAY_TERMS = true;
    private static final boolean DEBUG_ASSERT_ULTIMATE_NORMAL_FORM = false;
    private static final boolean DEBUG_CHECK_EVERY_SIMPLIFICATION = false;

    private SmtUtils() {
    }

    public static Term simplify(ManagedScript managedScript, Term term, IUltimateServiceProvider iUltimateServiceProvider, SimplificationTechnique simplificationTechnique) {
        return SmtUtils.simplify(managedScript, term, managedScript.getScript().term("true", new Term[0]), iUltimateServiceProvider, simplificationTechnique);
    }

    public static Term simplify(ManagedScript managedScript, Term term, Term term2, IUltimateServiceProvider iUltimateServiceProvider, SimplificationTechnique simplificationTechnique) {
        long l;
        long l2;
        Term term3;
        if (simplificationTechnique == SimplificationTechnique.NONE) {
            return term;
        }
        managedScript.assertScriptNotLocked();
        Objects.requireNonNull(term2);
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        if (iLogger.isDebugEnabled()) {
            iLogger.debug((Object)new DebugMessage("simplifying formula of DAG size {0}", new Object[]{new DagSizePrinter(term)}));
        }
        if (!SmtUtils.isTrueLiteral(term2) && simplificationTechnique != SimplificationTechnique.POLY_PAC && simplificationTechnique != SimplificationTechnique.SIMPLIFY_DDA && simplificationTechnique != SimplificationTechnique.SIMPLIFY_DDA2 && simplificationTechnique != SimplificationTechnique.NATIVE && simplificationTechnique != SimplificationTechnique.NONE) {
            throw new UnsupportedOperationException(String.valueOf((Object)simplificationTechnique) + " does not support simplification with respect to context");
        }
        long l3 = System.nanoTime();
        switch (simplificationTechnique) {
            case SIMPLIFY_DDA: {
                Term term4;
                UndoableWrapperScript undoableWrapperScript = new UndoableWrapperScript(managedScript.getScript());
                managedScript = new ManagedScript(iUltimateServiceProvider, (Script)undoableWrapperScript);
                try {
                    term4 = new SimplifyDDAWithTimeout(managedScript.getScript(), true, iUltimateServiceProvider, term2).getSimplifiedTerm(term);
                }
                catch (ToolchainCanceledException toolchainCanceledException) {
                    int n = undoableWrapperScript.restore();
                    if (n > 0) {
                        iLogger.warn((Object)("Removed " + n + " from assertion stack"));
                    }
                    throw toolchainCanceledException;
                }
                undoableWrapperScript.restore();
                if (term4 != term) {
                    term3 = new UnfTransformer(managedScript.getScript()).transform(term4);
                    break;
                }
                term3 = term4;
                break;
            }
            case SIMPLIFY_DDA2: {
                term3 = SimplifyDDA2.simplify(iUltimateServiceProvider, managedScript, term2, term);
                break;
            }
            case SIMPLIFY_QUICK: {
                term3 = new SimplifyQuick(managedScript.getScript(), iUltimateServiceProvider).getSimplifiedTerm(term);
                break;
            }
            case NONE: {
                return term;
            }
            case POLY_PAC: {
                term3 = PolyPacSimplificationTermWalker.simplify(iUltimateServiceProvider, managedScript, term2, term);
                break;
            }
            case NATIVE: {
                managedScript.getScript().push(1);
                managedScript.getScript().assertTerm(term2);
                term3 = managedScript.getScript().simplify(term);
                managedScript.getScript().pop(1);
                break;
            }
            default: {
                throw new AssertionError((Object)(ERROR_MESSAGE_UNKNOWN_ENUM_CONSTANT + String.valueOf((Object)simplificationTechnique)));
            }
        }
        if (iLogger.isDebugEnabled()) {
            iLogger.debug((Object)new DebugMessage("DAG size before simplification {0}, DAG size after simplification {1}", new Object[]{new DagSizePrinter(term), new DagSizePrinter(term3)}));
        }
        if ((l2 = ((l = System.nanoTime()) - l3) / 1000000L) >= 5000L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Spent ").append(CoreUtil.humanReadableTime((long)l2, (TimeUnit)TimeUnit.MILLISECONDS, (int)2)).append(" on a formula simplification");
            if (term.equals(term3)) {
                stringBuilder.append(" that was a NOOP. DAG size: ");
                stringBuilder.append(new DagSizePrinter(term));
            } else {
                stringBuilder.append(". DAG size of input: ");
                stringBuilder.append(new DagSizePrinter(term));
                stringBuilder.append(" DAG size of output: ");
                stringBuilder.append(new DagSizePrinter(term3));
            }
            stringBuilder.append(" (called from ").append(ReflectionUtil.getCallerSignatureFiltered(Set.of(SmtUtils.class))).append(")");
            iLogger.warn((Object)stringBuilder);
        }
        return term3;
    }

    public static ExtendedSimplificationResult simplifyWithStatistics(ManagedScript managedScript, Term term, IUltimateServiceProvider iUltimateServiceProvider, SimplificationTechnique simplificationTechnique) {
        return SmtUtils.simplifyWithStatistics(managedScript, term, managedScript.term(null, "true", new Term[0]), iUltimateServiceProvider, simplificationTechnique);
    }

    public static ExtendedSimplificationResult simplifyWithStatistics(ManagedScript managedScript, Term term, Term term2, IUltimateServiceProvider iUltimateServiceProvider, SimplificationTechnique simplificationTechnique) {
        long l = System.nanoTime();
        long l2 = new DAGSize().treesize(term);
        Term term3 = SmtUtils.simplify(managedScript, term, term2, iUltimateServiceProvider, simplificationTechnique);
        long l3 = new DAGSize().treesize(term3);
        long l4 = System.nanoTime();
        return new ExtendedSimplificationResult(term3, l4 - l, l2 - l3, (double)l3 / (double)l2 * 100.0);
    }

    public static Script.LBool checkSatTerm(Script script, Term term) {
        return Util.checkSat((Script)script, (Term)term);
    }

    public static Term[] getConjuncts(Term term) {
        Term[] termArray;
        if (term instanceof ApplicationTerm && "and".equals((termArray = (Term[])term).getFunction().getName())) {
            return termArray.getParameters();
        }
        termArray = new Term[]{term};
        return termArray;
    }

    public static Term[] cannibalize(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, boolean bl, Term term) {
        Term term2 = new CnfTransformer(managedScript, iUltimateServiceProvider).transform(term);
        if (bl) {
            return SmtUtils.splitNumericEqualities(managedScript.getScript(), SmtUtils.getConjuncts(term2));
        }
        return SmtUtils.getConjuncts(term2);
    }

    private static Term[] splitNumericEqualities(Script script, Term[] termArray) {
        ArrayList<Term> arrayList = new ArrayList<Term>(termArray.length * 2);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            BinaryNumericRelation binaryNumericRelation = BinaryNumericRelation.convert(term);
            if (binaryNumericRelation == null) {
                arrayList.add(term);
            } else if (binaryNumericRelation.getRelationSymbol() == RelationSymbol.EQ) {
                Term term2 = script.term("<=", new Term[]{binaryNumericRelation.getLhs(), binaryNumericRelation.getRhs()});
                arrayList.add(term2);
                Term term3 = script.term(">=", new Term[]{binaryNumericRelation.getLhs(), binaryNumericRelation.getRhs()});
                arrayList.add(term3);
            } else {
                arrayList.add(term);
            }
            ++n2;
        }
        return arrayList.toArray(new Term[arrayList.size()]);
    }

    public static Term[] getDisjuncts(Term term) {
        Term[] termArray;
        if (term instanceof ApplicationTerm && "or".equals((termArray = (Term[])term).getFunction().getName())) {
            return termArray.getParameters();
        }
        termArray = new Term[]{term};
        return termArray;
    }

    public static Term binarize(Script script, ApplicationTerm applicationTerm) {
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        if (!functionSymbol.isPairwise() && !functionSymbol.isChainable()) {
            throw new IllegalArgumentException("can only binarize pairwise terms");
        }
        String string = functionSymbol.getApplicationString();
        Term[] termArray = applicationTerm.getParameters();
        assert (termArray.length > 1);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n = 0;
        while (n < termArray.length) {
            int n2 = n + 1;
            while (n2 < termArray.length) {
                arrayList.add(script.term(string, new Term[]{termArray[n], termArray[n2]}));
                ++n2;
            }
            ++n;
        }
        return SmtUtils.and(script, arrayList.toArray(new Term[arrayList.size()]));
    }

    public static boolean firstParamIsBool(ApplicationTerm applicationTerm) {
        Term[] termArray = applicationTerm.getParameters();
        return SmtSortUtils.isBoolSort(termArray[0].getSort());
    }

    public static boolean allParamsAreBool(ApplicationTerm applicationTerm) {
        return Arrays.stream(applicationTerm.getParameters()).map(Term::getSort).allMatch(SmtSortUtils::isBoolSort);
    }

    public static Term binaryBooleanEquality(Script script, Term term, Term term2) {
        assert (SmtSortUtils.isBoolSort(term.getSort()));
        assert (SmtSortUtils.isBoolSort(term2.getSort()));
        Term term3 = SmtUtils.and(script, term, term2);
        Term term4 = SmtUtils.and(script, SmtUtils.not(script, term), SmtUtils.not(script, term2));
        return SmtUtils.or(script, term3, term4);
    }

    public static Term binaryBooleanNotEquals(Script script, Term term, Term term2) {
        assert (SmtSortUtils.isBoolSort(term.getSort()));
        assert (SmtSortUtils.isBoolSort(term2.getSort()));
        Term term3 = SmtUtils.or(script, term, term2);
        Term term4 = SmtUtils.or(script, SmtUtils.not(script, term), SmtUtils.not(script, term2));
        return SmtUtils.and(script, term3, term4);
    }

    public static List<Term> negateElementwise(Script script, List<Term> list) {
        ArrayList<Term> arrayList = new ArrayList<Term>(list.size());
        for (Term term : list) {
            arrayList.add(SmtUtils.not(script, term));
        }
        return arrayList;
    }

    public static Term multiDimensionalSelect(Script script, Term term, ArrayIndex arrayIndex) {
        assert (term.getSort().isArraySort());
        Term term2 = term;
        for (Term term3 : arrayIndex) {
            term2 = SmtUtils.select(script, term2, term3);
        }
        return term2;
    }

    public static Term multiDimensionalStore(Script script, Term term, ArrayIndex arrayIndex, Term term2) {
        assert (!arrayIndex.isEmpty());
        assert (term.getSort().isArraySort());
        Term term3 = term2;
        int n = arrayIndex.size() - 1;
        while (n >= 0) {
            Term term4 = SmtUtils.multiDimensionalSelect(script, term, arrayIndex.getFirst(n));
            term3 = SmtUtils.store(script, term4, arrayIndex.get(n), term3);
            --n;
        }
        return term3;
    }

    public static <K, V> boolean neitherKeyNorValueIsNull(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() != null && entry.getValue() != null) continue;
            return false;
        }
        return true;
    }

    public static Term pairwiseEquality(Script script, List<? extends Term> list, List<? extends Term> list2) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("must have same length");
        }
        Term[] termArray = new Term[list.size()];
        int n = 0;
        while (n < list.size()) {
            termArray[n] = SmtUtils.binaryEquality(script, list.get(n), list2.get(n));
            ++n;
        }
        return SmtUtils.and(script, termArray);
    }

    public static Term indexEqualityImpliesValueEquality(Script script, ArrayIndex arrayIndex, ArrayIndex arrayIndex2, Term term, Term term2) {
        assert (arrayIndex.size() == arrayIndex2.size());
        Term term3 = SmtUtils.pairwiseEquality(script, arrayIndex, arrayIndex2);
        Term term4 = SmtUtils.binaryEquality(script, term, term2);
        return SmtUtils.or(script, SmtUtils.not(script, term3), term4);
    }

    public static Term sum(Script script, Sort sort, Term ... termArray) {
        assert (SmtSortUtils.isNumericSort(sort) || SmtSortUtils.isBitvecSort(sort));
        if (termArray.length == 0) {
            if (SmtSortUtils.isIntSort(sort) || SmtSortUtils.isRealSort(sort)) {
                return Rational.ZERO.toTerm(sort);
            }
            if (SmtSortUtils.isBitvecSort(sort)) {
                return BitvectorUtils.constructTerm(script, BigInteger.ZERO, sort);
            }
            throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + String.valueOf(sort));
        }
        if (termArray.length == 1) {
            return termArray[0];
        }
        if (SmtSortUtils.isNumericSort(sort)) {
            return script.term("+", CommuhashUtils.sortByHashCode(termArray));
        }
        if (!SmtSortUtils.isBitvecSort(sort)) {
            throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + String.valueOf(sort));
        }
        return script.term("bvadd", CommuhashUtils.sortByHashCode(termArray));
    }

    public static Term binaryBitvectorSum(Script script, Sort sort, Term ... termArray) {
        if (termArray.length == 0) {
            return BitvectorUtils.constructTerm(script, BigInteger.ZERO, sort);
        }
        if (termArray.length == 1) {
            return termArray[0];
        }
        Term term = script.term("bvadd", new Term[]{termArray[0], termArray[1]});
        int n = 2;
        while (n < termArray.length) {
            term = script.term("bvadd", new Term[]{term, termArray[n]});
            ++n;
        }
        return term;
    }

    public static Term mul(Script script, Rational rational, Term term) {
        if (rational.equals((Object)Rational.ONE)) {
            return term;
        }
        if (rational.equals((Object)Rational.MONE)) {
            return SmtUtils.neg(script, term);
        }
        Term term2 = SmtUtils.rational2Term(script, rational, term.getSort());
        return SmtUtils.mul(script, term.getSort(), term2, term);
    }

    public static Term mul(Script script, Sort sort, Term ... termArray) {
        assert (SmtSortUtils.isNumericSort(sort) || SmtSortUtils.isBitvecSort(sort));
        if (termArray.length == 0) {
            BigInteger bigInteger = BigInteger.ONE;
            return SmtUtils.constructIntegerValue(script, sort, bigInteger);
        }
        if (termArray.length == 1) {
            return termArray[0];
        }
        if (SmtSortUtils.isNumericSort(sort)) {
            return script.term("*", CommuhashUtils.sortByHashCode(termArray));
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            return script.term("bvmul", CommuhashUtils.sortByHashCode(termArray));
        }
        throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + String.valueOf(sort));
    }

    public static Term sum(Script script, String string, Term ... termArray) {
        assert ("+".equals(string) || "bvadd".equals(string));
        Term term = script.term(string, termArray);
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(script).transform(term);
        if (affineTerm.isErrorTerm()) {
            return term;
        }
        return affineTerm.toTerm(script);
    }

    public static Term mul(Script script, String string, Term ... termArray) {
        assert ("*".equals(string) || "bvmul".equals(string));
        if (termArray.length == 0) {
            throw new UnsupportedOperationException("Method does not support empty factors.");
        }
        Term term = termArray.length == 1 ? termArray[0] : script.term(string, CommuhashUtils.sortByHashCode(termArray));
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(script).transform(term);
        if (affineTerm.isErrorTerm()) {
            return term;
        }
        return affineTerm.toTerm(script);
    }

    public static Term minus(Script script, Term ... termArray) {
        String string;
        if (termArray.length <= 1) {
            throw new UnsupportedOperationException("use neg for unary minus");
        }
        Term[] termArray2 = new Term[termArray.length];
        termArray2[0] = termArray[0];
        int n = 1;
        while (n < termArray.length) {
            termArray2[n] = SmtUtils.neg(script, termArray[n]);
            ++n;
        }
        Sort sort = termArray[0].getSort();
        if (SmtSortUtils.isNumericSort(sort)) {
            string = "+";
        } else if (SmtSortUtils.isBitvecSort(sort)) {
            string = "bvadd";
        } else {
            throw new UnsupportedOperationException("unsupported sort " + String.valueOf(sort));
        }
        return SmtUtils.sum(script, string, termArray2);
    }

    public static Term neg(Script script, Term term) {
        Sort sort = term.getSort();
        assert (SmtSortUtils.isNumericSort(sort) || SmtSortUtils.isBitvecSort(sort));
        if (SmtSortUtils.isNumericSort(sort)) {
            return SmtUtils.unaryNumericMinus(script, term);
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            return BitvectorUtils.unfTerm(script, "bvneg", null, term);
        }
        throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + String.valueOf(sort));
    }

    public static Term unaryNumericMinus(Script script, Term term2) {
        if (term2 instanceof ConstantTerm) {
            ConstantTerm constantTerm = (ConstantTerm)term2;
            Rational rational = SmtUtils.toRational(constantTerm);
            return rational.negate().toTerm(term2.getSort());
        }
        if (term2 instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term2;
            if (applicationTerm.getFunction().isIntern()) {
                if (SmtUtils.isUnaryNumericMinus(applicationTerm.getFunction())) {
                    return applicationTerm.getParameters()[0];
                }
                if (applicationTerm.getFunction().getName().equals("+")) {
                    return SmtUtils.sum(script, term2.getSort(), (Term[])Arrays.stream(applicationTerm.getParameters()).map(term -> SmtUtils.unaryNumericMinus(script, term)).toArray(Term[]::new));
                }
                return script.term("-", new Term[]{term2});
            }
            return script.term("-", new Term[]{term2});
        }
        if (term2 instanceof TermVariable) {
            return script.term("-", new Term[]{term2});
        }
        throw new UnsupportedOperationException("cannot apply unary minus to " + term2.getClass().getSimpleName());
    }

    public static Term not(Script script, Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (applicationTerm.getParameters().length == 2) {
                String string = applicationTerm.getFunction().getName();
                if (string.equals("distinct") && applicationTerm.getParameters().length == 2) {
                    return SmtUtils.binaryEquality(script, applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]);
                }
                if (string.equals("<") || string.equals("<=") || string.equals(">") || string.equals(">=")) {
                    PolynomialRelation polynomialRelation = PolynomialRelation.of(script, term);
                    return polynomialRelation.negate().toTerm(script);
                }
            }
            return Util.not((Script)script, (Term)term);
        }
        return Util.not((Script)script, (Term)term);
    }

    public static Term implies(Script script, Term term, Term term2) {
        return SmtUtils.or(script, SmtUtils.not(script, term), term2);
    }

    public static Term equality(Script script, Term ... termArray) {
        if (termArray.length == 2) {
            return SmtUtils.binaryEquality(script, termArray[0], termArray[1]);
        }
        return script.term("=", CommuhashUtils.sortByHashCode(termArray));
    }

    public static Term binaryEquality(Script script, Term term, Term term2) {
        if (term == term2) {
            return script.term("true", new Term[0]);
        }
        if (term.getSort().isNumericSort()) {
            return SmtUtils.numericEquality(script, term, term2);
        }
        if (SmtSortUtils.isBoolSort(term.getSort())) {
            return SmtUtils.booleanEquality(script, term, term2);
        }
        if (SmtSortUtils.isBitvecSort(term.getSort())) {
            return SmtUtils.bitvectorEquality(script, term, term2);
        }
        if (SmtSortUtils.isArraySort(term.getSort())) {
            return SmtUtils.arrayEquality(script, term, term2);
        }
        return script.term("=", CommuhashUtils.sortByHashCode(term, term2));
    }

    public static Term distinct(Script script, Term term, Term term2) {
        return SmtUtils.not(script, SmtUtils.binaryEquality(script, term, term2));
    }

    private static Term booleanEquality(Script script, Term term, Term term2) {
        if (SmtUtils.isTrueLiteral(term)) {
            return term2;
        }
        if (SmtUtils.isFalseLiteral(term)) {
            return SmtUtils.not(script, term2);
        }
        if (SmtUtils.isTrueLiteral(term2)) {
            return term;
        }
        if (SmtUtils.isFalseLiteral(term2)) {
            return SmtUtils.not(script, term);
        }
        return script.term("=", CommuhashUtils.sortByHashCode(term, term2));
    }

    private static Term bitvectorEquality(Script script, Term term, Term term2) {
        if (!SmtSortUtils.isBitvecSort(term.getSort())) {
            throw new UnsupportedOperationException("need BitVec sort");
        }
        if (!SmtSortUtils.isBitvecSort(term2.getSort())) {
            throw new UnsupportedOperationException("need BitVec sort");
        }
        return PolynomialRelation.of(script, RelationSymbol.EQ, term, term2).toTerm(script);
    }

    private static Term numericEquality(Script script, Term term, Term term2) {
        if (!term.getSort().isNumericSort()) {
            throw new UnsupportedOperationException("need numeric sort");
        }
        if (!term2.getSort().isNumericSort()) {
            throw new UnsupportedOperationException("need numeric sort");
        }
        return PolynomialRelation.of(script, RelationSymbol.EQ, term, term2).toTerm(script);
    }

    private static Term arrayEquality(Script script, Term term, Term term2) {
        ApplicationTerm applicationTerm;
        if (!term.getSort().isArraySort()) {
            throw new UnsupportedOperationException("need array sort");
        }
        if (!term2.getSort().isArraySort()) {
            throw new UnsupportedOperationException("need array sort");
        }
        if (term instanceof ApplicationTerm && "store".equals((applicationTerm = (ApplicationTerm)term).getFunction().getName()) && applicationTerm.getParameters()[0] == term2) {
            return SmtUtils.setArrayCellValue(script, applicationTerm.getParameters()[0], applicationTerm.getParameters()[1], applicationTerm.getParameters()[2]);
        }
        if (term2 instanceof ApplicationTerm && "store".equals((applicationTerm = (ApplicationTerm)term2).getFunction().getName()) && applicationTerm.getParameters()[0] == term) {
            return SmtUtils.setArrayCellValue(script, applicationTerm.getParameters()[0], applicationTerm.getParameters()[1], applicationTerm.getParameters()[2]);
        }
        return script.term("=", CommuhashUtils.sortByHashCode(term, term2));
    }

    private static Term setArrayCellValue(Script script, Term term, Term term2, Term term3) {
        Term term4 = SmtUtils.select(script, term, term2);
        return SmtUtils.binaryEquality(script, term4, term3);
    }

    public static String removeSmtQuoteCharacters(String string) {
        return string.replace("|", "");
    }

    public static Map<TermVariable, Term> termVariables2Constants(Script script, Collection<TermVariable> collection, boolean bl) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (TermVariable termVariable : collection) {
            Term term = SmtUtils.termVariable2constant(script, termVariable, bl);
            hashMap.put(termVariable, term);
        }
        return hashMap;
    }

    public static Term termVariable2constant(Script script, TermVariable termVariable, boolean bl) {
        String string = SmtUtils.removeSmtQuoteCharacters(termVariable.getName());
        if (bl) {
            Sort sort = termVariable.getSort();
            script.declareFun(string, new Sort[0], sort);
        }
        return script.term(string, new Term[0]);
    }

    public static Map<TermVariable, Term> termVariables2PseudofreshConstants(Script script, Collection<TermVariable> collection, boolean bl) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (TermVariable termVariable : collection) {
            Term term = SmtUtils.termVariable2PseudofreshConstant(script, termVariable, bl);
            hashMap.put(termVariable, term);
        }
        return hashMap;
    }

    private static Term termVariable2PseudofreshConstant(Script script, TermVariable termVariable, boolean bl) {
        String string = SmtUtils.removeSmtQuoteCharacters(termVariable.getName()) + "_fresh_" + termVariable.hashCode();
        if (bl) {
            Sort sort = termVariable.getSort();
            script.declareFun(string, new Sort[0], sort);
        }
        return script.term(string, new Term[0]);
    }

    public static boolean containsFunctionApplication(Term term, String string) {
        return !SmtUtils.extractApplicationTerms(string, term, true).isEmpty();
    }

    public static boolean containsFunctionApplication(Term term, Collection<String> collection) {
        return collection.stream().anyMatch(string -> SmtUtils.containsFunctionApplication(term, string));
    }

    public static boolean containsArrayVariables(Term ... termArray) {
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            TermVariable[] termVariableArray = term.getFreeVars();
            int n3 = termVariableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TermVariable termVariable = termVariableArray[n4];
                if (termVariable.getSort().isArraySort()) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isArrayFree(Term term) {
        return !SmtUtils.containsArrayVariables(term) && !SmtUtils.containsFunctionApplication(term, Arrays.asList("select", "store"));
    }

    public static boolean containsUninterpretedFunctionApplication(Term term) {
        for (NonTheorySymbol<?> nonTheorySymbol : new NonTheorySymbolFinder().findNonTheorySymbols(term)) {
            if (!(nonTheorySymbol instanceof NonTheorySymbol.Function)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFalseLiteral(Term term) {
        return SmtUtils.isLiteral("false", term);
    }

    public static boolean isTrueLiteral(Term term) {
        return SmtUtils.isLiteral("true", term);
    }

    private static boolean isLiteral(String string, Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            return functionSymbol.getParameterSorts().length == 0 && string.equals(functionSymbol.getApplicationString());
        }
        return false;
    }

    public static boolean isConstant(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            return applicationTerm.getParameters().length == 0 && !applicationTerm.getFunction().isIntern();
        }
        return false;
    }

    public static boolean isIntegerLiteral(BigInteger bigInteger, Term term) {
        if (term instanceof ConstantTerm && SmtSortUtils.isIntSort(term.getSort())) {
            Object object = ((ConstantTerm)term).getValue();
            if (object instanceof Rational) {
                return object.equals(Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE));
            }
            if (object instanceof BigInteger) {
                return object.equals(bigInteger);
            }
            throw new AssertionError((Object)("unknown type of integer value " + object.getClass().getSimpleName()));
        }
        return false;
    }

    public static boolean isAtomicFormula(Term term) {
        if (SmtSortUtils.isBoolSort(term.getSort())) {
            if (SmtUtils.isTrueLiteral(term) || SmtUtils.isFalseLiteral(term)) {
                return true;
            }
            if (term instanceof TermVariable || SmtUtils.isConstant(term)) {
                return true;
            }
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                return !NonCoreBooleanSubTermTransformer.isCoreBooleanNonAtom(applicationTerm);
            }
        }
        return false;
    }

    public static boolean isNNF(Term term) {
        for (String string : Arrays.asList("=", "=>", "xor", "distinct", "ite")) {
            for (Term term2 : SmtUtils.extractApplicationTerms(string, term, true)) {
                if (!SmtUtils.allParamsAreBool((ApplicationTerm)term2)) continue;
                return false;
            }
        }
        for (Term term3 : SmtUtils.extractApplicationTerms("not", term, true)) {
            if (SmtUtils.isAtomicFormula(((ApplicationTerm)term3).getParameters()[0])) continue;
            return false;
        }
        return true;
    }

    public static Set<TermVariable> getFreeVars(Collection<Term> collection) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (Term term : collection) {
            hashSet.addAll(Arrays.asList(term.getFreeVars()));
        }
        return hashSet;
    }

    public static Term and(Script script, Term ... termArray) {
        return SmtUtils.andWithExtendedLocalSimplification(script, Arrays.asList(termArray));
    }

    public static Term and(Script script, Collection<Term> collection) {
        return SmtUtils.andWithExtendedLocalSimplification(script, collection);
    }

    public static Term or(Script script, Term ... termArray) {
        return SmtUtils.orWithExtendedLocalSimplification(script, Arrays.asList(termArray));
    }

    public static Term or(Script script, Collection<Term> collection) {
        return SmtUtils.orWithExtendedLocalSimplification(script, collection);
    }

    public static Term andWithExtendedLocalSimplification(Script script, Term ... termArray) {
        return SmtUtils.andWithExtendedLocalSimplification(script, Arrays.asList(termArray));
    }

    public static Term andWithExtendedLocalSimplification(Script script, Collection<Term> collection) {
        Predicate<Term> predicate = SmtUtils::isTrueLiteral;
        Predicate<Term> predicate2 = SmtUtils::isFalseLiteral;
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        InnerDualJunctTracker innerDualJunctTracker = new InnerDualJunctTracker();
        boolean bl = SmtUtils.recursiveAndOrSimplificationHelper(script, "and", predicate, predicate2, collection, hashSet, hashSet2, innerDualJunctTracker);
        if (bl) {
            return script.term("false", new Term[0]);
        }
        if (hashSet.isEmpty()) {
            return script.term("true", new Term[0]);
        }
        if (hashSet.size() == 1) {
            return (Term)hashSet.iterator().next();
        }
        return script.term("and", CommuhashUtils.sortByHashCode(hashSet.toArray(new Term[hashSet.size()])));
    }

    private static Term applyDistributivity(Script script, Set<Term> set, String string, Set<Term> set2) {
        Term term2;
        String string2 = QuantifierUtils.getDualBooleanConnective(string);
        Term[] termArray = new Term[set.size()];
        int n = 0;
        for (Term term2 : set) {
            Term[] termArray2 = QuantifierUtils.getDualFiniteJuncts(QuantifierUtils.getCorrespondingQuantifier(string), term2);
            Term[] termArray3 = new Term[termArray2.length - set2.size()];
            int n2 = 0;
            Term[] termArray4 = termArray2;
            int n3 = termArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Term term3 = termArray4[n4];
                if (!set2.contains(term3)) {
                    termArray3[n2] = term3;
                    ++n2;
                }
                ++n4;
            }
            if (termArray3.length == 0) {
                throw new AssertionError((Object)"optimization!!");
            }
            termArray[n] = termArray3.length == 1 ? termArray3[0] : script.term(string2, termArray3);
            ++n;
        }
        term2 = script.term(string, termArray);
        ArrayList arrayList = new ArrayList(set2.size() + 1);
        arrayList.addAll(set2);
        arrayList.add(term2);
        return script.term(string2, arrayList.toArray(new Term[arrayList.size()]));
    }

    public static Term orWithExtendedLocalSimplification(Script script, Collection<Term> collection) {
        Predicate<Term> predicate = SmtUtils::isFalseLiteral;
        Predicate<Term> predicate2 = SmtUtils::isTrueLiteral;
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        InnerDualJunctTracker innerDualJunctTracker = new InnerDualJunctTracker();
        boolean bl = SmtUtils.recursiveAndOrSimplificationHelper(script, "or", predicate, predicate2, collection, hashSet, hashSet2, innerDualJunctTracker);
        if (bl) {
            return script.term("true", new Term[0]);
        }
        if (hashSet.isEmpty()) {
            return script.term("false", new Term[0]);
        }
        if (hashSet.size() == 1) {
            return (Term)hashSet.iterator().next();
        }
        return script.term("or", CommuhashUtils.sortByHashCode(hashSet.toArray(new Term[hashSet.size()])));
    }

    private static boolean recursiveAndOrSimplificationHelper(Script script, String string, Predicate<Term> predicate, Predicate<Term> predicate2, Collection<Term> collection, Set<Term> set, Set<Term> set2, InnerDualJunctTracker innerDualJunctTracker) {
        for (Term term : collection) {
            if (predicate.test(term)) continue;
            if (predicate2.test(term)) {
                return true;
            }
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (applicationTerm.getFunction().getName().equals(string)) {
                    boolean bl = SmtUtils.recursiveAndOrSimplificationHelper(script, string, predicate, predicate2, Arrays.asList(applicationTerm.getParameters()), set, set2, innerDualJunctTracker);
                    if (!bl) continue;
                    return true;
                }
                if ("not".equals(applicationTerm.getFunction().getName())) {
                    if (set.contains(applicationTerm.getParameters()[0])) {
                        return true;
                    }
                    set2.add(applicationTerm.getParameters()[0]);
                }
            }
            if (set2.contains(term)) {
                return true;
            }
            set.add(term);
            innerDualJunctTracker.addOuterJunct(term, string);
        }
        return false;
    }

    public static Term ite(Script script, Term term, Term term2, Term term3) {
        if (SmtUtils.isTrueLiteral(term) || term2 == term3) {
            return term2;
        }
        if (SmtUtils.isFalseLiteral(term)) {
            return term3;
        }
        if (SmtUtils.isTrueLiteral(term2)) {
            return SmtUtils.or(script, term, term3);
        }
        if (SmtUtils.isFalseLiteral(term3)) {
            return SmtUtils.and(script, term, term2);
        }
        if (SmtUtils.isFalseLiteral(term2)) {
            return SmtUtils.and(script, SmtUtils.not(script, term), term3);
        }
        if (SmtUtils.isTrueLiteral(term3)) {
            return SmtUtils.or(script, SmtUtils.not(script, term), term2);
        }
        return script.term("ite", new Term[]{term, term2, term3});
    }

    public static Term leq(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "<=", term, term2);
    }

    public static Term geq(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, ">=", term, term2);
    }

    public static Term less(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "<", term, term2);
    }

    public static Term greater(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, ">", term, term2);
    }

    public static Term bvule(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "bvule", term, term2);
    }

    public static Term bvult(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "bvult", term, term2);
    }

    public static Term bvuge(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "bvuge", term, term2);
    }

    public static Term bvugt(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "bvugt", term, term2);
    }

    public static Term bvsle(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "bvsle", term, term2);
    }

    public static Term bvslt(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "bvslt", term, term2);
    }

    public static Term bvsge(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "bvsge", term, term2);
    }

    public static Term bvsgt(Script script, Term term, Term term2) {
        return SmtUtils.comparison(script, "bvsgt", term, term2);
    }

    private static Term comparison(Script script, String string, Term term, Term term2) {
        RelationSymbol relationSymbol = RelationSymbol.convert(string);
        if (relationSymbol == null) {
            throw new AssertionError((Object)("Unknown RelationSymbol" + string));
        }
        if (!relationSymbol.isConvexInequality()) {
            throw new AssertionError((Object)("Not a comparison " + string));
        }
        if (term == term2) {
            if (relationSymbol.isStrictRelation()) {
                return script.term("false", new Term[0]);
            }
            return script.term("true", new Term[0]);
        }
        if (SmtSortUtils.isNumericSort(term.getSort())) {
            return PolynomialRelation.of(script, RelationSymbol.convert(string), term, term2).toTerm(script);
        }
        assert (SmtSortUtils.isBitvecSort(term.getSort()));
        return script.term(string, new Term[]{term, term2});
    }

    public static ApplicationTerm buildNewConstant(Script script, String string, String string2) {
        script.declareFun(string, new Sort[0], script.sort(string2, new Sort[0]));
        return (ApplicationTerm)script.term(string, new Term[0]);
    }

    public static Term convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray, Script script) {
        Term[] termArray2 = applicationTerm.getParameters();
        Object object = termArray2 == termArray ? applicationTerm : SmtUtils.unfTerm(script, applicationTerm.getFunction(), termArray);
        return object;
    }

    public static Term unfTerm(Script script, FunctionSymbol functionSymbol, Term ... termArray) {
        Sort sort = functionSymbol.isReturnOverload() ? functionSymbol.getReturnSort() : null;
        return SmtUtils.unfTerm(script, functionSymbol.getName(), functionSymbol.getIndices(), sort, termArray);
    }

    public static Term unfTerm(Script script, String string, String[] stringArray, Sort sort, Term ... termArray) {
        return switch (string) {
            case "and" -> SmtUtils.and(script, termArray);
            case "or" -> SmtUtils.or(script, termArray);
            case "not" -> {
                if (termArray.length != 1) {
                    throw new IllegalArgumentException("no not term");
                }
                yield SmtUtils.not(script, termArray[0]);
            }
            case "=" -> {
                if (termArray.length != 2) {
                    throw new UnsupportedOperationException("not yet implemented: equality with " + termArray.length + " params");
                }
                yield SmtUtils.binaryEquality(script, termArray[0], termArray[1]);
            }
            case "distinct" -> {
                if (termArray.length != 2) {
                    throw new UnsupportedOperationException("not yet implemented: distinct with " + termArray.length + " params");
                }
                yield SmtUtils.distinct(script, termArray[0], termArray[1]);
            }
            case "=>" -> Util.implies((Script)script, (Term[])termArray);
            case "ite" -> {
                if (termArray.length != 3) {
                    throw new IllegalArgumentException("no ite");
                }
                yield SmtUtils.ite(script, termArray[0], termArray[1], termArray[2]);
            }
            case "+" -> SmtUtils.sum(script, string, termArray);
            case "-" -> {
                if (termArray.length == 1) {
                    yield SmtUtils.unaryNumericMinus(script, termArray[0]);
                }
                yield SmtUtils.minus(script, termArray);
            }
            case "*" -> SmtUtils.mul(script, string, termArray);
            case "div" -> {
                if (termArray.length < 2) {
                    throw new IllegalArgumentException("div needs at least two arguments");
                }
                yield SmtUtils.divInt(script, termArray);
            }
            case "mod" -> {
                if (termArray.length != 2) {
                    throw new IllegalArgumentException("no mod");
                }
                yield SmtUtils.mod(script, termArray[0], termArray[1]);
            }
            case "<", ">", "<=", ">=" -> {
                if (termArray.length != 2) {
                    throw new IllegalArgumentException("no comparison");
                }
                yield SmtUtils.comparison(script, string, termArray[0], termArray[1]);
            }
            case "store" -> SmtUtils.store(script, termArray[0], termArray[1], termArray[2]);
            case "select" -> SmtUtils.select(script, termArray[0], termArray[1]);
            case "bvashr", "bvlshr", "bvsdiv", "bvsmod", "bvsrem", "bvudiv", "bvurem", "extract", "zero_extend", "bvor", "bvadd", "bvand", "bvmul", "bvneg", "bvnot", "bvsge", "bvsgt", "bvshl", "bvsle", "bvslt", "bvsub", "bvuge", "bvugt", "bvule", "bvult", "bvxor" -> BitvectorUtils.unfTerm(script, string, SmtUtils.toBigIntegerArray(stringArray), termArray);
            case "fp" -> script.term(string, null, null, termArray);
            default -> script.term(string, stringArray, sort, termArray);
        };
    }

    public static Term select(Script script, Term term, Term term2) {
        ArrayStore arrayStore = ArrayStore.of(term);
        Term term3 = arrayStore != null ? SmtUtils.selectOverStore(script, arrayStore, term2) : script.term("select", new Term[]{term, term2});
        return term3;
    }

    private static Term selectOverStore(Script script, ArrayStore arrayStore, Term term) {
        Term term2;
        if (arrayStore.getIndex().equals(term)) {
            term2 = arrayStore.getValue();
        } else {
            IPolynomialTerm iPolynomialTerm = PolynomialTermTransformer.convert(script, term);
            IPolynomialTerm iPolynomialTerm2 = PolynomialTermTransformer.convert(script, arrayStore.getIndex());
            if (iPolynomialTerm == null || iPolynomialTerm2 == null) {
                term2 = script.term("select", new Term[]{arrayStore.getTerm(), term});
            } else {
                AbstractGeneralizedAffineTerm.Equivalence equivalence = iPolynomialTerm.compare(iPolynomialTerm2);
                term2 = switch (equivalence) {
                    case AbstractGeneralizedAffineTerm.Equivalence.DISTINCT -> SmtUtils.select(script, arrayStore.getArray(), term);
                    case AbstractGeneralizedAffineTerm.Equivalence.EQUALS -> arrayStore.getValue();
                    case AbstractGeneralizedAffineTerm.Equivalence.INCOMPARABLE -> script.term("select", new Term[]{arrayStore.getTerm(), term});
                    default -> throw new MatchException(null, null);
                };
            }
        }
        return term2;
    }

    public static Term store(Script script, Term term, Term term2, Term term3) {
        ArrayStore arrayStore = ArrayStore.of(term);
        if (arrayStore == null) {
            return script.term("store", new Term[]{term, term2, term3});
        }
        HashSet<Term> hashSet = new HashSet<Term>();
        hashSet.add(term2);
        ArrayDeque<Pair> arrayDeque = new ArrayDeque<Pair>();
        arrayDeque.addFirst(new Pair((Object)term2, (Object)term3));
        Term term4 = term;
        while (arrayStore != null) {
            if (!hashSet.contains(arrayStore.getIndex())) {
                arrayDeque.addFirst(new Pair((Object)arrayStore.getIndex(), (Object)arrayStore.getValue()));
                hashSet.add(arrayStore.getIndex());
            }
            term4 = arrayStore.getArray();
            arrayStore = ArrayStore.of(term4);
        }
        Term term5 = term4;
        for (Pair pair : arrayDeque) {
            term5 = script.term("store", new Term[]{term5, (Term)pair.getFirst(), (Term)pair.getSecond()});
        }
        return term5;
    }

    public static Term getArrayStoreIdx(Term term) {
        ApplicationTerm applicationTerm;
        FunctionSymbol functionSymbol;
        if (term instanceof ApplicationTerm && (functionSymbol = (applicationTerm = (ApplicationTerm)term).getFunction()).isIntern() && "store".equals(functionSymbol.getName())) {
            return applicationTerm.getParameters()[1];
        }
        return null;
    }

    public static Term getBasicArrayTerm(Term term) {
        assert (term.getSort().isArraySort());
        Term term2 = term;
        while (SmtUtils.isFunctionApplication(term2, "store") || SmtUtils.isFunctionApplication(term2, "select")) {
            term2 = ((ApplicationTerm)term2).getParameters()[0];
        }
        assert (term2.getSort().isArraySort());
        assert (term2 instanceof TermVariable || term2 instanceof ConstantTerm || SmtUtils.isConstant(term2));
        return term2;
    }

    public static boolean isBasicArrayTerm(Term term) {
        ApplicationTerm applicationTerm;
        if (!term.getSort().isArraySort()) {
            return false;
        }
        if (term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getParameters().length > 0) {
            return false;
        }
        assert (term instanceof ApplicationTerm || term instanceof TermVariable || term instanceof ConstantTerm);
        return true;
    }

    public static String sanitizeStringAsSmtIdentifier(String string) {
        return string.replace("|", "BAR").replace(' ', '_');
    }

    public static Term abs(Script script, Term term) {
        if (term instanceof ConstantTerm && SmtSortUtils.isIntSort(term.getSort())) {
            Rational rational = SmtUtils.toRational((ConstantTerm)term);
            return rational.abs().toTerm(term.getSort());
        }
        return script.term("abs", new Term[]{term});
    }

    public static Term divReal(Script script, Term ... termArray) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (termArray.length == 0) {
            throw new IllegalArgumentException("real division needs at least one argument");
        }
        arrayList.add(termArray[0]);
        int n = 1;
        while (n < termArray.length) {
            Rational rational = SmtUtils.tryToConvertToLiteral(termArray[n]);
            if (rational == null) {
                arrayList.add(termArray[n]);
            } else if (rational.numerator() == BigInteger.ZERO) {
                arrayList.add(termArray[n]);
            } else if (rational.numerator() != BigInteger.ONE || !rational.isIntegral()) {
                Rational rational2;
                Object object = arrayList.isEmpty() ? null : ((rational2 = SmtUtils.tryToConvertToLiteral((Term)arrayList.get(arrayList.size() - 1))) == null ? null : (!rational2.numerator().equals(BigInteger.ZERO) || arrayList.size() == 1 ? rational2 : null));
                if (object != null) {
                    rational2 = arrayList.size() == 1 ? object.div(rational) : object.mul(rational);
                    Term term = rational2.toTerm(SmtSortUtils.getRealSort(script));
                    arrayList.set(arrayList.size() - 1, term);
                } else {
                    arrayList.add(termArray[n]);
                }
            }
            ++n;
        }
        if (arrayList.size() == 1) {
            return (Term)arrayList.get(0);
        }
        return script.term("/", arrayList.toArray(new Term[arrayList.size()]));
    }

    public static Term divInt(Script script, Term ... termArray) {
        AbstractGeneralizedAffineTerm[] abstractGeneralizedAffineTermArray = new AbstractGeneralizedAffineTerm[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            abstractGeneralizedAffineTermArray[n] = (AbstractGeneralizedAffineTerm)PolynomialTermTransformer.convert(script, termArray[n]);
            ++n;
        }
        return abstractGeneralizedAffineTermArray[0].div(script, Arrays.copyOfRange(abstractGeneralizedAffineTermArray, 1, abstractGeneralizedAffineTermArray.length)).toTerm(script);
    }

    public static Term divIntFlatten(Script script, Term term, Term term2) {
        Term term3;
        Rational rational = SmtUtils.tryToConvertToLiteral(term2);
        if (rational != null) {
            BigInteger bigInteger = rational.numerator();
            term3 = SmtUtils.divIntFlatten(script, term, bigInteger);
        } else {
            ApplicationTerm applicationTerm = SmtUtils.getFunctionApplication(term, "div");
            if (applicationTerm != null) {
                ArrayList<Term> arrayList = new ArrayList<Term>(Arrays.asList(applicationTerm.getParameters()));
                if (arrayList.size() < 2) {
                    throw new AssertionError();
                }
                arrayList.add(term2);
                term3 = script.term("div", arrayList.toArray(new Term[arrayList.size()]));
            } else {
                term3 = script.term("div", new Term[]{term, term2});
            }
        }
        return term3;
    }

    public static Term divIntFlatten(Script script, Term term, BigInteger bigInteger) {
        Term term2;
        ApplicationTerm applicationTerm = SmtUtils.getFunctionApplication(term, "div");
        if (applicationTerm != null) {
            ArrayList<Term> arrayList = new ArrayList<Term>(Arrays.asList(applicationTerm.getParameters()));
            if (arrayList.size() < 2) {
                throw new AssertionError();
            }
            Term term3 = (Term)arrayList.get(arrayList.size() - 1);
            Rational rational = SmtUtils.tryToConvertToLiteral(term3);
            if (rational != null && rational.compareTo(Rational.ONE) >= 0) {
                BigInteger bigInteger2 = rational.numerator();
                BigInteger bigInteger3 = bigInteger2.multiply(bigInteger);
                arrayList.set(arrayList.size() - 1, SmtUtils.constructIntValue(script, bigInteger3));
            } else {
                arrayList.add(SmtUtils.constructIntValue(script, bigInteger));
            }
            term2 = script.term("div", arrayList.toArray(new Term[arrayList.size()]));
        } else {
            term2 = script.term("div", new Term[]{term, SmtUtils.constructIntValue(script, bigInteger)});
        }
        return term2;
    }

    public static Term division(Script script, Sort sort, Term ... termArray) {
        if (SmtSortUtils.isRealSort(sort)) {
            return SmtUtils.divReal(script, termArray);
        }
        if (SmtSortUtils.isIntSort(sort)) {
            return SmtUtils.divInt(script, termArray);
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            throw new UnsupportedOperationException("Division with simplifications for bitvectors is not yet supported");
        }
        if (SmtSortUtils.isFloatingpointSort(sort)) {
            throw new UnsupportedOperationException("Division with simplifications for floats is not yet supported");
        }
        throw new AssertionError((Object)("Division does not make sense for sort " + String.valueOf(sort)));
    }

    public static Term mod(Script script, Term term, Term term2) {
        Rational rational = SmtUtils.tryToConvertToLiteral(term2);
        if (rational == null) {
            return script.term("mod", new Term[]{term, term2});
        }
        assert (rational.isIntegral());
        AbstractGeneralizedAffineTerm abstractGeneralizedAffineTerm = (AbstractGeneralizedAffineTerm)PolynomialTermTransformer.convert(script, term);
        return abstractGeneralizedAffineTerm.mod(script, rational.numerator()).toTerm(script);
    }

    public static Optional<BigDecimal> toDecimal(Rational rational) {
        if (!rational.isRational()) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(rational.numerator()).divide(new BigDecimal(rational.denominator())));
    }

    public static BigInteger toInt(Rational rational) {
        if (!rational.isIntegral()) {
            throw new IllegalArgumentException("dividend has to be integral");
        }
        if (!rational.denominator().equals(BigInteger.ONE)) {
            throw new IllegalArgumentException("denominator has to be one");
        }
        return rational.numerator();
    }

    public static Rational toRational(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length == 2) {
            return Rational.valueOf((BigInteger)new BigInteger(stringArray[0]), (BigInteger)new BigInteger(stringArray[1]));
        }
        if (stringArray.length == 1) {
            return SmtUtils.toRational(new BigDecimal(string));
        }
        throw new IllegalArgumentException("Not a valid real literal value: " + string);
    }

    public static Term rational2Term(Script script, Rational rational, Sort sort) {
        if (SmtSortUtils.isNumericSort(sort)) {
            return rational.toTerm(sort);
        }
        if (!SmtSortUtils.isBitvecSort(sort)) {
            throw new AssertionError((Object)(ERROR_MSG_UNKNOWN_SORT + String.valueOf(sort)));
        }
        if (rational.isIntegral() && rational.isRational()) {
            return BitvectorUtils.constructTerm(script, rational.numerator(), sort);
        }
        throw new IllegalArgumentException("unable to convert rational to bitvector if not integer");
    }

    public static Rational tryToConvertToLiteral(Term term) {
        BitvectorConstant bitvectorConstant;
        Rational rational = SmtSortUtils.isBitvecSort(term.getSort()) ? ((bitvectorConstant = BitvectorUtils.constructBitvectorConstant(term)) != null ? Rational.valueOf((BigInteger)bitvectorConstant.getValue(), (BigInteger)BigInteger.ONE) : null) : (SmtSortUtils.isNumericSort(term.getSort()) ? (term instanceof ConstantTerm ? SmtUtils.toRational((ConstantTerm)term) : null) : null);
        return rational;
    }

    public static Script.LBool checkSatDebug(Script script, Term term, ILogger iLogger) {
        script.push(1);
        try {
            Object object;
            TermVariable termVariable;
            Term[] termArray = term.getFreeVars();
            HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                termVariable = termArray2[n2];
                object = SmtUtils.termVariable2PseudofreshConstant(script, termVariable);
                hashMap.put(termVariable, (Term)object);
                ++n2;
            }
            termVariable = new HashMap();
            Term[] termArray3 = SmtUtils.getConjuncts(term);
            n = 0;
            while (n < termArray3.length) {
                termArray2 = PureSubstitution.apply(script, hashMap, termArray3[n]);
                object = "conjunct" + n;
                Annotation annotation = new Annotation(":named", object);
                Term term2 = script.annotate((Term)termArray2, new Annotation[]{annotation});
                termVariable.put(script.term((String)object, new Term[0]), termArray3[n]);
                script.assertTerm(term2);
                ++n;
            }
            Script.LBool lBool = script.checkSat();
            if (lBool == Script.LBool.UNSAT) {
                Term[] termArray4 = termArray2 = script.getUnsatCore();
                int n3 = termArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = termArray4[n4];
                    Term term3 = (Term)termVariable.get(object);
                    iLogger.debug((Object)("in uc: " + String.valueOf(term3)));
                    ++n4;
                }
            }
            script.pop(1);
            return lBool;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)("Exception during satisfiablity check: " + exception.getMessage()));
        }
    }

    private static Term termVariable2PseudofreshConstant(Script script, TermVariable termVariable) {
        String string = termVariable.getName() + "_const_" + termVariable.hashCode();
        Sort sort = termVariable.getSort();
        script.declareFun(string, new Sort[0], sort);
        return script.term(string, new Term[0]);
    }

    public static Rational toRational(ConstantTerm constantTerm) {
        if (!SmtSortUtils.isNumericSort(constantTerm.getSort())) {
            throw new AssertionError((Object)"Can convert only numeric sorts to Rationals");
        }
        Object object = constantTerm.getValue();
        if (object instanceof Rational) {
            return (Rational)object;
        }
        if (object instanceof BigInteger) {
            return SmtUtils.toRational((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return SmtUtils.toRational((BigDecimal)object);
        }
        throw new AssertionError((Object)"Value has to be either BigInteger, Decimal, or Rational");
    }

    public static boolean occursAtMostAsLhs(TermVariable termVariable, ApplicationTerm applicationTerm) {
        if (applicationTerm.getParameters().length != 2) {
            return !Arrays.asList(applicationTerm.getFreeVars()).contains(termVariable);
        }
        if (Arrays.asList(applicationTerm.getParameters()[1].getFreeVars()).contains(termVariable)) {
            return false;
        }
        if (applicationTerm.getParameters()[0].equals(termVariable)) {
            return true;
        }
        return !Arrays.asList(applicationTerm.getParameters()[0].getFreeVars()).contains(termVariable);
    }

    public static Term quantifier(Script script, int n, Collection<TermVariable> collection, Term term) {
        TermVariable[] termVariableArray;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Term term2 = term;
        Set set = Arrays.stream(term2.getFreeVars()).collect(Collectors.toSet());
        collection.stream().filter(set::contains).forEach(termVariable -> {
            TermVariable termVariable2 = linkedHashMap.put(termVariable.getName(), termVariable);
        });
        while (term2 instanceof QuantifiedFormula && ((QuantifiedFormula)term2).getQuantifier() == n) {
            termVariableArray = (TermVariable[])term2;
            term2 = termVariableArray.getSubformula();
            set = Arrays.stream(term2.getFreeVars()).collect(Collectors.toSet());
            Arrays.stream(termVariableArray.getVariables()).filter(set::contains).forEach(termVariable -> {
                TermVariable termVariable2 = linkedHashMap.put(termVariable.getName(), termVariable);
            });
        }
        if (linkedHashMap.isEmpty()) {
            return term;
        }
        termVariableArray = (TermVariable[])linkedHashMap.entrySet().stream().map(Map.Entry::getValue).toArray(TermVariable[]::new);
        return script.quantifier(n, termVariableArray, term2, (Term[][])new Term[0][]);
    }

    public static List<TermVariable> projectToFreeVars(List<TermVariable> list, Term term) {
        Set set = Arrays.stream(term.getFreeVars()).collect(Collectors.toSet());
        List<TermVariable> list2 = list.stream().filter(set::contains).collect(Collectors.toList());
        return list2;
    }

    public static Set<TermVariable> projectToFreeVars(Set<TermVariable> set, Term term) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (TermVariable termVariable : Arrays.asList(term.getFreeVars())) {
            if (!set.contains(termVariable)) continue;
            hashSet.add(termVariable);
        }
        return hashSet;
    }

    public static QuantifiedFormula isQuantifiedFormulaWithSameQuantifier(int n, Term term) {
        QuantifiedFormula quantifiedFormula;
        if (term instanceof QuantifiedFormula && n == (quantifiedFormula = (QuantifiedFormula)term).getQuantifier()) {
            return quantifiedFormula;
        }
        return null;
    }

    public static boolean isFunctionApplication(Term term, String string) {
        FunctionSymbol functionSymbol;
        return term instanceof ApplicationTerm && (functionSymbol = ((ApplicationTerm)term).getFunction()).getName().equals(string);
    }

    public static ApplicationTerm getFunctionApplication(Term term, String string) {
        ApplicationTerm applicationTerm;
        if (term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getFunction().getName().equals(string)) {
            return applicationTerm;
        }
        return null;
    }

    public static boolean isIntDiv(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
        if (functionSymbol.isIntern()) {
            return ((ApplicationTerm)term).getFunction().getName().equals("div");
        }
        return false;
    }

    public static boolean isIntMod(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
        if (functionSymbol.isIntern()) {
            return ((ApplicationTerm)term).getFunction().getName().equals("mod");
        }
        return false;
    }

    public static Term toDnf(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term) {
        return new DnfTransformer(managedScript, iUltimateServiceProvider).transform(term);
    }

    public static Term toNnf(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term) {
        return new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.PULL).transform(term);
    }

    public static Term toCnf(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term) {
        return new CnfTransformer(managedScript, iUltimateServiceProvider).transform(term);
    }

    public static boolean isSortForWhichWeCanGetValues(Sort sort) {
        return SmtSortUtils.isNumericSort(sort) || SmtSortUtils.isBoolSort(sort) || SmtSortUtils.isBitvecSort(sort) || SmtSortUtils.isFloatingpointSort(sort);
    }

    public static Map<Term, Term> getValues(Script script, Collection<Term> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyMap();
        }
        Term[] termArray = collection.toArray(new Term[collection.size()]);
        Map map = script.getValue(termArray);
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put((Term)entry.getKey(), SmtUtils.makeAffineIfPossible(script, (Term)entry.getValue()));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static Term makeAffineIfPossible(Script script, Term term) {
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(script).transform(term);
        if (affineTerm.isErrorTerm()) {
            return term;
        }
        return affineTerm.toTerm(script);
    }

    public static Term constructPositiveNormalForm(Script script, Term term) {
        Term term2 = new AffineSubtermNormalizer(script).transform(term);
        assert (Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, term2})) != Script.LBool.SAT);
        return term2;
    }

    public static int getOtherQuantifier(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public static String getCorrespondingFiniteConnective(int n) {
        if (n == 0) {
            return "or";
        }
        if (n == 1) {
            return "and";
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public static Term constructIntValue(Script script, BigInteger bigInteger) {
        return Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE).toTerm(SmtSortUtils.getIntSort(script));
    }

    public static Term constructIntegerValue(Script script, Sort sort, BigInteger bigInteger) {
        if (SmtSortUtils.isIntSort(sort)) {
            return SmtUtils.constructIntValue(script, bigInteger);
        }
        if (SmtSortUtils.isRealSort(sort)) {
            return script.decimal(new BigDecimal(bigInteger));
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            return BitvectorUtils.constructTerm(script, bigInteger, sort);
        }
        throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + String.valueOf(sort));
    }

    public static Term filterFormula(Term term, Set<TermVariable> set, Script script) {
        Term[] termArray = SmtUtils.getConjuncts(term);
        ArrayList<Term> arrayList = new ArrayList<Term>(termArray.length);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray2[n2];
            HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(term2.getFreeVars()));
            if (DataStructureUtils.haveNonEmptyIntersection(hashSet, set)) {
                arrayList.add(term2);
            }
            ++n2;
        }
        return SmtUtils.and(script, arrayList);
    }

    public static boolean areFormulasEquivalent(Term term, Term term2, Script script) {
        return SmtUtils.checkEquivalence(term, term2, script) == Script.LBool.UNSAT;
    }

    public static Script.LBool checkEquivalence(Term term, Term term2, Script script) {
        Term term3 = script.term("distinct", new Term[]{term, term2});
        return Util.checkSat((Script)script, (Term)term3);
    }

    public static Script.LBool checkImplication(Term term, Term term2, Script script) {
        Term term3 = SmtUtils.and(script, term, SmtUtils.not(script, term2));
        return Util.checkSat((Script)script, (Term)term3);
    }

    public static Script.LBool checkEquivalenceUnderAssumption(Term term, Term term2, Term term3, Script script) {
        Term term4 = SmtUtils.binaryEquality(script, term, term2);
        Term term5 = SmtUtils.implies(script, term3, term4);
        return Util.checkSat((Script)script, (Term)SmtUtils.not(script, term5));
    }

    public static void checkLogicalEquivalenceForDebugging(Script script, Term term, Term term2, Class<?> clazz, boolean bl) {
        script.echo(new QuotedObject(String.format("Start correctness check for %s.", clazz.getSimpleName())));
        Script.LBool lBool = SmtUtils.checkEquivalence(term, term2, script);
        script.echo(new QuotedObject(String.format("Finished correctness check for %s. Result: " + String.valueOf(lBool), clazz.getSimpleName())));
        String string = switch (lBool) {
            case Script.LBool.SAT -> "%s: Not equivalent to expected result: %s Input: %s".formatted(clazz.getSimpleName(), term, term2);
            case Script.LBool.UNKNOWN -> "%s: Insufficient ressources for checking equivalence to expected result: %s Input: %s".formatted(clazz.getSimpleName(), term, term2);
            case Script.LBool.UNSAT -> null;
            default -> throw new MatchException(null, null);
        };
        if (lBool == Script.LBool.SAT || !bl && lBool == Script.LBool.UNKNOWN) {
            throw new AssertionError((Object)string);
        }
    }

    public static boolean areFormulasEquivalent(Term term, Term term2, Term term3, Script script) {
        Term term4 = SmtUtils.binaryEquality(script, term, term2);
        Term term5 = SmtUtils.implies(script, term3, term4);
        return Util.checkSat((Script)script, (Term)SmtUtils.not(script, term5)) == Script.LBool.UNSAT;
    }

    public static int getDimension(Sort sort) {
        int n = 0;
        while (sort.isArraySort()) {
            sort = sort.getArguments()[1];
            ++n;
        }
        return n;
    }

    public static Pair<Script.LBool, Term> interpolateBinary(Script script, Term term, Term term2) {
        script.push(1);
        try {
            Term term3 = SmtUtils.annotateAndAssert(script, term, "first");
            Term term4 = SmtUtils.annotateAndAssert(script, term2, "second");
            Script.LBool lBool = script.checkSat();
            Pair pair = switch (lBool) {
                case Script.LBool.UNSAT -> {
                    Term[] var6_6 = script.getInterpolants(new Term[]{term3, term4});
                    if (!($assertionsDisabled || var6_6 != null && var6_6.length == 1)) {
                        throw new AssertionError();
                    }
                    yield new Pair((Object)lBool, (Object)var6_6[0]);
                }
                case Script.LBool.UNKNOWN, Script.LBool.SAT -> new Pair((Object)lBool, null);
                default -> throw new MatchException(null, null);
            };
            return pair;
        }
        finally {
            script.pop(1);
        }
    }

    public static Term annotateAndAssert(Script script, Term term, String string) {
        assert (term.getFreeVars().length == 0) : "Term has free vars";
        Annotation annotation = new Annotation(":named", (Object)string);
        Term term2 = script.annotate(term, new Annotation[]{annotation});
        script.assertTerm(term2);
        return script.term(string, new Term[0]);
    }

    public static Term constructNamedTerm(Script script, Term term, String string) {
        Annotation annotation = new Annotation(":named", (Object)string);
        Term term2 = script.annotate(term, new Annotation[]{annotation});
        return term2;
    }

    public static QuotedObject echo(Script script, String string) {
        return script.echo(new QuotedObject(string));
    }

    public static boolean isUnaryNumericMinus(FunctionSymbol functionSymbol) {
        return functionSymbol.isIntern() && functionSymbol.getName().equals("-") && functionSymbol.getParameterSorts().length == 1 && functionSymbol.getParameterSorts()[0].isNumericSort() && functionSymbol.getReturnSort().isNumericSort();
    }

    public static boolean isSubterm(Term term, Term term3) {
        if (term3 instanceof TermVariable) {
            return Arrays.asList(term.getFreeVars()).contains(term3);
        }
        return new SubtermPropertyChecker(term2 -> term2.equals(term3)).isSatisfiedBySomeSubterm(term);
    }

    public static Rational toRational(long l) {
        return Rational.valueOf((long)l, (long)1L);
    }

    public static Rational toRational(int n) {
        return Rational.valueOf((long)n, (long)1L);
    }

    public static Rational toRational(BigInteger bigInteger) {
        return Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
    }

    public static Rational toRational(BigDecimal bigDecimal) {
        Rational rational;
        if (bigDecimal.scale() <= 0) {
            BigInteger bigInteger = bigDecimal.toBigInteger();
            rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
        } else {
            BigInteger bigInteger = bigDecimal.unscaledValue();
            BigInteger bigInteger2 = BigInteger.TEN.pow(bigDecimal.scale());
            rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)bigInteger2);
        }
        return rational;
    }

    public static Rational gcd(Collection<Rational> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Need at least one rational");
        }
        return collection.stream().reduce(SmtUtils::gcd).orElseThrow();
    }

    public static Rational gcd(Rational rational, Rational rational2) {
        BigInteger bigInteger = Rational.gcd((BigInteger)rational.numerator().multiply(rational2.denominator()), (BigInteger)rational2.numerator().multiply(rational.denominator()));
        BigInteger bigInteger2 = rational.denominator().multiply(rational2.denominator());
        return Rational.valueOf((BigInteger)bigInteger, (BigInteger)bigInteger2);
    }

    public static String toString(Rational rational) {
        Optional<BigDecimal> optional = SmtUtils.toDecimal(rational);
        return optional.isPresent() ? optional.get().toPlainString() : rational.toString();
    }

    public static Set<FunctionSymbol> extractNonTheoryFunctionSymbols(Term term2) {
        Set<Term> set = SubTermFinder.find(term2, term -> term instanceof ApplicationTerm, false);
        return set.stream().map(term -> ((ApplicationTerm)term).getFunction()).filter(functionSymbol -> !functionSymbol.isIntern()).collect(Collectors.toSet());
    }

    public static Set<ApplicationTerm> extractApplicationTerms(String string, Term term2, boolean bl) {
        return SubTermFinder.find(term2, term -> SmtUtils.isFunctionApplication(term, string), bl);
    }

    public static Set<ApplicationTerm> extractApplicationTerms(Set<String> set, Term term2, boolean bl) {
        return SubTermFinder.find(term2, term -> set.stream().anyMatch(string -> SmtUtils.isFunctionApplication(term, string)), bl);
    }

    public static Set<ApplicationTerm> extractConstants(Term term2, boolean bl) {
        Predicate<Term> predicate = bl ? term -> SmtUtils.isConstant(term) && term instanceof ApplicationTerm && !((ApplicationTerm)term).getFunction().isIntern() : SmtUtils::isConstant;
        return SubTermFinder.find(term2, predicate, false);
    }

    public static Term unzipNot(Term term) {
        ApplicationTerm applicationTerm;
        if (term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getFunction().isIntern() && applicationTerm.getFunction().getName().equals("not")) {
            return applicationTerm.getParameters()[0];
        }
        return null;
    }

    public static Term flattenIntoFirstArgument(Script script, String string, Term term, Term ... termArray) {
        ArrayList<Term> arrayList;
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getApplicationString().equals(string)) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            arrayList = new ArrayList(applicationTerm.getParameters().length + termArray.length);
            arrayList.addAll(Arrays.asList(applicationTerm.getParameters()));
            arrayList.addAll(Arrays.asList(termArray));
        } else {
            arrayList = new ArrayList<Term>(termArray.length + 1);
            arrayList.add(term);
            arrayList.addAll(Arrays.asList(termArray));
        }
        return script.term(string, arrayList.toArray(new Term[arrayList.size()]));
    }

    public static Term oldAPITerm(Script script, String string, BigInteger[] bigIntegerArray, Sort sort, Term[] termArray) {
        return script.term(string, SmtUtils.toStringArray(bigIntegerArray), sort, termArray);
    }

    public static final BigInteger[] toBigIntegerArray(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return EMPTY_INDICES_BI;
        }
        BigInteger[] bigIntegerArray = new BigInteger[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            bigIntegerArray[n] = new BigInteger(stringArray[n]);
            ++n;
        }
        return bigIntegerArray;
    }

    public static final String[] toStringArray(BigInteger ... bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        if (bigIntegerArray.length == 0) {
            return EMPTY_INDICES;
        }
        String[] stringArray = new String[bigIntegerArray.length];
        int n = 0;
        while (n < bigIntegerArray.length) {
            stringArray[n] = bigIntegerArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public static double approximateAsDouble(Rational rational) {
        return rational.numerator().doubleValue() / rational.denominator().doubleValue();
    }

    public static boolean isBvMinusOneButNotOne(Rational rational, Sort sort) {
        if (SmtSortUtils.getBitvectorLength(sort) == 1) {
            return false;
        }
        if (rational.equals((Object)Rational.MONE)) {
            return true;
        }
        int n = SmtSortUtils.getBitvectorLength(sort);
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(n).subtract(BigInteger.ONE);
        Rational rational2 = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
        return rational.equals((Object)rational2);
    }

    public BigInteger computeSmallestRepresentableBitvector(Sort sort, RelationSymbol.BvSignedness bvSignedness) {
        return null;
    }

    public BigInteger computeLargestRepresentableBitvector(Sort sort, RelationSymbol.BvSignedness bvSignedness) {
        return null;
    }

    public static boolean isAbsorbingElement(String string, Term term) {
        if (string.equals("and")) {
            return SmtUtils.isFalseLiteral(term);
        }
        if (string.equals("or")) {
            return SmtUtils.isTrueLiteral(term);
        }
        throw new AssertionError((Object)("unsupported connective " + string));
    }

    public static boolean isNeutralElement(String string, Term term) {
        if (string.equals("and")) {
            return SmtUtils.isTrueLiteral(term);
        }
        if (string.equals("or")) {
            return SmtUtils.isFalseLiteral(term);
        }
        throw new AssertionError((Object)("unsupported connective " + string));
    }

    public static Term replaceFreeVariablesByConstants(Script script, Term term) {
        TermVariable[] termVariableArray = term.getFreeVars();
        Term[] termArray = new Term[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            termArray[n] = SmtUtils.termVariable2constant(script, termVariableArray[n]);
            ++n;
        }
        return new FormulaUnLet().unlet(script.let(termVariableArray, termArray, term));
    }

    private static Term termVariable2constant(Script script, TermVariable termVariable) {
        String string = termVariable.getName() + "_const_" + termVariable.hashCode();
        Sort[] sortArray = new Sort[]{};
        Sort sort = termVariable.getSort();
        script.declareFun(string, sortArray, sort);
        return script.term(string, new Term[0]);
    }

    public static class ExtendedSimplificationResult {
        private final Term mSimplifiedTerm;
        private final long mSimplificationTimeNano;
        private final long mReductionOfTreeSize;
        private final double mReductionRatioInPercent;

        public ExtendedSimplificationResult(Term term, long l, long l2, double d) {
            this.mSimplifiedTerm = term;
            this.mSimplificationTimeNano = l;
            this.mReductionOfTreeSize = l2;
            this.mReductionRatioInPercent = d;
        }

        public Term getSimplifiedTerm() {
            return this.mSimplifiedTerm;
        }

        public long getSimplificationTimeNano() {
            return this.mSimplificationTimeNano;
        }

        public long getReductionOfTreeSize() {
            return this.mReductionOfTreeSize;
        }

        public double getReductionRatioInPercent() {
            return this.mReductionRatioInPercent;
        }

        public String buildSizeReductionMessage() {
            return String.format("treesize reduction %d, result has %2.1f percent of original size", this.getReductionOfTreeSize(), this.getReductionRatioInPercent());
        }
    }

    private static class InnerDualJunctTracker {
        private Set<Term> mInnerDualJuncts;

        private InnerDualJunctTracker() {
        }

        public void addOuterJunct(Term term, String string) {
            Term[] termArray = QuantifierUtils.getDualFiniteJuncts(QuantifierUtils.getCorrespondingQuantifier(string), term);
            if (this.mInnerDualJuncts == null) {
                this.mInnerDualJuncts = new HashSet<Term>(Arrays.asList(termArray));
            } else {
                this.mInnerDualJuncts.retainAll(Arrays.asList(termArray));
            }
        }

        public Set<Term> getInnerDualJuncts() {
            return this.mInnerDualJuncts;
        }
    }

    public static enum Junction {
        AND{

            public String toString() {
                return "and";
            }
        }
        ,
        OR{

            public String toString() {
                return "or";
            }
        };

    }

    public static enum SimplificationTechnique {
        SIMPLIFY_QUICK(true),
        SIMPLIFY_DDA(true),
        SIMPLIFY_DDA2(true),
        POLY_PAC(false),
        NATIVE(false),
        NONE(false);

        private final boolean mDetectsUnsatisfiability;

        private SimplificationTechnique(boolean bl) {
            this.mDetectsUnsatisfiability = bl;
        }

        public boolean detectsUnsatisfiability() {
            return this.mDetectsUnsatisfiability;
        }
    }
}

