/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.IBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashSet;
import java.util.Set;

public class EqualityInformation {
    private final int mIndex;
    private final Term mGivenTerm;
    private final Term mEqualTerm;
    private final RelationSymbol mRelationSymbol;

    public EqualityInformation(int n, Term term, Term term2, RelationSymbol relationSymbol) {
        this.mIndex = n;
        this.mGivenTerm = term;
        this.mEqualTerm = term2;
        this.mRelationSymbol = relationSymbol;
    }

    @Deprecated
    public int getIndex() {
        return this.mIndex;
    }

    public Term getGivenTerm() {
        return this.mGivenTerm;
    }

    public Term getRelatedTerm() {
        return this.mEqualTerm;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public static EqualityInformation getEqinfo(Script script, Term term, Term[] termArray, Term term2, int n) {
        EqualityInformation equalityInformation;
        IBinaryRelation iBinaryRelation;
        BinaryEqualityRelation[] binaryEqualityRelationArray = new BinaryEqualityRelation[termArray.length];
        int n2 = 0;
        while (n2 < termArray.length) {
            if (EqualityInformation.isSubterm(term, termArray[n2])) {
                binaryEqualityRelationArray[n2] = BinaryEqualityRelation.convert(termArray[n2]);
                if (binaryEqualityRelationArray[n2] != null) {
                    if (binaryEqualityRelationArray[n2].getRelationSymbol().equals((Object)RelationSymbol.EQ) && n == 1) {
                        binaryEqualityRelationArray[n2] = null;
                    } else if (binaryEqualityRelationArray[n2].getRelationSymbol().equals((Object)RelationSymbol.DISTINCT) && n == 0) {
                        binaryEqualityRelationArray[n2] = null;
                    } else {
                        iBinaryRelation = binaryEqualityRelationArray[n2];
                        equalityInformation = EqualityInformation.getEqinfo(term, (BinaryEqualityRelation)iBinaryRelation, term2, n2);
                        SolvedBinaryRelation solvedBinaryRelation = ((BinaryRelation)iBinaryRelation).solveForSubject(script, term);
                        if (solvedBinaryRelation != null && SmtUtils.isSubterm(solvedBinaryRelation.getRightHandSide(), term2)) {
                            solvedBinaryRelation = null;
                        }
                        assert (solvedBinaryRelation == null == (equalityInformation == null)) : "sbr: " + String.valueOf(solvedBinaryRelation) + " eqInfo: " + String.valueOf(equalityInformation);
                        if (equalityInformation != null) {
                            return equalityInformation;
                        }
                    }
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < termArray.length) {
            if (binaryEqualityRelationArray[n2] != null && (iBinaryRelation = PolynomialRelation.of(script, termArray[n2])) != null && (equalityInformation = EqualityInformation.getEqinfo(script, term, (PolynomialRelation)iBinaryRelation, term2, n2)) != null) {
                return equalityInformation;
            }
            ++n2;
        }
        return null;
    }

    public static EqualityInformation getEqinfo(Script script, Term term, PolynomialRelation polynomialRelation, Term term2, int n) {
        if (polynomialRelation.isVariable(term)) {
            SolvedBinaryRelation solvedBinaryRelation = polynomialRelation.solveForSubject(script, term);
            if (solvedBinaryRelation == null) {
                return null;
            }
            Term term3 = solvedBinaryRelation.getRightHandSide();
            if (term2 != null && EqualityInformation.isSubterm(term2, term3)) {
                return null;
            }
            return new EqualityInformation(n, term, term3, polynomialRelation.getRelationSymbol());
        }
        return null;
    }

    public static EqualityInformation getEqinfo(Term term, BinaryEqualityRelation binaryEqualityRelation, Term term2, int n) {
        Term term3 = binaryEqualityRelation.getLhs();
        Term term4 = binaryEqualityRelation.getRhs();
        if (!(!term3.equals(term) || EqualityInformation.isSubterm(term, term4) || term2 != null && EqualityInformation.isSubterm(term2, term4))) {
            return new EqualityInformation(n, term, term4, binaryEqualityRelation.getRelationSymbol());
        }
        if (!(!term4.equals(term) || EqualityInformation.isSubterm(term, term3) || term2 != null && EqualityInformation.isSubterm(term2, term3))) {
            return new EqualityInformation(n, term, term3, binaryEqualityRelation.getRelationSymbol());
        }
        return null;
    }

    public static Pair<Set<Term>, Set<Term>> getEqTerms(Script script, Term term, Term[] termArray, Term term2) {
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        int n = 0;
        while (n < termArray.length) {
            EqualityInformation equalityInformation;
            PolynomialRelation polynomialRelation = PolynomialRelation.of(script, termArray[n]);
            if (polynomialRelation != null && (equalityInformation = EqualityInformation.getEqinfo(script, term, polynomialRelation, term2, n)) != null) {
                switch (equalityInformation.getRelationSymbol()) {
                    case DISTINCT: {
                        hashSet2.add(equalityInformation.getRelatedTerm());
                        break;
                    }
                    case EQ: {
                        hashSet.add(equalityInformation.getRelatedTerm());
                        break;
                    }
                    case LEQ: 
                    case GEQ: 
                    case LESS: 
                    case GREATER: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            ++n;
        }
        return new Pair(hashSet, hashSet2);
    }

    private static boolean isSubterm(Term term, Term term2) {
        return SmtUtils.isSubterm(term2, term);
    }
}

