/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySegment;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.NonMemoryArrayStore;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.PointerBase;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.PointerBaseIntLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.PointerBaseVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AddressStoreFactory {
    private final Map<BigInteger, PointerBaseIntLiteral> mInt = new HashMap<BigInteger, PointerBaseIntLiteral>();
    private final NestedMap2<String, DeclarationInformation, PointerBaseVariable> mVariable = new NestedMap2();
    private final Map<PointerBase, MemorySegment> mSegment = new HashMap<PointerBase, MemorySegment>();
    private final NonMemoryArrayStore mArray = new NonMemoryArrayStore(NonMemoryArrayStore.ArrayOrStruct.ARRAY);
    private final NonMemoryArrayStore mStruct = new NonMemoryArrayStore(NonMemoryArrayStore.ArrayOrStruct.STRUCT);

    public PointerBaseIntLiteral getPointerBase(BigInteger bigInteger2) {
        return this.mInt.computeIfAbsent(bigInteger2, bigInteger -> new PointerBaseIntLiteral((BigInteger)bigInteger));
    }

    public PointerBaseVariable getPointerBase(String string2, DeclarationInformation declarationInformation) {
        Function<String, Function> function = string -> declarationInformation -> new PointerBaseVariable((String)string, (DeclarationInformation)declarationInformation);
        return (PointerBaseVariable)this.mVariable.computeIfAbsent((Object)string2, (Object)declarationInformation, function);
    }

    public MemorySegment getMemorySegment(PointerBase pointerBase) {
        return this.mSegment.computeIfAbsent(pointerBase, pointerBase2 -> new MemorySegment(pointerBase));
    }

    public NonMemoryArrayStore getArray() {
        return this.mArray;
    }

    public NonMemoryArrayStore getStruct() {
        return this.mStruct;
    }
}

