/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.CallSymbolAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.InternalSymbolAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.ReturnSymbolAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;

public class NestedwordAST
extends AtsASTNode {
    private static final long serialVersionUID = 498949013884049199L;
    private final ArrayList<String> mWord;
    private int msizeOfWordSymbols = 0;
    private final ArrayList<Integer> mNestingRelation;
    Deque<Integer> mCallPositions = new ArrayDeque<Integer>();
    public static final int INTERNAL_POSITION = -2;
    public static final int PLUS_INFINITY = Integer.MAX_VALUE;
    public static final int MINUS_INFINITY = Integer.MIN_VALUE;

    public NestedwordAST(ILocation iLocation) {
        super(iLocation);
        this.mWord = new ArrayList();
        this.mNestingRelation = new ArrayList();
        this.setType(NestedWord.class);
    }

    public void addSymbol(CallSymbolAST callSymbolAST) {
        this.mCallPositions.push(this.msizeOfWordSymbols);
        this.mWord.add(callSymbolAST.getSymbol());
        this.mNestingRelation.add(Integer.MAX_VALUE);
        ++this.msizeOfWordSymbols;
    }

    public void addSymbol(InternalSymbolAST internalSymbolAST) {
        this.mWord.add(internalSymbolAST.getSymbol());
        this.mNestingRelation.add(-2);
        ++this.msizeOfWordSymbols;
    }

    public void addSymbol(ReturnSymbolAST returnSymbolAST) {
        int n = this.msizeOfWordSymbols;
        this.mWord.add(returnSymbolAST.getSymbol());
        if (this.mCallPositions.isEmpty()) {
            this.mNestingRelation.add(Integer.MIN_VALUE);
        } else {
            int n2 = this.mCallPositions.pop();
            this.mNestingRelation.add(n2);
            this.mNestingRelation.set(n2, n);
        }
        ++this.msizeOfWordSymbols;
    }

    public boolean isNestedWordCorrect() {
        int[] nArray = new int[this.mNestingRelation.size()];
        int n = 0;
        while (n < this.mNestingRelation.size()) {
            nArray[n] = this.mNestingRelation.get(n);
            ++n;
        }
        return this.nestingRelationValuesInRange(nArray) && this.nestingEdgesDoNotCross(nArray) && this.nestingRelationSymmetricNestingEdges(nArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Nestedword [");
        int n = 0;
        while (n < this.msizeOfWordSymbols) {
            if (this.mNestingRelation.get(n) != -2 && this.mNestingRelation.get(n) < n) {
                stringBuilder.append(">" + this.mWord.get(n));
            } else if (this.mNestingRelation.get(n) > n) {
                stringBuilder.append(this.mWord.get(n) + "<");
            } else {
                stringBuilder.append(this.mWord.get(n));
            }
            stringBuilder.append(" ");
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private boolean nestingRelationValuesInRange(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (n3 != -2 && (n3 < 0 || n3 >= nArray.length) && n3 != Integer.MAX_VALUE && n3 != Integer.MIN_VALUE) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean nestingRelationSymmetricNestingEdges(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0 && nArray[n] < nArray.length && nArray[nArray[n]] != n) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean nestingEdgesDoNotCross(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0 && nArray[n] < nArray.length) {
                int n2 = n + 1;
                while (n2 < nArray[n]) {
                    if (nArray[n2] >= nArray[n]) {
                        return false;
                    }
                    if (nArray[n2] == Integer.MIN_VALUE) {
                        return false;
                    }
                    ++n2;
                }
                if (nArray[n] == n) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public String[] getWordSymbols() {
        String[] stringArray = new String[this.mWord.size()];
        int n = 0;
        while (n < this.mWord.size()) {
            stringArray[n] = this.mWord.get(n);
            ++n;
        }
        return stringArray;
    }

    public int[] getNestingRelation() {
        int[] nArray = new int[this.mNestingRelation.size()];
        int n = 0;
        while (n < this.mNestingRelation.size()) {
            nArray[n] = this.mNestingRelation.get(n);
            ++n;
        }
        return nArray;
    }

    @Override
    public String getAsString() {
        return this.toString().substring(11);
    }
}

