/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import java.util.AbstractQueue;
import java.util.Iterator;

public class AtomQueue
extends AbstractQueue<DPLLAtom> {
    DPLLAtom[] mAtoms = new DPLLAtom[100];
    int mSize = 0;

    @Override
    public Iterator<DPLLAtom> iterator() {
        return new Iterator<DPLLAtom>(){
            int mPos = 0;

            @Override
            public boolean hasNext() {
                return this.mPos < AtomQueue.this.mSize;
            }

            @Override
            public DPLLAtom next() {
                return AtomQueue.this.mAtoms[this.mPos++];
            }

            @Override
            public void remove() {
                AtomQueue.this.remove(AtomQueue.this.mAtoms[this.mPos - 1]);
            }
        };
    }

    @Override
    public int size() {
        return this.mSize;
    }

    private void sink(DPLLAtom dPLLAtom, int n) {
        int n2;
        while (n > 0 && this.mAtoms[n2 = (n - 1) / 2].compareActivityTo(dPLLAtom) > 0) {
            this.mAtoms[n] = this.mAtoms[n2];
            this.mAtoms[n].mAtomQueueIndex = n;
            n = n2;
        }
        this.mAtoms[n] = dPLLAtom;
        dPLLAtom.mAtomQueueIndex = n;
    }

    @Override
    public boolean offer(DPLLAtom dPLLAtom) {
        assert (dPLLAtom.mAtomQueueIndex == -1 || this.mAtoms[dPLLAtom.mAtomQueueIndex] == dPLLAtom);
        if (dPLLAtom.mAtomQueueIndex != -1) {
            return false;
        }
        if (this.mSize >= this.mAtoms.length) {
            DPLLAtom[] dPLLAtomArray = new DPLLAtom[2 * this.mSize];
            System.arraycopy(this.mAtoms, 0, dPLLAtomArray, 0, this.mSize);
            this.mAtoms = dPLLAtomArray;
        }
        this.sink(dPLLAtom, this.mSize++);
        return true;
    }

    @Override
    public DPLLAtom peek() {
        assert (this.mSize <= 1 || this.mAtoms[0].compareActivityTo(this.mAtoms[1]) <= 0);
        assert (this.mSize <= 2 || this.mAtoms[0].compareActivityTo(this.mAtoms[2]) <= 0);
        return this.mAtoms[0];
    }

    @Override
    public DPLLAtom poll() {
        DPLLAtom dPLLAtom = this.mAtoms[0];
        this.remove(dPLLAtom);
        return dPLLAtom;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof DPLLAtom)) {
            return false;
        }
        assert (((DPLLAtom)object).mAtomQueueIndex == -1 || this.mAtoms[((DPLLAtom)object).mAtomQueueIndex] == object);
        return ((DPLLAtom)object).mAtomQueueIndex != -1;
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof DPLLAtom)) {
            return false;
        }
        DPLLAtom dPLLAtom = (DPLLAtom)object;
        if (dPLLAtom.mAtomQueueIndex == -1) {
            return false;
        }
        assert (this.mAtoms[dPLLAtom.mAtomQueueIndex] == dPLLAtom);
        int n = dPLLAtom.mAtomQueueIndex;
        dPLLAtom.mAtomQueueIndex = -1;
        while (2 * n + 2 < this.mSize) {
            int n2 = 2 * n + 1;
            if (this.mAtoms[n2].compareActivityTo(this.mAtoms[n2 + 1]) > 0) {
                ++n2;
            }
            this.mAtoms[n] = this.mAtoms[n2];
            this.mAtoms[n].mAtomQueueIndex = n;
            n = n2;
        }
        if (n != --this.mSize) {
            this.sink(this.mAtoms[this.mSize], n);
        }
        this.mAtoms[this.mSize] = null;
        return true;
    }
}

