/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MatrixEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.TableauxRow;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LinVar
implements Comparable<LinVar> {
    Object mName;
    LiteralReason mUpperLiteral;
    LiteralReason mLowerLiteral;
    LAReason mUpper;
    LAReason mLower;
    private ExactInfinitesimalNumber mCurval;
    boolean mIsInt;
    NavigableMap<InfinitesimalNumber, BoundConstraint> mConstraints = new TreeMap<InfinitesimalNumber, BoundConstraint>();
    NavigableMap<InfinitesimalNumber, LAEquality> mEqualities = new TreeMap<InfinitesimalNumber, LAEquality>();
    Map<Rational, LAEquality> mDisequalities;
    boolean mBasic;
    final int mMatrixpos;
    LinVar[] mCachedRowVars;
    Rational[] mCachedRowCoeffs;
    int mAssertionstacklevel;
    ExactInfinitesimalNumber mExactVal = null;
    static final LinVar DUMMY_LINVAR = new LinVar();

    private LinVar() {
        this.mName = "Dummy";
        this.mMatrixpos = Integer.MAX_VALUE;
    }

    public LinVar(Object object, boolean bl, int n, int n2) {
        this.mName = object;
        this.mCurval = ExactInfinitesimalNumber.ZERO;
        this.mIsInt = bl;
        this.mBasic = false;
        this.mMatrixpos = n2;
        this.mAssertionstacklevel = n;
    }

    public final InfinitesimalNumber getUpperBound() {
        return this.mUpperLiteral == null ? InfinitesimalNumber.POSITIVE_INFINITY : this.mUpperLiteral.getBound();
    }

    public final InfinitesimalNumber getLowerBound() {
        return this.mLowerLiteral == null ? InfinitesimalNumber.NEGATIVE_INFINITY : this.mLowerLiteral.getBound();
    }

    public final InfinitesimalNumber getTightUpperBound() {
        return this.mUpper == null ? InfinitesimalNumber.POSITIVE_INFINITY : this.mUpper.getBound();
    }

    public final InfinitesimalNumber getTightLowerBound() {
        return this.mLower == null ? InfinitesimalNumber.NEGATIVE_INFINITY : this.mLower.getBound();
    }

    public InfinitesimalNumber getExactUpperBound() {
        return this.mUpper == null ? InfinitesimalNumber.POSITIVE_INFINITY : this.mUpper.getExactBound();
    }

    public InfinitesimalNumber getExactLowerBound() {
        return this.mLower == null ? InfinitesimalNumber.NEGATIVE_INFINITY : this.mLower.getExactBound();
    }

    public final boolean hasTightUpperBound() {
        return this.mUpper != null;
    }

    public final boolean hasTightLowerBound() {
        return this.mLower != null;
    }

    public String toString() {
        return this.mName.toString();
    }

    public boolean isInitiallyBasic() {
        return this.mName instanceof LinTerm;
    }

    public int hashCode() {
        return this.mMatrixpos;
    }

    @Override
    public final int compareTo(LinVar linVar) {
        return this.mMatrixpos - linVar.mMatrixpos;
    }

    public boolean outOfBounds() {
        if (this.mUpperLiteral != null && this.mCurval.compareTo(this.mUpperLiteral.getBound()) > 0) {
            return true;
        }
        return this.mLowerLiteral != null && this.mCurval.compareTo(this.mLowerLiteral.getExactBound()) < 0;
    }

    void addDiseq(LAEquality lAEquality) {
        if (this.mDisequalities == null) {
            this.mDisequalities = new HashMap<Rational, LAEquality>();
        }
        this.mDisequalities.put(lAEquality.getBound(), lAEquality);
    }

    void removeDiseq(LAEquality lAEquality) {
        if (this.mDisequalities != null) {
            this.mDisequalities.remove(lAEquality.getBound());
        }
    }

    LAEquality getDiseq(Rational rational) {
        if (this.mDisequalities != null) {
            return this.mDisequalities.get(rational);
        }
        return null;
    }

    public void addEquality(LAEquality lAEquality) {
        this.mEqualities.put(new InfinitesimalNumber(lAEquality.getBound(), 0), lAEquality);
    }

    boolean unconstrained() {
        return this.mConstraints.isEmpty() && this.mEqualities.isEmpty();
    }

    boolean isCurrentlyUnconstrained() {
        return this.mLower == null && this.mUpper == null;
    }

    public boolean isInt() {
        return this.mIsInt;
    }

    public InfinitesimalNumber getEpsilon() {
        return this.mIsInt ? InfinitesimalNumber.ONE : InfinitesimalNumber.EPSILON;
    }

    public Map<LinVar, BigInteger> getLinTerm() {
        return (LinTerm)this.mName;
    }

    public Term getTerm() {
        return (Term)this.mName;
    }

    public boolean checkCoeffChain(LinArSolve linArSolve) {
        if (!this.mBasic) {
            return true;
        }
        MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
        BigInteger bigInteger = linArSolve.mTableaux.get(this.mMatrixpos).getRawCoeff(0);
        mutableAffineTerm.add(Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE), this);
        for (MatrixEntry matrixEntry : this.getTableauxRow(linArSolve)) {
            assert (matrixEntry.getRow() == this);
            assert (!matrixEntry.getColumn().mBasic);
            assert (linArSolve.mDependentRows.get(matrixEntry.getColumn().mMatrixpos).get(this.mMatrixpos));
            mutableAffineTerm.add(Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)BigInteger.ONE), matrixEntry.getColumn());
        }
        assert (mutableAffineTerm.isConstant() && mutableAffineTerm.getConstant().equals(InfinitesimalNumber.ZERO));
        return true;
    }

    public boolean isFixed() {
        return this.mUpper != null && this.mLower != null && this.mUpper.getBound().equals(this.mLower.getBound());
    }

    public LAEquality getEquality(InfinitesimalNumber infinitesimalNumber) {
        return (LAEquality)this.mEqualities.get(infinitesimalNumber);
    }

    public final ExactInfinitesimalNumber getValue() {
        return this.mCurval;
    }

    public final void setValue(ExactInfinitesimalNumber exactInfinitesimalNumber) {
        this.mCurval = exactInfinitesimalNumber;
    }

    public final void addValue(ExactInfinitesimalNumber exactInfinitesimalNumber) {
        this.mCurval = this.mCurval.add(exactInfinitesimalNumber);
    }

    private boolean checkReasonChain(LAReason lAReason, LiteralReason literalReason) {
        while (lAReason != null) {
            if (lAReason instanceof LiteralReason) {
                assert (lAReason == literalReason);
                literalReason = literalReason.getOldLiteralReason();
            }
            lAReason = lAReason.getOldReason();
        }
        assert (literalReason == null);
        return true;
    }

    public boolean checkReasonChains() {
        return this.checkReasonChain(this.mUpper, this.mUpperLiteral) && this.checkReasonChain(this.mLower, this.mLowerLiteral);
    }

    public Iterable<MatrixEntry> getTableauxRow(final LinArSolve linArSolve) {
        assert (this.mBasic);
        final TableauxRow tableauxRow = linArSolve.mTableaux.get(this.mMatrixpos);
        assert (tableauxRow != null);
        return new Iterable<MatrixEntry>(){

            @Override
            public Iterator<MatrixEntry> iterator() {
                return new Iterator<MatrixEntry>(){
                    private int pos = 1;

                    @Override
                    public boolean hasNext() {
                        return this.pos < tableauxRow.size();
                    }

                    @Override
                    public MatrixEntry next() {
                        return new MatrixEntry(linArSolve, tableauxRow, this.pos++);
                    }
                };
            }
        };
    }

    public Iterable<MatrixEntry> getTableauxColumn(final LinArSolve linArSolve) {
        assert (!this.mBasic);
        final BitSet bitSet = linArSolve.mDependentRows.get(this.mMatrixpos);
        return new Iterable<MatrixEntry>(){

            @Override
            public Iterator<MatrixEntry> iterator() {
                return new Iterator<MatrixEntry>(){
                    private int mRowIdx;
                    {
                        this.mRowIdx = bitSet2.nextSetBit(0);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mRowIdx != -1;
                    }

                    @Override
                    public MatrixEntry next() {
                        TableauxRow tableauxRow = linArSolve.mTableaux.get(this.mRowIdx);
                        MatrixEntry matrixEntry = new MatrixEntry(linArSolve, tableauxRow, tableauxRow.findRawIndex((this).LinVar.this.mMatrixpos));
                        if (!$assertionsDisabled && matrixEntry.getColumn() != LinVar.this) {
                            throw new AssertionError();
                        }
                        this.mRowIdx = bitSet.nextSetBit(this.mRowIdx + 1);
                        return matrixEntry;
                    }
                };
            }
        };
    }
}

