/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeStatement;
import java.util.List;
import java.util.function.Predicate;

public final class CodeForBehavior
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(CodeForBehavior.class);
    String[] behaviorNames;
    CodeStatement codeStmt;

    public CodeForBehavior(String[] stringArray, CodeStatement codeStatement) {
        this.behaviorNames = stringArray;
        this.codeStmt = codeStatement;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid CodeForBehavior: " + String.valueOf(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CodeForBehavior").append('[');
        if (this.behaviorNames == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.behaviorNames.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.behaviorNames[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append(this.codeStmt);
        return stringBuffer.append(']').toString();
    }

    public String[] getBehaviorNames() {
        return this.behaviorNames;
    }

    public CodeStatement getCodeStmt() {
        return this.codeStmt;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.codeStmt);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (aCSLVisitor.visit(this) && this.codeStmt != null) {
            this.codeStmt.accept(aCSLVisitor);
        }
    }

    @Override
    public CodeForBehavior accept(ACSLTransformer aCSLTransformer) {
        CodeForBehavior codeForBehavior = aCSLTransformer.transform(this);
        if (codeForBehavior != this) {
            return codeForBehavior;
        }
        CodeStatement codeStatement = null;
        if (this.codeStmt != null) {
            codeStatement = this.codeStmt.accept(aCSLTransformer);
        }
        if (this.codeStmt != codeStatement) {
            return new CodeForBehavior(this.behaviorNames, codeStatement);
        }
        return this;
    }
}

