/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Case;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LogicStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Parameter;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.PolyIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Inductive
extends LogicStatement {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Inductive.class);
    Case[] cases;

    public Inductive(PolyIdentifier polyIdentifier, Case[] caseArray) {
        super(polyIdentifier);
        this.cases = caseArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Inductive: " + String.valueOf(this);
    }

    public Inductive(PolyIdentifier polyIdentifier, Parameter[] parameterArray, Case[] caseArray) {
        super(polyIdentifier, parameterArray);
        this.cases = caseArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Inductive: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Inductive").append('[');
        if (this.cases == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.cases.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.cases[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public Case[] getCases() {
        return this.cases;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        if (this.cases != null) {
            list.addAll(Arrays.asList(this.cases));
        }
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((LogicStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            ACSLNode aCSLNode;
            int n;
            int n2;
            ACSLNode[] aCSLNodeArray;
            if (this.cases != null) {
                aCSLNodeArray = this.cases;
                n2 = this.cases.length;
                n = 0;
                while (n < n2) {
                    aCSLNode = aCSLNodeArray[n];
                    ((Case)aCSLNode).accept(aCSLVisitor);
                    ++n;
                }
            }
            if (this.polyId != null) {
                this.polyId.accept(aCSLVisitor);
            }
            if (this.parameters != null) {
                aCSLNodeArray = this.parameters;
                n2 = this.parameters.length;
                n = 0;
                while (n < n2) {
                    aCSLNode = aCSLNodeArray[n];
                    ((Parameter)aCSLNode).accept(aCSLVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public LogicStatement accept(ACSLTransformer aCSLTransformer) {
        ACSLNode aCSLNode;
        LogicStatement logicStatement = aCSLTransformer.transform(this);
        if (logicStatement != this) {
            return logicStatement;
        }
        boolean bl = false;
        ArrayList<Case> arrayList = new ArrayList<Case>();
        if (this.cases != null) {
            Case[] caseArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                aCSLNode = caseArray[n2];
                Case case_ = ((Case)aCSLNode).accept(aCSLTransformer);
                bl = bl || case_ != aCSLNode;
                arrayList.add(case_);
                ++n2;
            }
        }
        aCSLNode = null;
        if (this.polyId != null) {
            aCSLNode = this.polyId.accept(aCSLTransformer);
        }
        ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>();
        if (this.parameters != null) {
            Parameter[] parameterArray = this.parameters;
            int n = this.parameters.length;
            int n3 = 0;
            while (n3 < n) {
                Parameter parameter = parameterArray[n3];
                Parameter parameter2 = parameter.accept(aCSLTransformer);
                bl = bl || parameter2 != parameter;
                arrayList2.add(parameter2);
                ++n3;
            }
        }
        if (bl || this.polyId != aCSLNode) {
            return new Inductive((PolyIdentifier)aCSLNode, arrayList2.toArray(new Parameter[0]), arrayList.toArray(new Case[0]));
        }
        return this;
    }
}

