/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.sign;

import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgStatementExtractor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalStatementProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.sign.SignDomainEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.sign.SignDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.sign.SignDomainValue;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.ArrayList;
import java.util.List;

public class SignPostOperator
implements IAbstractPostOperator<SignDomainState, IcfgEdge> {
    private final RcfgStatementExtractor mStatementExtractor = new RcfgStatementExtractor();
    private final NonrelationalStatementProcessor<SignDomainState, SignDomainValue> mStatementProcessor;
    private final ILogger mLogger;

    protected SignPostOperator(ILogger iLogger, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider, SignDomainEvaluator signDomainEvaluator) {
        this.mStatementProcessor = new NonrelationalStatementProcessor<SignDomainState, SignDomainValue>(iLogger, iBoogieSymbolTableVariableProvider, signDomainEvaluator);
        this.mLogger = iLogger;
    }

    public List<SignDomainState> apply(SignDomainState signDomainState, IcfgEdge icfgEdge) {
        assert (signDomainState != null);
        assert (!signDomainState.isBottom());
        assert (icfgEdge != null);
        if (icfgEdge instanceof Summary && !((Summary)icfgEdge).calledProcedureHasImplementation()) {
            throw new UnsupportedOperationException("Summary for procedure without implementation");
        }
        ArrayList<SignDomainState> arrayList = new ArrayList<SignDomainState>();
        arrayList.add(signDomainState);
        List<Statement> list = this.mStatementExtractor.process(icfgEdge);
        for (Statement statement : list) {
            ArrayList<SignDomainState> arrayList2 = new ArrayList<SignDomainState>();
            for (SignDomainState signDomainState2 : arrayList) {
                List<SignDomainState> list2 = this.mStatementProcessor.process(signDomainState2, statement, null);
                assert (!list2.isEmpty());
                arrayList2.addAll(list2);
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public List<SignDomainState> apply(SignDomainState signDomainState, SignDomainState signDomainState2, IcfgEdge icfgEdge) {
        assert (icfgEdge instanceof Call || icfgEdge instanceof Return);
        ArrayList<SignDomainState> arrayList = new ArrayList<SignDomainState>();
        if (icfgEdge instanceof Call) {
            arrayList.add(signDomainState2);
        } else if (icfgEdge instanceof Return) {
            Return return_ = (Return)icfgEdge;
            CallStatement callStatement = return_.getCallStatement();
            this.mLogger.error((Object)("SignDomain does not handle returns correctly: " + String.valueOf(return_) + " for " + BoogiePrettyPrinter.print((Statement)callStatement)));
            arrayList.add(signDomainState2);
        } else {
            throw new UnsupportedOperationException("SignDomain does not support context switches other than Call and Return (yet)");
        }
        return arrayList;
    }

    public IAbstractPostOperator.EvalResult evaluate(SignDomainState signDomainState, Term term, Script script) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

