/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.preferences;

import de.uni_freiburg.informatik.ultimate.core.lib.preferences.UltimatePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItemGroup;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.witnessprinter.Activator;

public class PreferenceInitializer
extends UltimatePreferenceInitializer {
    public static final String LABEL_GRAPH_DATA_SPECIFICATION = "Graph data specification";
    public static final String LABEL_GRAPH_DATA_PROGRAMHASH = "Graph data programhash";
    public static final String LABEL_GRAPH_DATA_ARCHITECTURE = "Graph data architecture";
    public static final String LABEL_GRAPH_DATA_PRODUCER = "Graph data producer";
    public static final String UNUSED_GRAPH_DATA = "UNUSED";
    public static final String LABEL_GENERATE_GRAPHML_WITNESS = "Generate GraphML witnesses";
    private static final boolean VALUE_GENERATE_GRAPHML_WITNESS = true;
    public static final String LABEL_GENERATE_YAML_WITNESS = "Generate YAML witnesses";
    private static final boolean VALUE_GENERATE_YAML_WITNESS = true;
    public static final String LABEL_WITNESS_LOG = "Log witness to console";
    private static final boolean VALUE_WITNESS_LOG = false;
    public static final String LABEL_WITNESS_WRITE_BESIDE_FILE = "Write witness besides input file";
    private static final boolean VALUE_WITNESS_WRITE_BESIDE_FILE = true;
    private static final String DESC_WITNESS_WRITE_BESIDE_FILE = "Write witness as \"<inputfilename>-witness.graphml\" in the same directory as the input file. All other output options are ignored.";
    public static final String LABEL_WITNESS_DIRECTORY = "Witness directory";
    private static final String VALUE_WITNESS_DIRECTORY = ".";
    private static final String DESC_WITNESS_DIRECTORY = "Write witness to the specified directory.";
    public static final String LABEL_WITNESS_NAME = "Witness filename";
    private static final String VALUE_WITNESS_NAME = "witness";
    private static final String DESC_WITNESS_NAME = "The filename of the generated witness (without file-ending).";
    public static final String LABEL_WITNESS_VERIFY = "Verify the witness and generate results";
    private static final boolean VALUE_WITNESS_VERIFY = false;
    public static final String LABEL_WITNESS_VERIFIER = "Use the following witness verifier";
    private static final WitnessVerifierType VALUE_WITNESS_VERIFIER = WitnessVerifierType.CPACHECKER;
    public static final String LABEL_WITNESS_VERIFIER_COMMAND = "Command to execute witness verifier";
    private static final String VALUE_WITNESS_VERIFIER_COMMAND = "";
    private static final String DESC_WITNESS_VERIFIER_COMMAND = "The command gets a witness file as first and an input file as second parameter.For CPA Checker, you should additionally set CPACHECKER_HOME";
    public static final String LABEL_WITNESS_CPACHECKER_PROPERTY = "Path to .prp file";
    private static final String VALUE_WITNESS_CPACHECKER_PROPERTY = "";
    private static final String DESC_WITNESS_CPACHECKER_PROPERTY = "Only for CPAChecker. The path to the .prp file may be relative to CPACHECKER_HOME.";
    public static final String LABEL_WITNESS_VERIFIER_TIMEOUT = "Timeout in seconds for witness verifier";
    private static final int VALUE_WITNESS_VERIFIER_TIMEOUT = 10;
    public static final String LABEL_WITNESS_DELETE_GRAPHML = "Delete the .graphml file after verification";
    private static final boolean VALUE_WITNESS_DELETE_GRAPHML = false;
    public static final String LABEL_DO_NOT_USE_ACSL = "Do not use ACSL";
    private static final Boolean VALUE_DO_NOT_USE_ACSL = true;
    private static final String DESC_DO_NOT_USE_ACSL = "Prevent the generation of invariants in GraphML which require ACSL syntax";
    public static final String LABEL_YAML_FORMAT_VERSION = "YAML Format version";
    private static final String VALUE_YAML_FORMAT_VERSION = "2.0";

    public PreferenceInitializer() {
        super(Activator.PLUGIN_ID, "Witness Printer");
    }

    protected BaseUltimatePreferenceItem[] initDefaultPreferences() {
        return new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_GENERATE_GRAPHML_WITNESS, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_GENERATE_YAML_WITNESS, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_WITNESS_LOG, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_WITNESS_DIRECTORY, (Object)VALUE_WITNESS_DIRECTORY, DESC_WITNESS_DIRECTORY, PreferenceType.Directory), new UltimatePreferenceItem(LABEL_WITNESS_NAME, (Object)VALUE_WITNESS_NAME, DESC_WITNESS_NAME, PreferenceType.String), new UltimatePreferenceItem(LABEL_WITNESS_WRITE_BESIDE_FILE, (Object)true, DESC_WITNESS_WRITE_BESIDE_FILE, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_WITNESS_VERIFY, (Object)false, PreferenceType.Boolean, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new WitnessVerifierValidator()), new UltimatePreferenceItem(LABEL_WITNESS_VERIFIER, (Object)VALUE_WITNESS_VERIFIER, PreferenceType.Combo, (Object[])WitnessVerifierType.values()), new UltimatePreferenceItem(LABEL_WITNESS_VERIFIER_COMMAND, (Object)"", DESC_WITNESS_VERIFIER_COMMAND, PreferenceType.String), new UltimatePreferenceItem(LABEL_WITNESS_VERIFIER_TIMEOUT, (Object)10, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new UltimatePreferenceItem.IUltimatePreferenceItemValidator.IntegerValidator(1, Integer.MAX_VALUE)), new UltimatePreferenceItem(LABEL_WITNESS_CPACHECKER_PROPERTY, (Object)"", DESC_WITNESS_CPACHECKER_PROPERTY, PreferenceType.String), new UltimatePreferenceItem(LABEL_WITNESS_DELETE_GRAPHML, (Object)false, PreferenceType.Boolean, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new WitnessVerifierValidator()), new UltimatePreferenceItem(LABEL_DO_NOT_USE_ACSL, (Object)VALUE_DO_NOT_USE_ACSL, DESC_DO_NOT_USE_ACSL, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_YAML_FORMAT_VERSION, (Object)VALUE_YAML_FORMAT_VERSION, PreferenceType.String), new UltimatePreferenceItemGroup("Witness passthrough", new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_GRAPH_DATA_SPECIFICATION, (Object)UNUSED_GRAPH_DATA, "Write the value of this option to the witness graph data attribute \"specification\"", PreferenceType.String), new UltimatePreferenceItem(LABEL_GRAPH_DATA_PROGRAMHASH, (Object)UNUSED_GRAPH_DATA, "Write the value of this option to the witness graph data attribute \"programhash\"", PreferenceType.String), new UltimatePreferenceItem(LABEL_GRAPH_DATA_ARCHITECTURE, (Object)UNUSED_GRAPH_DATA, "Write the value of this option to the witness graph data attribute \"architecture\"", PreferenceType.String), new UltimatePreferenceItem(LABEL_GRAPH_DATA_PRODUCER, (Object)UNUSED_GRAPH_DATA, "Write the value of this option to the witness graph data attribute \"Producer\"", PreferenceType.String)})};
    }

    public static IPreferenceProvider getPreferences(IUltimateServiceProvider iUltimateServiceProvider) {
        return iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
    }

    public static enum WitnessVerifierType {
        CPACHECKER;

    }

    private static final class WitnessVerifierValidator
    implements UltimatePreferenceItem.IUltimatePreferenceItemValidator<Boolean> {
        private WitnessVerifierValidator() {
        }

        public boolean isValid(Boolean bl) {
            if (bl.booleanValue()) {
                RcpPreferenceProvider rcpPreferenceProvider = new RcpPreferenceProvider(Activator.PLUGIN_ID);
                return (rcpPreferenceProvider.getBoolean(PreferenceInitializer.LABEL_GENERATE_GRAPHML_WITNESS) || rcpPreferenceProvider.getBoolean(PreferenceInitializer.LABEL_GENERATE_YAML_WITNESS)) && rcpPreferenceProvider.getBoolean(PreferenceInitializer.LABEL_WITNESS_WRITE_BESIDE_FILE);
            }
            return true;
        }

        public String getInvalidValueErrorMessage(Boolean bl) {
            return "You must enable generation and writing of witness results before you can verify them";
        }
    }
}

