/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing.IteratedSymbolicMemory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LoopAccelerationIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final IIcfg<OUTLOC> mResultIcfg;
    private final Set<IcfgEdge> mLoopEntryTransitions;
    private final Map<INLOC, List<Backbone>> mBackbones;
    private final Set<Backbone> mExitBackbones;
    private final Map<Backbone, TransFormula> mBackboneTransformulas;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;

    public LoopAccelerationIcfgTransformer(ILogger iLogger, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string, IUltimateServiceProvider iUltimateServiceProvider) {
        IIcfg<INLOC> iIcfg2 = Objects.requireNonNull(iIcfg);
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mLoopEntryTransitions = new HashSet<IcfgEdge>();
        this.mBackbones = new HashMap<INLOC, List<Backbone>>();
        this.mExitBackbones = new HashSet<Backbone>();
        this.mBackboneTransformulas = new HashMap<Backbone, TransFormula>();
        this.mScript = iIcfg2.getCfgSmtToolkit().getManagedScript();
        this.mServices = iUltimateServiceProvider;
        BasicIcfg basicIcfg = new BasicIcfg(string, iIcfg.getCfgSmtToolkit(), clazz);
        TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, iLocationFactory, icfgTransformationBacktranslator, iIcfg2, basicIcfg);
        this.mResultIcfg = this.transform(iIcfg2, basicIcfg, transformedIcfgBuilder, icfgTransformationBacktranslator);
        transformedIcfgBuilder.finish();
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> iIcfg, BasicIcfg<OUTLOC> basicIcfg, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder, IcfgTransformationBacktranslator icfgTransformationBacktranslator) {
        IcfgLocation icfgLocation;
        IcfgLocation icfgLocation2;
        IcfgEdge icfgEdge;
        IcfgLocation icfgLocation22;
        this.findAllBackbones(iIcfg.getInitialNodes());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Found the following backbones:");
            this.mLogger.debug(this.mBackbones);
            this.mLogger.debug(this.mExitBackbones);
        }
        Set set = iIcfg.getInitialNodes();
        ArrayDeque<IcfgEdge> arrayDeque = new ArrayDeque<IcfgEdge>(set);
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        while (!arrayDeque.isEmpty()) {
            icfgLocation22 = (IcfgLocation)arrayDeque.removeFirst();
            if (!hashSet.add(icfgLocation22)) continue;
            IcfgLocation object2 = transformedIcfgBuilder.createNewLocation(icfgLocation22);
            HashSet hashSet2 = new HashSet();
            for (IcfgEdge icfgEdge2 : icfgLocation22.getOutgoingEdges()) {
                if (this.mLoopEntryTransitions.contains(icfgEdge2)) continue;
                icfgEdge = (IcfgLocation)icfgEdge2.getTarget();
                arrayDeque.add(icfgEdge);
                icfgLocation2 = transformedIcfgBuilder.createNewLocation((IcfgLocation)icfgEdge);
                if (this.mBackbones.containsKey(icfgLocation22)) {
                    icfgLocation = this.addAcceleratedTransition(icfgEdge2, object2, icfgLocation2, transformedIcfgBuilder);
                    icfgTransformationBacktranslator.mapEdges((IIcfgTransition<IcfgLocation>)icfgLocation, (IIcfgTransition<IcfgLocation>)icfgEdge2);
                    continue;
                }
                if (icfgEdge2 instanceof IIcfgReturnTransition) {
                    hashSet2.add(new Triple((Object)object2, (Object)icfgLocation2, (Object)((IIcfgReturnTransition)icfgEdge2)));
                    continue;
                }
                transformedIcfgBuilder.createNewTransition(object2, icfgLocation2, icfgEdge2);
            }
            hashSet2.stream().filter(triple -> transformedIcfgBuilder.isCorrespondingCallContained((IIcfgReturnTransition)triple.getThird())).forEach(triple -> {
                IcfgEdge icfgEdge = transformedIcfgBuilder.createNewTransition((IcfgLocation)triple.getFirst(), (IcfgLocation)triple.getSecond(), (IcfgEdge)triple.getThird());
            });
        }
        icfgLocation22 = new HashSet();
        block2: for (Backbone backbone : this.mExitBackbones) {
            IcfgEdge icfgEdge2;
            icfgEdge2 = backbone.getTransitions();
            int n = 0;
            while (n < icfgEdge2.size()) {
                icfgEdge = (IcfgEdge)icfgEdge2.get(n);
                icfgLocation2 = (IcfgLocation)icfgEdge.getSource();
                if (n > 0 && hashSet.contains(icfgLocation2)) continue block2;
                if (!icfgLocation22.contains(icfgEdge)) {
                    icfgLocation = (IcfgLocation)icfgEdge.getTarget();
                    IcfgLocation icfgLocation3 = transformedIcfgBuilder.createNewLocation(icfgLocation2);
                    IcfgLocation icfgLocation4 = transformedIcfgBuilder.createNewLocation(icfgLocation);
                    if (n == 0) {
                        IcfgEdge icfgEdge3 = this.addAcceleratedTransition(icfgEdge, icfgLocation3, icfgLocation4, transformedIcfgBuilder);
                        icfgTransformationBacktranslator.mapEdges((IIcfgTransition<IcfgLocation>)icfgEdge3, (IIcfgTransition<IcfgLocation>)icfgEdge);
                    } else {
                        transformedIcfgBuilder.createNewTransition(icfgLocation3, icfgLocation4, icfgEdge);
                    }
                    icfgLocation22.add(icfgEdge);
                }
                ++n;
            }
        }
        return basicIcfg;
    }

    private IcfgEdge addAcceleratedTransition(IcfgEdge icfgEdge, OUTLOC OUTLOC, OUTLOC OUTLOC2, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder) {
        IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getSource();
        IteratedSymbolicMemory iteratedSymbolicMemory = this.getIteratedSymbolicMemoryForLoop(icfgLocation);
        UnmodifiableTransFormula unmodifiableTransFormula = this.getLoopTransFormula(iteratedSymbolicMemory, this.mBackbones.get(icfgLocation));
        UnmodifiableTransFormula unmodifiableTransFormula2 = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, Arrays.asList(unmodifiableTransFormula, icfgEdge.getTransformula()));
        assert (icfgEdge instanceof IIcfgInternalTransition);
        boolean bl = iteratedSymbolicMemory.isOverapproximation() || iteratedSymbolicMemory.getLoopCounters().size() > 1;
        IcfgInternalTransition icfgInternalTransition = transformedIcfgBuilder.createNewInternalTransition(OUTLOC, OUTLOC2, unmodifiableTransFormula2, bl);
        return icfgInternalTransition;
    }

    private void findAllBackbones(Set<INLOC> set) {
        Object object;
        IcfgLocation icfgLocation;
        ArrayList<Backbone> arrayList = new ArrayList<Backbone>();
        for (IcfgLocation icfgLocation2 : set) {
            icfgLocation = icfgLocation2.getOutgoingEdges().iterator();
            while (icfgLocation.hasNext()) {
                object = (IcfgEdge)icfgLocation.next();
                LoopAccelerationIcfgTransformer.checkTransition((IcfgEdge)object);
                arrayList.add(new Backbone((IcfgEdge)object));
            }
            this.mBackbones.put(icfgLocation2, new ArrayList());
        }
        while (!arrayList.isEmpty()) {
            List list;
            int n = arrayList.size() - 1;
            while (n >= 0) {
                Backbone backbone = (Backbone)arrayList.get(n);
                object = backbone.getLastLocation();
                if (!object.equals((Object)(icfgLocation = (IcfgLocation)backbone.getTransitions().get(0).getSource())) && backbone.endsInLoop()) {
                    arrayList.remove(n);
                    list = backbone.getLoopEntryTransition();
                    if (!this.mLoopEntryTransitions.contains(list)) {
                        this.mLoopEntryTransitions.add((IcfgEdge)list);
                        arrayList.add(new Backbone((IcfgEdge)list));
                        this.mBackbones.putIfAbsent((IcfgLocation)list.getSource(), new ArrayList());
                    }
                } else if (object.equals((Object)icfgLocation)) {
                    assert (backbone.endsInLoop());
                    arrayList.remove(n);
                    this.mBackbones.get(icfgLocation).add(backbone);
                } else if (object.getOutgoingEdges().isEmpty()) {
                    assert (!backbone.endsInLoop());
                    arrayList.remove(n);
                    if (!set.contains(icfgLocation)) {
                        this.mExitBackbones.add(backbone);
                    }
                }
                --n;
            }
            n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                object = (Backbone)arrayList.get(n2);
                icfgLocation = ((Backbone)object).getLastLocation();
                list = icfgLocation.getOutgoingEdges();
                int n3 = 0;
                while (n3 < list.size()) {
                    IcfgEdge icfgEdge = (IcfgEdge)list.get(n3);
                    LoopAccelerationIcfgTransformer.checkTransition(icfgEdge);
                    if (n3 == list.size() - 1) {
                        ((Backbone)object).addTransition(icfgEdge);
                    } else {
                        Backbone backbone = new Backbone((Backbone)object);
                        backbone.addTransition(icfgEdge);
                        arrayList.add(backbone);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        for (IcfgLocation icfgLocation2 : set) {
            if (!this.mBackbones.get(icfgLocation2).isEmpty()) continue;
            this.mBackbones.remove(icfgLocation2);
        }
        this.validateBackbones();
    }

    private void validateBackbones() {
        Object object22;
        ArrayList<Backbone> arrayList = new ArrayList<Backbone>();
        for (List<Backbone> collection2 : this.mBackbones.values()) {
            arrayList.addAll(collection2);
        }
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        for (Object object22 : arrayList) {
            for (Backbone backbone : arrayList) {
                if (((Backbone)object22).getLastLocation().equals((Object)backbone.getLastLocation()) || !((Backbone)object22).containsLocation(backbone.getLastLocation()) || !backbone.containsLocation(((Backbone)object22).getLastLocation())) continue;
                hashSet.add(((Backbone)object22).getLastLocation());
                hashSet.add(backbone.getLastLocation());
            }
        }
        object22 = new ArrayList();
        for (Backbone backbone : this.mExitBackbones) {
            if (!hashSet.contains(backbone.getTransitions().get(0).getSource())) continue;
            object22.add(backbone);
        }
        this.mExitBackbones.removeAll((Collection<?>)object22);
        for (IcfgLocation icfgLocation : hashSet) {
            for (Backbone backbone : this.mBackbones.get(icfgLocation)) {
                this.mLoopEntryTransitions.remove(backbone.getLoopEntryTransition());
            }
            this.mBackbones.remove(icfgLocation);
        }
    }

    private static void checkTransition(IcfgEdge icfgEdge) {
        TermClassifier termClassifier = new TermClassifier();
        termClassifier.checkTerm(icfgEdge.getTransformula().getFormula());
        if (termClassifier.hasArrays()) {
            throw new UnsupportedOperationException("Cannot handle arrays");
        }
    }

    private IteratedSymbolicMemory getIteratedSymbolicMemoryForLoop(INLOC INLOC) {
        List<Backbone> list = this.mBackbones.get(INLOC);
        ArrayList<SymbolicMemory> arrayList = new ArrayList<SymbolicMemory>();
        for (Backbone backbone : list) {
            IcfgEdge icfgEdge2;
            boolean bl = false;
            ArrayList<UnmodifiableTransFormula> arrayList2 = new ArrayList<UnmodifiableTransFormula>();
            for (IcfgEdge icfgEdge2 : backbone.getTransitions()) {
                UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge2.getTransformula();
                arrayList2.add(unmodifiableTransFormula);
                IcfgLocation icfgLocation = (IcfgLocation)icfgEdge2.getTarget();
                if (icfgLocation.equals((Object)backbone.getLastLocation()) || !this.mBackbones.containsKey(icfgLocation)) continue;
                IteratedSymbolicMemory iteratedSymbolicMemory = this.getIteratedSymbolicMemoryForLoop(icfgLocation);
                bl |= iteratedSymbolicMemory.isOverapproximation() || iteratedSymbolicMemory.getLoopCounters().size() > 1;
                UnmodifiableTransFormula unmodifiableTransFormula2 = this.getLoopTransFormula(iteratedSymbolicMemory, this.mBackbones.get(icfgLocation));
                arrayList2.add(unmodifiableTransFormula2);
            }
            icfgEdge2 = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, arrayList2);
            this.mBackboneTransformulas.put(backbone, (TransFormula)icfgEdge2);
            SymbolicMemory symbolicMemory = new SymbolicMemory(this.mScript, (TransFormula)icfgEdge2, bl);
            arrayList.add(symbolicMemory);
        }
        return new IteratedSymbolicMemory(this.mScript, arrayList);
    }

    private UnmodifiableTransFormula getLoopTransFormula(IteratedSymbolicMemory iteratedSymbolicMemory, List<Backbone> list) {
        Term term;
        TermVariable termVariable;
        int n = list.size();
        List<TermVariable> list2 = iteratedSymbolicMemory.getLoopCounters();
        assert (list2.size() == n);
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(list2);
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>(n);
        HashMap<Term, TermVariable> hashMap = new HashMap<Term, TermVariable>();
        Sort sort = SmtSortUtils.getIntSort((ManagedScript)this.mScript);
        int n2 = 0;
        while (n2 < n) {
            termVariable = this.mScript.constructFreshTermVariable("loopIterator", sort);
            arrayList.add(termVariable);
            hashMap.put((Term)list2.get(n2), termVariable);
            ++n2;
        }
        Term[] termArray = new Term[n];
        termVariable = Rational.ZERO.toTerm(sort);
        int n3 = 0;
        while (n3 < n) {
            Term term2;
            TransFormula transFormula = this.mBackboneTransformulas.get(list.get(n3));
            hashSet.addAll(transFormula.getAuxVars());
            term = transFormula.getFormula();
            term = iteratedSymbolicMemory.getSymbolicMemory(n3).replaceTermVars(term, null);
            term = iteratedSymbolicMemory.replaceTermVars(term, transFormula.getInVars());
            term = Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)term);
            ArrayList<TermVariable> arrayList2 = new ArrayList<TermVariable>();
            int n4 = 0;
            while (n4 < n) {
                if (n3 != n4) {
                    arrayList2.add((TermVariable)arrayList.get(n4));
                    term2 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{this.mScript.getScript().term("<=", new Term[]{termVariable, (Term)arrayList.get(n4)}), this.mScript.getScript().term("<=", new Term[]{(Term)arrayList.get(n4), (Term)list2.get(n4)})});
                    term = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{term2, term});
                }
                ++n4;
            }
            if (!arrayList2.isEmpty()) {
                term = this.mScript.getScript().quantifier(0, arrayList2.toArray(new TermVariable[0]), term, (Term[][])new Term[0][]);
            }
            Term term3 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{this.mScript.getScript().term("<=", new Term[]{termVariable, (Term)arrayList.get(n3)}), this.mScript.getScript().term("<", new Term[]{(Term)arrayList.get(n3), (Term)list2.get(n3)})});
            term = Util.implies((Script)this.mScript.getScript(), (Term[])new Term[]{term3, term});
            term2 = term = this.mScript.getScript().quantifier(1, new TermVariable[]{(TermVariable)arrayList.get(n3)}, term, (Term[][])new Term[0][]);
            termArray[n3] = term = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term2);
            ++n3;
        }
        Term term4 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])termArray);
        int n5 = 0;
        while (n5 < n) {
            term4 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{term4, this.mScript.getScript().term(">=", new Term[]{(Term)list2.get(n5), termVariable})});
            ++n5;
        }
        Term term5 = term4 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{term4, iteratedSymbolicMemory.toTerm()});
        term4 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term5);
        term = new TransFormulaBuilder(iteratedSymbolicMemory.getInVars(), iteratedSymbolicMemory.getOutVars(), true, null, true, null, false);
        term.setFormula(term4);
        term.addAuxVarsButRenameToFreshCopies(hashSet, this.mScript);
        term.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return term.finishConstruction(this.mScript);
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }
}

