/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.OldVarsAssignmentCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import java.util.SortedMap;

public class DefaultTransFormulas<L extends IAction>
extends NestedFormulas<L, UnmodifiableTransFormula, IPredicate> {
    private final OldVarsAssignmentCache mModifiableGlobalVariableManager;
    private final boolean mWithBranchEncoders;

    public DefaultTransFormulas(Word<L> word, IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, OldVarsAssignmentCache oldVarsAssignmentCache, boolean bl) {
        this(new Counterexample<L>(word), iPredicate, iPredicate2, sortedMap, oldVarsAssignmentCache, bl);
    }

    public DefaultTransFormulas(Counterexample<L> counterexample, IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, OldVarsAssignmentCache oldVarsAssignmentCache, boolean bl) {
        super(counterexample, sortedMap);
        super.setPrecondition(iPredicate);
        super.setPostcondition(iPredicate2);
        this.mModifiableGlobalVariableManager = oldVarsAssignmentCache;
        this.mWithBranchEncoders = bl;
    }

    public OldVarsAssignmentCache getModifiableGlobalVariableManager() {
        return this.mModifiableGlobalVariableManager;
    }

    public boolean hasBranchEncoders() {
        return this.mWithBranchEncoders;
    }

    @Override
    protected UnmodifiableTransFormula getFormulaFromValidNonCallPos(int n) {
        if (super.getTrace().isReturnPosition(n)) {
            IReturnAction iReturnAction = (IReturnAction)super.getTrace().getSymbol(n);
            return iReturnAction.getAssignmentOfReturn();
        }
        IInternalAction iInternalAction = (IInternalAction)super.getTrace().getSymbol(n);
        if (this.mWithBranchEncoders) {
            if (iInternalAction instanceof IActionWithBranchEncoders) {
                return ((IActionWithBranchEncoders)iInternalAction).getTransitionFormulaWithBranchEncoders();
            }
            return iInternalAction.getTransformula();
        }
        return iInternalAction.getTransformula();
    }

    @Override
    protected UnmodifiableTransFormula getLocalVarAssignmentFromValidPos(int n) {
        ICallAction iCallAction = (ICallAction)super.getTrace().getSymbol(n);
        return iCallAction.getLocalVarsAssignment();
    }

    @Override
    protected UnmodifiableTransFormula getGlobalVarAssignmentFromValidPos(int n) {
        String string = this.getCalledProcedure(n);
        return this.mModifiableGlobalVariableManager.getGlobalVarsAssignment(string);
    }

    @Override
    protected UnmodifiableTransFormula getOldVarAssignmentFromValidPos(int n) {
        String string = this.getCalledProcedure(n);
        return this.mModifiableGlobalVariableManager.getOldVarsAssignment(string);
    }

    private String getCalledProcedure(int n) {
        if (super.getTrace().isCallPosition(n)) {
            ICallAction iCallAction = (ICallAction)super.getTrace().getSymbol(n);
            return iCallAction.getSucceedingProcedure();
        }
        if (super.getTrace().isPendingReturn(n)) {
            IReturnAction iReturnAction = (IReturnAction)super.getTrace().getSymbol(n);
            return iReturnAction.getPrecedingProcedure();
        }
        throw new UnsupportedOperationException("only available for call and pending return");
    }
}

