/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ProcedureContract;
import java.util.Set;

public class ProcedureContractResult<ELEM extends IElement, E>
extends AbstractResultAtElement<ELEM> {
    private final ProcedureContract<E, ? extends E> mContract;
    private final ProcedureContract<String, String> mStringContract;
    private final String mProcedureName;
    private final Set<Check> mChecks;

    public ProcedureContractResult(String string, ELEM ELEM, String string2, ProcedureContract<E, ? extends E> procedureContract, ProcedureContract<String, String> procedureContract2, Set<Check> set) {
        super(ELEM, string);
        this.mProcedureName = string2;
        this.mContract = procedureContract;
        this.mStringContract = procedureContract2;
        this.mChecks = set;
    }

    public E getEnsures() {
        return (E)this.mContract.getEnsures();
    }

    public E getRequires() {
        return (E)this.mContract.getRequires();
    }

    public String getShortDescription() {
        return "Procedure Contract for " + this.mProcedureName;
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Derived contract for procedure ");
        stringBuilder.append(this.mProcedureName);
        stringBuilder.append(".");
        if (this.getRequires() != null) {
            stringBuilder.append(" Requires: ");
            stringBuilder.append((String)this.mStringContract.getRequires());
            stringBuilder.append(".");
        }
        if (this.getEnsures() != null) {
            stringBuilder.append(" Ensures: ");
            stringBuilder.append((String)this.mStringContract.getEnsures());
            stringBuilder.append(".");
        }
        if (this.mContract.hasModifies()) {
            stringBuilder.append(" Modifies: ");
            stringBuilder.append(this.mStringContract.getModifies());
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public Set<Check> getChecks() {
        return this.mChecks;
    }
}

