/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;

public class TerminationAnalysisResult
extends AbstractResult
implements IResultWithSeverity {
    private final Termination mTermination;
    private final String mLongDescription;

    public TerminationAnalysisResult(String string, Termination termination, String string2) {
        super(string);
        this.mTermination = termination;
        this.mLongDescription = string2;
    }

    public Termination getTermination() {
        return this.mTermination;
    }

    public String getShortDescription() {
        return switch (this.mTermination) {
            case Termination.NONTERMINATING -> "Nontermination possible";
            case Termination.TERMINATING -> "Termination proven";
            case Termination.UNKNOWN -> "Unable to decide termination";
            default -> throw new MatchException(null, null);
        };
    }

    public String getLongDescription() {
        return this.mLongDescription;
    }

    public IResultWithSeverity.Severity getSeverity() {
        return switch (this.mTermination) {
            case Termination.NONTERMINATING -> IResultWithSeverity.Severity.ERROR;
            case Termination.TERMINATING -> IResultWithSeverity.Severity.INFO;
            case Termination.UNKNOWN -> IResultWithSeverity.Severity.ERROR;
            default -> throw new MatchException(null, null);
        };
    }

    public static enum Termination {
        TERMINATING,
        NONTERMINATING,
        UNKNOWN;

    }
}

