/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;

public class TerminationArgumentResult<P extends IElement, E>
extends AbstractResultAtElement<P> {
    private final String mRankingFunctionDescription;
    private final E[] mRankingFunction;
    private final E[] mSupportingInvariants;
    private final Class<E> mExprClazz;
    private final IBacktranslationService mTranslatorSequence;

    public TerminationArgumentResult(P p, String string, E[] EArray, String string2, E[] EArray2, IBacktranslationService iBacktranslationService, Class<E> clazz) {
        super(p, string);
        this.mRankingFunction = EArray;
        this.mRankingFunctionDescription = string2;
        this.mSupportingInvariants = EArray2;
        this.mExprClazz = clazz;
        this.mTranslatorSequence = iBacktranslationService;
    }

    public String getShortDescription() {
        return "Found " + this.mRankingFunctionDescription + " ranking function";
    }

    public String getLongDescription() {
        E e;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Found a termination argument consisting of the ");
        stringBuilder.append(this.mRankingFunctionDescription);
        stringBuilder.append(" ranking function");
        stringBuilder.append(": [");
        boolean bl = false;
        E[] EArray = this.mRankingFunction;
        int n = this.mRankingFunction.length;
        int n2 = 0;
        while (n2 < n) {
            e = EArray[n2];
            if (bl) {
                stringBuilder.append(", ");
            } else {
                bl = true;
            }
            stringBuilder.append(this.mTranslatorSequence.translateExpressionToString(e, this.mExprClazz));
            ++n2;
        }
        stringBuilder.append("]");
        if (this.mSupportingInvariants.length > 0) {
            stringBuilder.append(" and the following supporting invariants: ");
            EArray = this.mSupportingInvariants;
            n = this.mSupportingInvariants.length;
            n2 = 0;
            while (n2 < n) {
                e = EArray[n2];
                stringBuilder.append(this.mTranslatorSequence.translateExpressionToString(e, this.mExprClazz));
                ++n2;
            }
        } else {
            stringBuilder.append(" for which no supporting invariant is required.");
        }
        return stringBuilder.toString();
    }

    public String getRankingFunctionDescription() {
        return this.mRankingFunctionDescription;
    }

    public E[] getRankingFunction() {
        return this.mRankingFunction;
    }

    public E[] getSupportingInvariants() {
        return this.mSupportingInvariants;
    }
}

