/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class MapEliminatorUtils {
    private MapEliminatorUtils() {
    }

    private static Term getLocalTerm(Term term, ModifiableTransFormula modifiableTransFormula, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable, boolean bl) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            IProgramVar iProgramVar = iIcfgSymbolTable.getProgramVar(termVariable);
            TermVariable termVariable2 = MapEliminatorUtils.getFreshTermVar((Term)termVariable, managedScript);
            if (!modifiableTransFormula.getInVars().containsKey(iProgramVar)) {
                modifiableTransFormula.addInVar(iProgramVar, termVariable2);
            }
            if (!modifiableTransFormula.getOutVars().containsKey(iProgramVar)) {
                modifiableTransFormula.addOutVar(iProgramVar, termVariable2);
            }
            if (bl) {
                hashMap.put(termVariable, (Term)modifiableTransFormula.getInVars().get(iProgramVar));
            } else {
                hashMap.put(termVariable, (Term)modifiableTransFormula.getOutVars().get(iProgramVar));
            }
            ++n2;
        }
        return Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
    }

    public static Term getInVarTerm(Term term, ModifiableTransFormula modifiableTransFormula, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        return MapEliminatorUtils.getLocalTerm(term, modifiableTransFormula, managedScript, iIcfgSymbolTable, true);
    }

    public static Term getOutVarTerm(Term term, ModifiableTransFormula modifiableTransFormula, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        return MapEliminatorUtils.getLocalTerm(term, modifiableTransFormula, managedScript, iIcfgSymbolTable, false);
    }

    public static ArrayIndex getInVarIndex(ArrayIndex arrayIndex, ModifiableTransFormula modifiableTransFormula, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        return new ArrayIndex(arrayIndex.stream().map(term -> MapEliminatorUtils.getInVarTerm(term, modifiableTransFormula, managedScript, iIcfgSymbolTable)).collect(Collectors.toList()));
    }

    public static ArrayIndex getOutVarIndex(ArrayIndex arrayIndex, ModifiableTransFormula modifiableTransFormula, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        return new ArrayIndex(arrayIndex.stream().map(term -> MapEliminatorUtils.getOutVarTerm(term, modifiableTransFormula, managedScript, iIcfgSymbolTable)).collect(Collectors.toList()));
    }

    private static TermVariable getFreshTermVar(Term term, ManagedScript managedScript) {
        return managedScript.constructFreshTermVariable(MapEliminatorUtils.niceTermString(term), term.getSort());
    }

    private static String niceTermString(Term term) {
        if (SmtUtils.isFunctionApplication((Term)term, (String)"select")) {
            StringBuilder stringBuilder = new StringBuilder();
            MultiDimensionalSelect multiDimensionalSelect = MultiDimensionalSelect.of((Term)term);
            stringBuilder.append("array_").append(MapEliminatorUtils.niceTermString(multiDimensionalSelect.getArray())).append('[');
            ArrayIndex arrayIndex = multiDimensionalSelect.getIndex();
            int n = 0;
            while (n < arrayIndex.size()) {
                stringBuilder.append(MapEliminatorUtils.niceTermString(arrayIndex.get(n))).append(n == arrayIndex.size() - 1 ? (char)']' : ',');
                ++n;
            }
            return stringBuilder.toString();
        }
        if (term instanceof ApplicationTerm && !SmtUtils.isConstant((Term)term)) {
            StringBuilder stringBuilder = new StringBuilder();
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            if (!functionSymbol.isIntern()) {
                stringBuilder.append("uf_");
            }
            stringBuilder.append('(').append(functionSymbol.getName()).append(' ');
            Term[] termArray = applicationTerm.getParameters();
            int n = 0;
            while (n < termArray.length) {
                stringBuilder.append(MapEliminatorUtils.niceTermString(termArray[n])).append(n == termArray.length - 1 ? (char)')' : ' ');
                ++n;
            }
            return stringBuilder.toString();
        }
        return SmtUtils.removeSmtQuoteCharacters((String)term.toString());
    }

    public static void addReplacementVar(Term term, ModifiableTransFormula modifiableTransFormula, ManagedScript managedScript, ReplacementVarFactory replacementVarFactory, IIcfgSymbolTable iIcfgSymbolTable) {
        IReplacementVarOrConst iReplacementVarOrConst = replacementVarFactory.getOrConstuctReplacementVar(term, false);
        if (!(iReplacementVarOrConst instanceof IReplacementVar)) {
            throw new UnsupportedOperationException("Unsupported type " + String.valueOf(iReplacementVarOrConst.getClass()));
        }
        IReplacementVar iReplacementVar = (IReplacementVar)iReplacementVarOrConst;
        TermVariable termVariable = MapEliminatorUtils.getFreshTermVar(term, managedScript);
        Map<IProgramVar, TermVariable> map = modifiableTransFormula.getInVars();
        Map<IProgramVar, TermVariable> map2 = modifiableTransFormula.getOutVars();
        if (!map.containsKey(iReplacementVar)) {
            modifiableTransFormula.addInVar(iReplacementVar, termVariable);
        }
        if (!map2.containsKey(iReplacementVar)) {
            if (Arrays.stream(term.getFreeVars()).map(iIcfgSymbolTable::getProgramVar).anyMatch(iProgramVar -> map.get(iProgramVar) != map2.get(iProgramVar))) {
                modifiableTransFormula.addOutVar(iReplacementVar, MapEliminatorUtils.getFreshTermVar(term, managedScript));
            } else {
                modifiableTransFormula.addOutVar(iReplacementVar, termVariable);
            }
        }
    }

    public static Term getReplacementVar(Term term, ModifiableTransFormula modifiableTransFormula, ManagedScript managedScript, ReplacementVarFactory replacementVarFactory, Collection<TermVariable> collection) {
        if (!ModifiableTransFormulaUtils.allVariablesAreInVars(term, modifiableTransFormula) && !ModifiableTransFormulaUtils.allVariablesAreOutVars(term, modifiableTransFormula)) {
            return MapEliminatorUtils.getAndAddAuxVar(term, collection, replacementVarFactory);
        }
        Term term2 = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(managedScript, modifiableTransFormula, term);
        IReplacementVarOrConst iReplacementVarOrConst = replacementVarFactory.getOrConstuctReplacementVar(term2, false);
        if (!(iReplacementVarOrConst instanceof IReplacementVar)) {
            throw new UnsupportedOperationException("Unsupported type " + String.valueOf(iReplacementVarOrConst.getClass()));
        }
        IReplacementVar iReplacementVar = (IReplacementVar)iReplacementVarOrConst;
        TermVariable termVariable = modifiableTransFormula.getInVars().get(iReplacementVar);
        TermVariable termVariable2 = modifiableTransFormula.getOutVars().get(iReplacementVar);
        if (termVariable == null || termVariable2 == null) {
            throw new AssertionError((Object)(String.valueOf(iReplacementVar) + " was not added to the transformula!"));
        }
        return ModifiableTransFormulaUtils.allVariablesAreInVars(term, modifiableTransFormula) ? termVariable : termVariable2;
    }

    public static TermVariable getAndAddAuxVar(Term term, Collection<TermVariable> collection, ReplacementVarFactory replacementVarFactory) {
        TermVariable termVariable = replacementVarFactory.getOrConstructAuxVar(MapEliminatorUtils.niceTermString(term), term.getSort());
        collection.add(termVariable);
        return termVariable;
    }
}

