/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.AbstractAcceptance;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class BuchiAccepts<LETTER, STATE>
extends AbstractAcceptance<LETTER, STATE> {
    private final NestedWord<LETTER> mStem;
    private final NestedWord<LETTER> mLoop;

    public BuchiAccepts(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, NestedLassoWord<LETTER> nestedLassoWord) throws AutomataLibraryException {
        super(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider);
        this.mStem = nestedLassoWord.getStem();
        this.mLoop = nestedLassoWord.getLoop();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        if (this.mStem.containsPendingReturns()) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"This implementation of Buchi acceptance rejects lasso words, where the stem contains pending returns.");
            }
            this.mIsAccepted = false;
            return;
        }
        if (this.mLoop.containsPendingReturns()) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"This implementation of Buchi acceptance rejects lasso words, where the loop contains pending returns.");
            }
            this.mIsAccepted = false;
            return;
        }
        if (this.mLoop.length() == 0) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"LassoWords with empty lasso are rejected by every B\u00fcchi automaton");
            }
            this.mIsAccepted = false;
            return;
        }
        this.mIsAccepted = this.buchiAccepts();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + " Operand " + this.mOperand.sizeInformation() + " Stem has " + this.mStem.length() + " letters. Loop has " + this.mLoop.length() + " letters.";
    }

    private boolean buchiAccepts() throws AutomataLibraryException {
        Set<ArrayDeque<STATE>> set4;
        Set<STATE> set2;
        Set<STATE> set3 = set2 = this.computeHondaStates();
        do {
            set2.addAll(set3);
            set4 = this.emptyStackConfiguration(set2);
            int n = 0;
            while (n < this.mLoop.length()) {
                set4 = this.successorConfigurations(set4, this.mLoop, n, this.mOperand, false);
                if (this.isCancellationRequested()) {
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                ++n;
            }
        } while (!set2.containsAll(set3 = this.getTopMostStackElemets(set4)));
        for (Set<ArrayDeque<STATE>> set4 : set2) {
            if (!this.repeatedLoopLeadsAgainToHondaState(set4)) continue;
            return true;
        }
        return false;
    }

    private Set<STATE> computeHondaStates() throws AutomataLibraryException {
        Set set = this.emptyStackConfiguration(this.mOperand.getInitialStates());
        int n = 0;
        while (n < this.mStem.length()) {
            set = this.successorConfigurations(set, this.mStem, n, this.mOperand, false);
            if (this.isCancellationRequested()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            ++n;
        }
        return this.getTopMostStackElemets(set);
    }

    private boolean repeatedLoopLeadsAgainToHondaState(STATE STATE) throws AutomataLibraryException {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        HashSet<STATE> hashSet2 = new HashSet<STATE>();
        HashSet<STATE> hashSet3 = new HashSet<STATE>();
        hashSet3.add(STATE);
        Set<ArrayDeque<STATE>> set = this.emptyStackConfiguration(hashSet3);
        Set<ArrayDeque<STATE>> set2 = this.removeAcceptingConfigurations(set, this.mOperand);
        Set<ArrayDeque<STATE>> set3 = set;
        while (!set3.isEmpty() || !set2.isEmpty()) {
            Set<Object> set4;
            int n = 0;
            while (n < this.mLoop.length()) {
                set2 = this.successorConfigurations(set2, this.mLoop, n, this.mOperand, false);
                set3 = this.successorConfigurations(set3, this.mLoop, n, this.mOperand, false);
                set4 = this.removeAcceptingConfigurations(set3, this.mOperand);
                set2.addAll(set4);
                if (this.isCancellationRequested()) {
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                ++n;
            }
            this.removeAllWhoseTopmostElementIsOneOf(set2, hashSet);
            this.removeAllWhoseTopmostElementIsOneOf(set3, hashSet2);
            Set<STATE> set5 = this.getTopMostStackElemets(set2);
            if (set5.contains(STATE)) {
                return true;
            }
            set4 = this.getTopMostStackElemets(set3);
            hashSet.addAll(set5);
            hashSet2.addAll(set4);
        }
        return false;
    }

    private void removeAllWhoseTopmostElementIsOneOf(Set<ArrayDeque<STATE>> set, Set<STATE> set2) {
        ArrayList<ArrayDeque<STATE>> arrayList = new ArrayList<ArrayDeque<STATE>>();
        for (ArrayDeque<Object> arrayDeque : set) {
            if (!set2.contains(arrayDeque.peek())) continue;
            arrayList.add(arrayDeque);
        }
        for (ArrayDeque<Object> arrayDeque : arrayList) {
            set.remove(arrayDeque);
        }
    }

    private Set<STATE> getTopMostStackElemets(Set<ArrayDeque<STATE>> set) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (ArrayDeque<STATE> arrayDeque : set) {
            hashSet.add(arrayDeque.peek());
        }
        return hashSet;
    }

    private Set<ArrayDeque<STATE>> removeAcceptingConfigurations(Set<ArrayDeque<STATE>> set, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        HashSet<ArrayDeque<STATE>> hashSet = new HashSet<ArrayDeque<STATE>>();
        for (ArrayDeque<Object> arrayDeque : set) {
            STATE STATE = arrayDeque.peek();
            if (!iNwaOutgoingLetterAndTransitionProvider.isFinal(STATE)) continue;
            hashSet.add(arrayDeque);
        }
        for (ArrayDeque<Object> arrayDeque : hashSet) {
            set.remove(arrayDeque);
        }
        return hashSet;
    }
}

