/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.IFkvState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingConstraintDrdCheck;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.StateWithRankInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LevelRankingState<LETTER, STATE>
implements IFkvState<LETTER, STATE> {
    private static final String NOT_APPLICABLE = "not applicable";
    private static final int TWO = 2;
    private static final int THREE = 3;
    protected final Map<StateWithRankInfo<STATE>, HashMap<STATE, Integer>> mLevelRanking;
    protected final Map<StateWithRankInfo<STATE>, Set<STATE>> mO;
    protected final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    protected int mHighestRank;

    LevelRankingState(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        this.mLevelRanking = new HashMap<StateWithRankInfo<STATE>, HashMap<STATE, Integer>>();
        this.mO = new HashMap<StateWithRankInfo<STATE>, Set<STATE>>();
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mHighestRank = -1;
    }

    LevelRankingState(LevelRankingState<LETTER, STATE> levelRankingState) {
        this.mLevelRanking = this.copyLevelRanking(levelRankingState.mLevelRanking);
        this.mO = this.copyO(levelRankingState.mO);
        this.mHighestRank = levelRankingState.mHighestRank;
        this.mOperand = levelRankingState.getOperand();
    }

    public LevelRankingState() {
        this.mLevelRanking = null;
        this.mO = null;
        this.mOperand = null;
    }

    final Map<StateWithRankInfo<STATE>, HashMap<STATE, Integer>> copyLevelRanking(Map<StateWithRankInfo<STATE>, HashMap<STATE, Integer>> map) {
        HashMap<StateWithRankInfo<STATE>, HashMap<STATE, Integer>> hashMap = new HashMap<StateWithRankInfo<STATE>, HashMap<STATE, Integer>>();
        for (Map.Entry<StateWithRankInfo<STATE>, HashMap<STATE, Integer>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new HashMap(entry.getValue()));
        }
        return hashMap;
    }

    final Map<StateWithRankInfo<STATE>, Set<STATE>> copyO(Map<StateWithRankInfo<STATE>, Set<STATE>> map) {
        HashMap<StateWithRankInfo<STATE>, Set<STATE>> hashMap = new HashMap<StateWithRankInfo<STATE>, Set<STATE>>();
        for (Map.Entry<StateWithRankInfo<STATE>, Set<STATE>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return hashMap;
    }

    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Set<StateWithRankInfo<STATE>> getDownStates() {
        return this.mLevelRanking.keySet();
    }

    @Override
    public Iterable<StateWithRankInfo<STATE>> getUpStates(StateWithRankInfo<STATE> stateWithRankInfo) {
        ArrayList<StateWithRankInfo<STATE>> arrayList = new ArrayList<StateWithRankInfo<STATE>>();
        for (STATE STATE : this.mLevelRanking.get(stateWithRankInfo).keySet()) {
            int n = this.getRank(stateWithRankInfo, STATE);
            boolean bl = this.inO(stateWithRankInfo, STATE);
            arrayList.add(new StateWithRankInfo<STATE>(STATE, n, bl));
        }
        return arrayList;
    }

    protected void addRank(StateWithRankInfo<STATE> stateWithRankInfo, STATE STATE, Integer n, boolean bl) {
        assert (n != null);
        assert (LevelRankingState.isEven(n) || !this.mOperand.isFinal(STATE)) : "final states must have even ranks";
        HashMap<Object, Integer> hashMap = this.mLevelRanking.get(stateWithRankInfo);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.mLevelRanking.put(stateWithRankInfo, hashMap);
        }
        assert (!hashMap.containsKey(STATE));
        hashMap.put(STATE, n);
        if (bl) {
            assert (LevelRankingState.isEven(this.getRank(stateWithRankInfo, STATE))) : "has to be even";
            this.addToO(stateWithRankInfo, STATE);
        }
        if (this.mHighestRank < n) {
            this.mHighestRank = n;
        }
    }

    protected void addToO(StateWithRankInfo<STATE> stateWithRankInfo, STATE STATE) {
        Set<STATE> set = this.mO.get(stateWithRankInfo);
        if (set == null) {
            set = new HashSet<STATE>();
            this.mO.put(stateWithRankInfo, set);
        }
        set.add(STATE);
    }

    public Integer getRank(StateWithRankInfo<STATE> stateWithRankInfo, STATE STATE) {
        HashMap<STATE, Integer> hashMap = this.mLevelRanking.get(stateWithRankInfo);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(STATE);
    }

    public boolean inO(StateWithRankInfo<STATE> stateWithRankInfo, STATE STATE) {
        Set<STATE> set = this.mO.get(stateWithRankInfo);
        if (set == null) {
            return false;
        }
        return set.contains(STATE);
    }

    boolean isOempty() {
        return this.mO.isEmpty();
    }

    public String toString() {
        if (this.mLevelRanking == null) {
            return "NON_ACCEPTING_SINK";
        }
        return this.mLevelRanking.toString() + " O" + String.valueOf(this.mO);
    }

    public int hashCode() {
        return Objects.hash(this.mLevelRanking, this.mO);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LevelRankingState levelRankingState = (LevelRankingState)object;
        if (this.mLevelRanking == null ? levelRankingState.mLevelRanking != null : !this.mLevelRanking.equals(levelRankingState.mLevelRanking)) {
            return false;
        }
        return !(this.mO == null ? levelRankingState.mO != null : !this.mO.equals(levelRankingState.mO));
    }

    private int[] constructRanksHistogram() {
        assert (this.mHighestRank >= 0);
        assert (this.mHighestRank < Integer.MAX_VALUE) : "not applicable";
        int[] nArray = new int[this.mHighestRank + 1];
        for (StateWithRankInfo<STATE> stateWithRankInfo : this.getDownStates()) {
            for (StateWithRankInfo<STATE> stateWithRankInfo2 : this.getUpStates(stateWithRankInfo)) {
                int n = stateWithRankInfo2.getRank();
                nArray[n] = nArray[n] + 1;
            }
        }
        return nArray;
    }

    boolean isTight() {
        assert (this.mHighestRank >= 0);
        assert (this.mHighestRank < Integer.MAX_VALUE) : "not applicable";
        if (LevelRankingState.isEven(this.mHighestRank)) {
            return false;
        }
        int[] nArray = this.constructRanksHistogram();
        int n = 1;
        while (n <= this.mHighestRank) {
            if (nArray[n] == 0) {
                return false;
            }
            n += 2;
        }
        return true;
    }

    boolean isMaximallyTight() {
        assert (this.mHighestRank >= 0);
        assert (this.mHighestRank < Integer.MAX_VALUE) : "not applicable";
        if (LevelRankingState.isEven(this.mHighestRank)) {
            return false;
        }
        int[] nArray = this.constructRanksHistogram();
        int n = 1;
        while (n < this.mHighestRank) {
            if (nArray[n] != 1) {
                return false;
            }
            n += 2;
        }
        if (nArray[this.mHighestRank] == 0) {
            return false;
        }
        n = 0;
        while (n < this.mHighestRank - 1) {
            if (nArray[n] != 0) {
                return false;
            }
            n += 2;
        }
        return true;
    }

    boolean isElastic() {
        assert (this.mHighestRank >= 0);
        assert (this.mHighestRank < Integer.MAX_VALUE) : "not applicable";
        if (LevelRankingState.isEven(this.mHighestRank)) {
            return false;
        }
        int[] nArray = this.constructRanksHistogram();
        int[] nArray2 = new int[nArray.length];
        int n = 1;
        while (n < nArray.length) {
            nArray2[n] = nArray[n];
            n += 2;
        }
        int[] nArray3 = (int[])nArray2.clone();
        int n2 = nArray.length - 3;
        while (n2 > 0) {
            int n3 = n2;
            nArray3[n3] = nArray3[n3] + nArray3[n2 + 2];
            n2 -= 2;
        }
        n2 = 1;
        int n4 = nArray.length - 1;
        while (n4 > 0) {
            if (nArray3[n4] < n2) {
                return false;
            }
            ++n2;
            n4 -= 2;
        }
        return true;
    }

    public static boolean isOdd(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return n % 2 != 0;
    }

    public static boolean isEven(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return n % 2 == 0;
    }

    public boolean isEmpty() {
        return this.mLevelRanking.isEmpty();
    }

    public boolean isNonAcceptingSink() {
        return this.mLevelRanking == null;
    }

    public boolean isLazyS(Collection<DoubleDecker<StateWithRankInfo<STATE>>> collection, LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck) {
        if (this.isOempty()) {
            return true;
        }
        for (DoubleDecker<StateWithRankInfo<STATE>> doubleDecker : collection) {
            if (!LevelRankingState.isOdd(this.mLevelRanking.get(doubleDecker.getDown()).get(doubleDecker.getUp().getState())) || levelRankingConstraintDrdCheck.inO(doubleDecker.getDown(), doubleDecker.getUp().getState())) continue;
            return false;
        }
        return true;
    }
}

