/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.IAssignmentCheckerAndGenerator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ScopedTransitivityGenerator<T, C>
implements IAssignmentCheckerAndGenerator<T> {
    protected final Map<C, NormalNode<C>> mContent2node = new HashMap<C, NormalNode<C>>();
    private final ScopeStack<C> mStack = new ScopeStack();
    private final TemporaryRootPredicate mTemporaryRootPredicate = new TemporaryRootPredicate();
    private final PersistentRootPredicate mPersistentRootPredicate = new PersistentRootPredicate();
    private final boolean mCompressPaths;

    public ScopedTransitivityGenerator(boolean bl) {
        this.mCompressPaths = bl;
    }

    @Override
    public void addVariable(T t) {
        assert (this.hasContent(t));
    }

    @Override
    public void makeAssignmentsPersistent() {
        this.makeAllScopesPersistent();
    }

    @Override
    public Iterable<Pair<T, Boolean>> checkAssignment(T t, boolean bl) {
        if (!bl) {
            return Collections.emptySet();
        }
        return this.assertEquality(t);
    }

    public void addContentIfNotPresent(C c) {
        this.mContent2node.put(c, new NormalNode<C>(c));
    }

    public void addContent(C c) {
        NormalNode<C> normalNode = this.mContent2node.put(c, new NormalNode<C>(c));
        assert (normalNode == null) : "Never add a content twice.";
    }

    public abstract boolean hasContent(T var1);

    public Iterable<Pair<T, Boolean>> assertEquality(T t) {
        NormalNode<C> normalNode;
        NormalNode<C> normalNode2 = this.find(this.mContent2node.get(this.getFirst(t)));
        if (normalNode2 == (normalNode = this.find(this.mContent2node.get(this.getSecond(t))))) {
            return Collections.emptySet();
        }
        BridgeNode<C> bridgeNode = this.mStack.bridgeTrees(normalNode2, normalNode);
        return this.getTransitiveInformation(normalNode2, normalNode, bridgeNode, t);
    }

    public void makeAllScopesPersistent() {
        this.mStack.makeAllScopesPersistent();
    }

    @Override
    public void revertOneScope() {
        this.mStack.revertOneScope();
    }

    @Override
    public void addScope() {
        this.mStack.addScope();
    }

    protected abstract T createPair(C var1, C var2);

    protected abstract C getFirst(T var1);

    protected abstract C getSecond(T var1);

    private NormalNode<C> find(NormalNode<C> normalNode) {
        if (this.mCompressPaths) {
            NormalNode<C> normalNode2 = this.findNextRoot(normalNode, this.mPersistentRootPredicate);
            if (normalNode != normalNode2) {
                INode<C> iNode = normalNode.getParent();
                assert (iNode.getClass() == NormalNode.class) : "";
                ((NormalNode)iNode).removeNormalChild(normalNode);
                normalNode.setParent(normalNode2);
                normalNode2.addNormalChild(normalNode);
            }
            return this.findNextRoot(normalNode2, this.mTemporaryRootPredicate);
        }
        return this.findNextRoot(normalNode, this.mTemporaryRootPredicate);
    }

    private NormalNode<C> findNextRoot(NormalNode<C> normalNode, INodePredicate iNodePredicate) {
        INode<Object> iNode = normalNode;
        while (!iNodePredicate.check(iNode)) {
            iNode = iNode.getParent();
        }
        assert (iNode.getClass() == NormalNode.class) : "Invalid tree root.";
        return iNode;
    }

    private Iterable<Pair<T, Boolean>> getTransitiveInformation(NormalNode<C> normalNode, NormalNode<C> normalNode2, BridgeNode<C> bridgeNode, T t) {
        return this.getTransitiveInformationArrays(normalNode, normalNode2, bridgeNode, t);
    }

    private Iterable<Pair<T, Boolean>> getTransitiveInformationArrays(NormalNode<C> normalNode, NormalNode<C> normalNode2, BridgeNode<C> bridgeNode, T t) {
        ArrayList<C> arrayList = this.toArrayList(normalNode, bridgeNode);
        ArrayList<C> arrayList2 = this.toArrayList(normalNode2, null);
        ArrayList<Pair<T, Boolean>> arrayList3 = new ArrayList<Pair<T, Boolean>>(arrayList.size() * arrayList2.size() - 1);
        for (C c : arrayList) {
            for (C c2 : arrayList2) {
                T t2 = this.createPair(c, c2);
                if (t2.equals(t)) continue;
                arrayList3.add(new Pair(t2, (Object)Boolean.TRUE));
            }
        }
        assert (arrayList3.size() == arrayList.size() * arrayList2.size() - 1);
        return arrayList3;
    }

    private ArrayList<C> toArrayList(NormalNode<C> normalNode, BridgeNode<C> bridgeNode) {
        ArrayList arrayList = new ArrayList();
        ArrayDeque arrayDeque = new ArrayDeque();
        arrayDeque.push(normalNode);
        while (!arrayDeque.isEmpty()) {
            INode iNode = (INode)arrayDeque.pop();
            if (iNode.getClass() == NormalNode.class) {
                arrayList.add(((NormalNode)iNode).getContent());
            }
            for (INode iNode2 : iNode.getChildren()) {
                if (iNode2 == bridgeNode) continue;
                arrayDeque.push(iNode2);
            }
        }
        return arrayList;
    }

    public static final class BridgeNode<T>
    implements INode<T> {
        private final NormalNode<T> mParent;
        private final NormalNode<T> mChild;

        public BridgeNode(NormalNode<T> normalNode, NormalNode<T> normalNode2) {
            this.mParent = normalNode;
            this.mChild = normalNode2;
        }

        @Override
        public NormalNode<T> getParent() {
            return this.mParent;
        }

        @Override
        public boolean isRoot() {
            return false;
        }

        @Override
        public boolean isTemporaryRootOrBridge() {
            return true;
        }

        @Override
        public Iterable<INode<T>> getChildren() {
            return Collections.singleton(this.mChild);
        }

        public NormalNode<T> getChild() {
            return this.mChild;
        }

        public String toString() {
            return "<BN: " + String.valueOf(this.mParent) + ", " + String.valueOf(this.mChild) + ">";
        }
    }

    public static interface INode<T> {
        public INode<T> getParent();

        public Iterable<INode<T>> getChildren();

        public boolean isRoot();

        public boolean isTemporaryRootOrBridge();
    }

    @FunctionalInterface
    public static interface INodePredicate {
        public boolean check(INode<?> var1);
    }

    public static final class NormalNode<T>
    implements INode<T> {
        private INode<T> mParent = this;
        private final T mContent;
        private Set<INode<T>> mNormalChildren;
        private Set<INode<T>> mBridgeChildren;

        public NormalNode(T t) {
            this.mContent = t;
            this.mNormalChildren = Collections.emptySet();
            this.mBridgeChildren = Collections.emptySet();
        }

        @Override
        public INode<T> getParent() {
            return this.mParent;
        }

        @Override
        public boolean isRoot() {
            return this.getParent() == this;
        }

        @Override
        public boolean isTemporaryRootOrBridge() {
            return this.isRoot() || this.mParent.getClass() == BridgeNode.class;
        }

        public void setParent(INode<T> iNode) {
            this.mParent = iNode;
        }

        public T getContent() {
            return this.mContent;
        }

        public void makeRoot() {
            this.setParent(this);
        }

        @Override
        public Iterable<INode<T>> getChildren() {
            return new ChildrenIterable<T>(this.mNormalChildren, this.mBridgeChildren);
        }

        public void addNormalChild(NormalNode<T> normalNode) {
            if (this.mNormalChildren.isEmpty()) {
                this.mNormalChildren = new LinkedHashSet<INode<T>>();
            }
            this.mNormalChildren.add(normalNode);
        }

        public void removeNormalChild(NormalNode<T> normalNode) {
            boolean bl = this.mNormalChildren.remove(normalNode);
            assert (bl) : "The bridge node was not present.";
            if (this.mNormalChildren.isEmpty()) {
                this.mNormalChildren = Collections.emptySet();
            }
        }

        public void addBridgeChild(BridgeNode<T> bridgeNode) {
            if (this.mBridgeChildren.isEmpty()) {
                this.mBridgeChildren = new LinkedHashSet<INode<T>>();
            }
            this.mBridgeChildren.add(bridgeNode);
        }

        public void removeBridgeChild(BridgeNode<T> bridgeNode) {
            boolean bl = this.mBridgeChildren.remove(bridgeNode);
            assert (bl) : "The bridge node was not present.";
            if (this.mBridgeChildren.isEmpty()) {
                this.mBridgeChildren = Collections.emptySet();
            }
        }

        public String toString() {
            return "<NN: " + String.valueOf(this.mContent) + ", " + (this.isTemporaryRootOrBridge() ? (this.isRoot() ? "Root, " : "TempRoot, ") : "no TempRoot nor Bridge, ") + this.mNormalChildren.size() + " NC, " + this.mBridgeChildren.size() + " BC>";
        }

        private static class ChildrenIterable<T>
        implements Iterable<INode<T>> {
            private final Collection<INode<T>> mNormalChildren;
            private final Collection<INode<T>> mBridgeChildren;

            public ChildrenIterable(Collection<INode<T>> collection, Collection<INode<T>> collection2) {
                this.mNormalChildren = collection;
                this.mBridgeChildren = collection2;
            }

            @Override
            public Iterator<INode<T>> iterator() {
                return new ChildrenIterator<T>(this.mNormalChildren, this.mBridgeChildren);
            }
        }

        private static class ChildrenIterator<T>
        implements Iterator<INode<T>> {
            private final Iterator<? extends INode<T>> mBridgeChildrenIterator;
            private Iterator<? extends INode<T>> mIterator;
            private boolean mIsAtBridgeNodes;

            public ChildrenIterator(Collection<INode<T>> collection, Collection<INode<T>> collection2) {
                this.mBridgeChildrenIterator = collection2.iterator();
                this.mIterator = collection.iterator();
                if (!this.mIterator.hasNext()) {
                    this.mIterator = this.mBridgeChildrenIterator;
                    this.mIsAtBridgeNodes = true;
                } else {
                    this.mIsAtBridgeNodes = false;
                }
            }

            @Override
            public boolean hasNext() {
                return this.mIterator.hasNext();
            }

            @Override
            public INode<T> next() {
                assert (this.mIterator.hasNext()) : "Iterator not used properly.";
                INode<T> iNode = this.mIterator.next();
                if (!this.mIsAtBridgeNodes && !this.mIterator.hasNext()) {
                    this.mIsAtBridgeNodes = true;
                    this.mIterator = this.mBridgeChildrenIterator;
                }
                return iNode;
            }
        }
    }

    public static final class PersistentRootPredicate
    implements INodePredicate {
        @Override
        public boolean check(INode<?> iNode) {
            return iNode.isTemporaryRootOrBridge();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static final class ScopeStack<T> {
        private final Deque<List<BridgeNode<T>>> mStack = new ArrayDeque<List<BridgeNode<T>>>();
        private final IBridgeAction<T> mRevertBridgeAction;
        private final IBridgeAction<T> mPersistentBridgeAction;

        public ScopeStack() {
            this.addScope();
            this.mRevertBridgeAction = new TemporaryBridgeAction();
            this.mPersistentBridgeAction = new PersistentBridgeAction();
        }

        public void addScope() {
            this.mStack.push(new ArrayList());
        }

        private List<BridgeNode<T>> removeScope() {
            List<BridgeNode<T>> list = this.mStack.pop();
            if (this.mStack.isEmpty()) {
                this.addScope();
            }
            return list;
        }

        public void makeAllScopesPersistent() {
            int n = this.mStack.size() - 1;
            while (n >= 0) {
                List<BridgeNode<T>> list = this.removeScope();
                this.processBridgeNodes(this.mPersistentBridgeAction, list);
                --n;
            }
        }

        public void revertOneScope() {
            List<BridgeNode<T>> list = this.removeScope();
            this.processBridgeNodes(this.mRevertBridgeAction, list);
        }

        public BridgeNode<T> bridgeTrees(NormalNode<T> normalNode, NormalNode<T> normalNode2) {
            BridgeNode<T> bridgeNode = new BridgeNode<T>(normalNode, normalNode2);
            normalNode2.setParent(bridgeNode);
            normalNode.addBridgeChild(bridgeNode);
            this.mStack.peek().add(bridgeNode);
            return bridgeNode;
        }

        private void processBridgeNodes(IBridgeAction<T> iBridgeAction, List<BridgeNode<T>> list) {
            int n = list.size() - 1;
            while (n >= 0) {
                assert (n == list.size() - 1);
                BridgeNode<T> bridgeNode = list.remove(n);
                iBridgeAction.execute(bridgeNode);
                --n;
            }
        }

        public String toString() {
            return this.mStack.toString();
        }

        @FunctionalInterface
        private static interface IBridgeAction<T> {
            public void execute(BridgeNode<T> var1);
        }

        private static final class PersistentBridgeAction<T>
        implements IBridgeAction<T> {
            private PersistentBridgeAction() {
            }

            @Override
            public void execute(BridgeNode<T> bridgeNode) {
                INode iNode = bridgeNode.getParent();
                NormalNode<T> normalNode = bridgeNode.getChild();
                normalNode.setParent(iNode);
                ((NormalNode)iNode).addNormalChild(normalNode);
                ((NormalNode)iNode).removeBridgeChild(bridgeNode);
            }

            public String toString() {
                return this.getClass().getSimpleName();
            }
        }

        private static final class TemporaryBridgeAction<T>
        implements IBridgeAction<T> {
            private TemporaryBridgeAction() {
            }

            @Override
            public void execute(BridgeNode<T> bridgeNode) {
                bridgeNode.getChild().makeRoot();
                ((NormalNode)bridgeNode.getParent()).removeBridgeChild(bridgeNode);
            }

            public String toString() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public static final class TemporaryRootPredicate
    implements INodePredicate {
        @Override
        public boolean check(INode<?> iNode) {
            return iNode.isRoot();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

