/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.DelayedGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.DelayedSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;

public class BuchiReduce<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private INestedWordAutomaton<LETTER, STATE> mOperand;
    private INestedWordAutomaton<LETTER, STATE> mResult;
    private final SimulationPerformance mStatistics;

    public BuchiReduce(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, new DelayedSimulation<LETTER, STATE>(automataLibraryServices.getProgressAwareTimer(), automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID), false, iMinimizationStateFactory, new DelayedGameGraph<LETTER, STATE>(automataLibraryServices, iMinimizationStateFactory, automataLibraryServices.getProgressAwareTimer(), automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID), iNestedWordAutomaton)));
    }

    protected BuchiReduce(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, DelayedSimulation<LETTER, STATE> delayedSimulation) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.mLogger.info((Object)this.startMessage());
        delayedSimulation.getGameGraph().generateGameGraphFromAutomaton();
        delayedSimulation.doSimulation();
        this.mResult = delayedSimulation.getResult();
        super.directResultConstruction(this.mResult);
        this.mStatistics = delayedSimulation.getSimulationPerformance();
        this.mLogger.info((Object)this.exitMessage());
    }

    @Override
    public Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkBuchiEquivalence(iMinimizationCheckResultStateFactory);
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = super.getAutomataOperationStatistics();
        this.mStatistics.exportToExistingAutomataOperationStatistics(automataOperationStatistics);
        return automataOperationStatistics;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    protected ILogger getLogger() {
        return this.mLogger;
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    protected AutomataLibraryServices getServices() {
        return this.mServices;
    }
}

