/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.MultipleDataOption;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ComparisonTables {
    public static final String NO_VALUE = "NO_VALUE";
    public static final long SECONDS_TO_MILLIS = 1000L;
    private static final int DECIMAL_PLACES = 3;
    private static final int FULL_PERCENTAGE = 100;
    private static final int SMALL_BUCHI_SIZE = 20;

    private ComparisonTables() {
    }

    public static List<String> createAveragedSimulationAlgoWorkTable(LinkedList<LinkedList<SimulationPerformance>> linkedList, String string) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        LinkedHashMap<Pair<SimulationOrMinimizationType, Boolean>, LinkedList<SimulationPerformance>> linkedHashMap = ComparisonTables.calcSimToPerformances(linkedList);
        StringBuilder stringBuilder = new StringBuilder("TYPE").append(string).append("USED_SCCS");
        stringBuilder.append(string).append((Object)CountingMeasure.BUCHI_STATES);
        stringBuilder.append(string).append((Object)CountingMeasure.SIMULATION_STEPS).append(" / ").append((Object)CountingMeasure.GAMEGRAPH_VERTICES);
        stringBuilder.append(string).append((Object)TimeMeasure.OVERALL);
        stringBuilder.append(string).append((Object)CountingMeasure.SIMULATION_STEPS);
        stringBuilder.append(string).append((Object)CountingMeasure.GAMEGRAPH_VERTICES);
        stringBuilder.append(string).append((Object)CountingMeasure.REMOVED_STATES);
        linkedList2.add(stringBuilder.toString());
        for (Map.Entry<Pair<SimulationOrMinimizationType, Boolean>, LinkedList<SimulationPerformance>> entry : linkedHashMap.entrySet()) {
            int n;
            StringBuilder stringBuilder2 = new StringBuilder().append(entry.getKey().getFirst()).append(string).append(entry.getKey().getSecond());
            int n2 = 0;
            int n3 = 0;
            for (SimulationPerformance simulationPerformance : entry.getValue()) {
                int n4 = simulationPerformance.getCountingMeasureResult(CountingMeasure.BUCHI_STATES);
                if (n4 != -1) {
                    n2 += n4;
                }
                ++n3;
            }
            long l = Math.round(((double)n2 + 0.0) / (double)n3);
            String string2 = Long.toString(l);
            if (l == 0L) {
                string2 = NO_VALUE;
            }
            stringBuilder2.append(string).append(string2);
            int n5 = 0;
            int n6 = 0;
            for (SimulationPerformance simulationPerformance : entry.getValue()) {
                n = simulationPerformance.getCountingMeasureResult(CountingMeasure.SIMULATION_STEPS);
                if (n != -1) {
                    n5 += n;
                }
                ++n6;
            }
            long l2 = Math.round(((double)n5 + 0.0) / (double)n6);
            n = 0;
            int n7 = 0;
            for (SimulationPerformance simulationPerformance : entry.getValue()) {
                int n8 = simulationPerformance.getCountingMeasureResult(CountingMeasure.GAMEGRAPH_VERTICES);
                if (n8 != -1) {
                    n += n8;
                }
                ++n7;
            }
            long l3 = Math.round(((double)n + 0.0) / (double)n7);
            string2 = l2 == 0L || l3 == 0L ? NO_VALUE : Float.toString(ComparisonTables.roundTo(((double)l2 + 0.0) / (double)l3, 3));
            stringBuilder2.append(string).append(string2);
            long l4 = 0L;
            int n9 = 0;
            for (SimulationPerformance simulationPerformance : entry.getValue()) {
                long l5 = simulationPerformance.getTimeMeasureResult(TimeMeasure.OVERALL, MultipleDataOption.ADDITIVE);
                if (l5 != -1L) {
                    l4 += l5;
                }
                ++n9;
            }
            long l6 = Math.round(((double)l4 + 0.0) / (double)n9);
            if (l6 == 0L) {
                string2 = NO_VALUE;
            } else {
                float f = ComparisonTables.millisToSeconds(l6);
                string2 = Float.toString(f);
            }
            stringBuilder2.append(string).append(string2);
            string2 = Long.toString(l2);
            if (l2 == 0L) {
                string2 = NO_VALUE;
            }
            stringBuilder2.append(string).append(string2);
            string2 = Long.toString(l3);
            if (l3 == 0L) {
                string2 = NO_VALUE;
            }
            stringBuilder2.append(string).append(string2);
            int n10 = 0;
            int n11 = 0;
            for (SimulationPerformance simulationPerformance : entry.getValue()) {
                int n12 = simulationPerformance.getCountingMeasureResult(CountingMeasure.REMOVED_STATES);
                if (n12 != -1) {
                    n10 += n12;
                }
                ++n11;
            }
            long l7 = Math.round(((double)n10 + 0.0) / (double)n11);
            string2 = Long.toString(l7);
            if (l7 == 0L) {
                string2 = NO_VALUE;
            }
            stringBuilder2.append(string).append(string2);
            linkedList2.add(stringBuilder2.toString());
        }
        return linkedList2;
    }

    public static List<String> createAveragedSimulationFullComparisonTable(LinkedList<LinkedList<SimulationPerformance>> linkedList, String string, SimulationOrMinimizationType simulationOrMinimizationType, boolean bl, boolean bl2, boolean bl3) {
        Object object2;
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        LinkedHashMap<Pair<SimulationOrMinimizationType, Boolean>, LinkedList<SimulationPerformance>> linkedHashMap = ComparisonTables.calcSimToPerformances(linkedList);
        StringBuilder stringBuilder = new StringBuilder("TYPE").append(string).append("USED_SCCS");
        Pair<Set<TimeMeasure>, Set<CountingMeasure>> pair = ComparisonTables.getCompleteHeaderMeasures(linkedList);
        Set set = (Set)pair.getFirst();
        for (Object object2 : set) {
            stringBuilder.append(string).append(object2);
        }
        object2 = (Set)pair.getSecond();
        Iterator<Object> iterator = object2.iterator();
        while (iterator.hasNext()) {
            CountingMeasure countingMeasure = (CountingMeasure)((Object)iterator.next());
            stringBuilder.append(string).append((Object)countingMeasure);
        }
        linkedList2.add(stringBuilder.toString());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            String string2;
            long l;
            int n;
            if (simulationOrMinimizationType != null && ((Pair)entry.getKey()).getFirst() != simulationOrMinimizationType) continue;
            StringBuilder stringBuilder2 = new StringBuilder().append(((Pair)entry.getKey()).getFirst()).append(string).append(((Pair)entry.getKey()).getSecond());
            HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
            if (bl || bl2) {
                for (Object object3 : (LinkedList)entry.getValue()) {
                    int n2;
                    if (bl) {
                        n2 = ((SimulationPerformance)object3).getCountingMeasureResult(CountingMeasure.BUCHI_STATES);
                        if (((SimulationPerformance)object3).hasTimedOut() || ((SimulationPerformance)object3).isOutOfMemory() || n2 == 0 || n2 == -1) {
                            hashMap.put(object3, true);
                        }
                    }
                    if (!bl2 || (n2 = ((SimulationPerformance)object3).getCountingMeasureResult(CountingMeasure.BUCHI_TRANSITIONS_RETURN)) != 0 && n2 != -1) continue;
                    hashMap.put(object3, true);
                }
            }
            for (Object object3 : set) {
                long l2 = 0L;
                n = 0;
                for (SimulationPerformance simulationPerformance : (LinkedList)entry.getValue()) {
                    if (hashMap.get(simulationPerformance) != null && ((Boolean)hashMap.get(simulationPerformance)).booleanValue()) continue;
                    long l3 = simulationPerformance.getTimeMeasureResult((TimeMeasure)((Object)object3), MultipleDataOption.ADDITIVE);
                    if (l3 != -1L) {
                        l2 += l3;
                    }
                    ++n;
                }
                l = Math.round(((double)l2 + 0.0) / (double)n);
                if (l == 0L) {
                    string2 = NO_VALUE;
                } else {
                    float f = ComparisonTables.millisToSeconds(l);
                    string2 = Float.toString(f);
                }
                stringBuilder2.append(string).append(string2);
            }
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Double d;
                Object object3;
                object3 = (CountingMeasure)((Object)iterator2.next());
                long l4 = 0L;
                n = 0;
                for (SimulationPerformance simulationPerformance : (LinkedList)entry.getValue()) {
                    if (hashMap.get(simulationPerformance) != null && ((Boolean)hashMap.get(simulationPerformance)).booleanValue()) continue;
                    long l5 = simulationPerformance.getCountingMeasureResult((CountingMeasure)((Object)object3));
                    if (l5 != -1L) {
                        l4 += l5;
                    }
                    ++n;
                }
                l = Math.round(((double)l4 + 0.0) / (double)n);
                string2 = Long.toString(l);
                if (l == 0L) {
                    string2 = NO_VALUE;
                }
                if (bl3 && (d = ComparisonTables.convertTransitionDensityToDouble((CountingMeasure)((Object)object3), l4)) != null) {
                    double d2 = d / (double)n;
                    string2 = Double.toString(d2);
                    if (d2 == 0.0) {
                        string2 = NO_VALUE;
                    }
                }
                stringBuilder2.append(string).append(string2);
            }
            linkedList2.add(stringBuilder2.toString());
        }
        return linkedList2;
    }

    public static List<String> createAveragedSimulationPerDirectoryTable(LinkedList<LinkedList<SimulationPerformance>> linkedList, String string, SimulationOrMinimizationType simulationOrMinimizationType, boolean bl, boolean bl2, boolean bl3) {
        Object object2;
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        NestedMap2<String, Pair<SimulationOrMinimizationType, Boolean>, LinkedList<SimulationPerformance>> nestedMap2 = ComparisonTables.calcDirAndSimToPerformances(linkedList);
        StringBuilder stringBuilder = new StringBuilder("DIRECTORY").append(string).append("TYPE").append(string).append("USED_SCCS");
        Pair<Set<TimeMeasure>, Set<CountingMeasure>> pair = ComparisonTables.getCompleteHeaderMeasures(linkedList);
        Set set = (Set)pair.getFirst();
        for (Object object2 : set) {
            stringBuilder.append(string).append(object2);
        }
        object2 = (Set)pair.getSecond();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Object object3 = (CountingMeasure)((Object)iterator.next());
            stringBuilder.append(string).append(object3);
        }
        linkedList2.add(stringBuilder.toString());
        for (Object object3 : nestedMap2.keySet()) {
            for (Map.Entry entry : nestedMap2.get(object3).entrySet()) {
                String string2;
                long l;
                int n;
                if (simulationOrMinimizationType != null && ((Pair)entry.getKey()).getFirst() != simulationOrMinimizationType) continue;
                StringBuilder stringBuilder2 = new StringBuilder().append((String)object3).append(string).append(((Pair)entry.getKey()).getFirst()).append(string).append(((Pair)entry.getKey()).getSecond());
                HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
                if (bl || bl2) {
                    for (Object object4 : (LinkedList)entry.getValue()) {
                        int n2;
                        if (bl) {
                            n2 = ((SimulationPerformance)object4).getCountingMeasureResult(CountingMeasure.BUCHI_STATES);
                            if (((SimulationPerformance)object4).hasTimedOut() || ((SimulationPerformance)object4).isOutOfMemory() || n2 == 0 || n2 == -1) {
                                hashMap.put(object4, true);
                            }
                        }
                        if (!bl2 || (n2 = ((SimulationPerformance)object4).getCountingMeasureResult(CountingMeasure.BUCHI_TRANSITIONS_RETURN)) != 0 && n2 != -1) continue;
                        hashMap.put(object4, true);
                    }
                }
                for (Object object4 : set) {
                    long l2 = 0L;
                    n = 0;
                    for (SimulationPerformance simulationPerformance : (LinkedList)entry.getValue()) {
                        if (hashMap.get(simulationPerformance) != null && ((Boolean)hashMap.get(simulationPerformance)).booleanValue()) continue;
                        long l3 = simulationPerformance.getTimeMeasureResult((TimeMeasure)((Object)object4), MultipleDataOption.ADDITIVE);
                        if (l3 != -1L) {
                            l2 += l3;
                        }
                        ++n;
                    }
                    l = Math.round(((double)l2 + 0.0) / (double)n);
                    if (l == 0L) {
                        string2 = NO_VALUE;
                    } else {
                        float f = ComparisonTables.millisToSeconds(l);
                        string2 = Float.toString(f);
                    }
                    stringBuilder2.append(string).append(string2);
                }
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Double d;
                    Object object4;
                    object4 = (CountingMeasure)((Object)iterator2.next());
                    long l4 = 0L;
                    n = 0;
                    for (SimulationPerformance simulationPerformance : (LinkedList)entry.getValue()) {
                        if (hashMap.get(simulationPerformance) != null && ((Boolean)hashMap.get(simulationPerformance)).booleanValue()) continue;
                        long l5 = simulationPerformance.getCountingMeasureResult((CountingMeasure)((Object)object4));
                        if (l5 != -1L) {
                            l4 += l5;
                        }
                        ++n;
                    }
                    l = Math.round(((double)l4 + 0.0) / (double)n);
                    string2 = Long.toString(l);
                    if (l == 0L) {
                        string2 = NO_VALUE;
                    }
                    if (bl3 && (d = ComparisonTables.convertTransitionDensityToDouble((CountingMeasure)((Object)object4), l4)) != null) {
                        double d2 = d / (double)n;
                        string2 = Double.toString(d2);
                        if (d2 == 0.0) {
                            string2 = NO_VALUE;
                        }
                    }
                    stringBuilder2.append(string).append(string2);
                }
                linkedList2.add(stringBuilder2.toString());
            }
        }
        return linkedList2;
    }

    public static List<String> createAveragedSimulationTimePartitioningTable(LinkedList<LinkedList<SimulationPerformance>> linkedList, String string) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        LinkedHashMap<Pair<SimulationOrMinimizationType, Boolean>, LinkedList<SimulationPerformance>> linkedHashMap = ComparisonTables.calcSimToPerformances(linkedList);
        StringBuilder stringBuilder = new StringBuilder("TYPE").append(string).append("USED_SCCS");
        stringBuilder.append(string).append((Object)CountingMeasure.BUCHI_STATES);
        stringBuilder.append(string).append((Object)TimeMeasure.OVERALL);
        Pair<Set<TimeMeasure>, Set<CountingMeasure>> pair = ComparisonTables.getCompleteHeaderMeasures(linkedList);
        Set set = (Set)pair.getFirst();
        for (TimeMeasure object : set) {
            if (object.equals((Object)TimeMeasure.OVERALL)) continue;
            stringBuilder.append(string).append((Object)object);
        }
        linkedList2.add(stringBuilder.toString());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            StringBuilder stringBuilder2 = new StringBuilder().append(((Pair)entry.getKey()).getFirst()).append(string).append(((Pair)entry.getKey()).getSecond());
            int n = 0;
            int n2 = 0;
            for (SimulationPerformance simulationPerformance : (LinkedList)entry.getValue()) {
                int n3 = simulationPerformance.getCountingMeasureResult(CountingMeasure.BUCHI_STATES);
                if (n3 != -1) {
                    n += n3;
                }
                ++n2;
            }
            long l = Math.round(((double)n + 0.0) / (double)n2);
            String string2 = Long.toString(l);
            if (l == 0L) {
                string2 = NO_VALUE;
            }
            stringBuilder2.append(string).append(string2);
            long l2 = 0L;
            int n4 = 0;
            for (SimulationPerformance simulationPerformance : (LinkedList)entry.getValue()) {
                long timeMeasure = simulationPerformance.getTimeMeasureResult(TimeMeasure.OVERALL, MultipleDataOption.ADDITIVE);
                if (timeMeasure != -1L) {
                    l2 += timeMeasure;
                }
                ++n4;
            }
            long l3 = Math.round(((double)l2 + 0.0) / (double)n4);
            if (l3 == 0L) {
                string2 = NO_VALUE;
            } else {
                float f = ComparisonTables.millisToSeconds(l3);
                string2 = Float.toString(f);
            }
            stringBuilder2.append(string).append(string2);
            for (TimeMeasure timeMeasure : set) {
                int n5;
                if (timeMeasure.equals((Object)TimeMeasure.OVERALL)) continue;
                long l4 = 0L;
                int n6 = 0;
                for (SimulationPerformance simulationPerformance : (LinkedList)entry.getValue()) {
                    long l5 = simulationPerformance.getTimeMeasureResult(timeMeasure, MultipleDataOption.ADDITIVE);
                    if (l5 != -1L) {
                        l4 += l5;
                    }
                    ++n6;
                }
                long l6 = Math.round(((double)l4 + 0.0) / (double)n6);
                string2 = l6 == 0L || l3 == 0L ? NO_VALUE : ((n5 = ComparisonTables.percentageOf(l6, l3)) == 0 ? NO_VALUE : Integer.toString(n5));
                stringBuilder2.append(string).append(string2);
            }
            linkedList2.add(stringBuilder2.toString());
        }
        return linkedList2;
    }

    public static List<String> createInstanceAlgoWorkTable(LinkedList<LinkedList<SimulationPerformance>> linkedList, String string) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        StringBuilder stringBuilder = new StringBuilder("NAME").append(string).append("TYPE").append(string).append("USED_SCCS").append(string).append("TIMED_OUT").append(string).append("OOM");
        stringBuilder.append(string).append((Object)CountingMeasure.BUCHI_STATES);
        stringBuilder.append(string).append((Object)CountingMeasure.SIMULATION_STEPS).append(" / ").append((Object)CountingMeasure.GAMEGRAPH_VERTICES);
        stringBuilder.append(string).append((Object)TimeMeasure.OVERALL);
        stringBuilder.append(string).append((Object)CountingMeasure.SIMULATION_STEPS);
        stringBuilder.append(string).append((Object)CountingMeasure.GAMEGRAPH_VERTICES);
        stringBuilder.append(string).append((Object)CountingMeasure.REMOVED_STATES);
        linkedList2.add(stringBuilder.toString());
        for (LinkedList linkedList3 : linkedList) {
            for (SimulationPerformance simulationPerformance : linkedList3) {
                String string2;
                SimulationOrMinimizationType simulationOrMinimizationType = simulationPerformance.getSimType();
                String string3 = simulationPerformance.getName();
                StringBuilder stringBuilder2 = new StringBuilder().append(string3).append(string).append((Object)simulationOrMinimizationType).append(string).append(simulationPerformance.isUsingSccs()).append(string).append(simulationPerformance.hasTimedOut()).append(string).append(simulationPerformance.isOutOfMemory());
                int n = simulationPerformance.getCountingMeasureResult(CountingMeasure.BUCHI_STATES);
                String string4 = Integer.toString(n);
                if (n == -1) {
                    string4 = NO_VALUE;
                }
                stringBuilder2.append(string).append(string4);
                int n2 = simulationPerformance.getCountingMeasureResult(CountingMeasure.SIMULATION_STEPS);
                int n3 = simulationPerformance.getCountingMeasureResult(CountingMeasure.GAMEGRAPH_VERTICES);
                String string5 = n2 == -1 || n3 == -1 ? NO_VALUE : Float.toString(ComparisonTables.roundTo(((double)n2 + 0.0) / (double)n3, 3));
                stringBuilder2.append(string).append(string5);
                long l = simulationPerformance.getTimeMeasureResult(TimeMeasure.OVERALL, MultipleDataOption.ADDITIVE);
                if (l == -1L) {
                    string2 = NO_VALUE;
                } else {
                    float f = ComparisonTables.millisToSeconds(l);
                    string2 = Float.toString(f);
                }
                stringBuilder2.append(string).append(string2);
                String string6 = n2 == -1 ? NO_VALUE : Integer.toString(n2);
                stringBuilder2.append(string).append(string6);
                String string7 = Integer.toString(n3);
                if (n3 == -1) {
                    string7 = NO_VALUE;
                }
                stringBuilder2.append(string).append(string7);
                int n4 = simulationPerformance.getCountingMeasureResult(CountingMeasure.REMOVED_STATES);
                String string8 = Integer.toString(n4);
                if (n4 == -1) {
                    string8 = NO_VALUE;
                }
                stringBuilder2.append(string).append(string8);
                linkedList2.add(stringBuilder2.toString());
            }
            linkedList2.add("");
        }
        return linkedList2;
    }

    public static List<String> createInstanceFullComparisonTable(LinkedList<LinkedList<SimulationPerformance>> linkedList, String string, SimulationOrMinimizationType simulationOrMinimizationType, boolean bl, boolean bl2, boolean bl3) {
        Object object2;
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        StringBuilder stringBuilder = new StringBuilder("NAME").append(string).append("TYPE").append(string).append("USED_SCCS").append(string).append("TIMED_OUT").append(string).append("OOM");
        Pair<Set<TimeMeasure>, Set<CountingMeasure>> pair = ComparisonTables.getCompleteHeaderMeasures(linkedList);
        Set set = (Set)pair.getFirst();
        for (Object object2 : set) {
            stringBuilder.append(string).append(object2);
        }
        object2 = (Set)pair.getSecond();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            CountingMeasure countingMeasure = (CountingMeasure)((Object)iterator.next());
            stringBuilder.append(string).append((Object)countingMeasure);
        }
        linkedList2.add(stringBuilder.toString());
        for (LinkedList linkedList3 : linkedList) {
            for (SimulationPerformance simulationPerformance : linkedList3) {
                Object object3;
                int n;
                SimulationOrMinimizationType simulationOrMinimizationType2 = simulationPerformance.getSimType();
                String string2 = simulationPerformance.getName();
                if (simulationOrMinimizationType != null && !simulationOrMinimizationType2.equals((Object)simulationOrMinimizationType)) continue;
                if (bl) {
                    n = simulationPerformance.getCountingMeasureResult(CountingMeasure.BUCHI_STATES);
                    if (simulationPerformance.hasTimedOut() || simulationPerformance.isOutOfMemory() || n == 0 || n == -1) break;
                }
                if (bl2 && ((n = simulationPerformance.getCountingMeasureResult(CountingMeasure.BUCHI_TRANSITIONS_RETURN)) == 0 || n == -1)) break;
                StringBuilder stringBuilder2 = new StringBuilder().append(string2).append(string).append((Object)simulationOrMinimizationType2).append(string).append(simulationPerformance.isUsingSccs()).append(string).append(simulationPerformance.hasTimedOut()).append(string).append(simulationPerformance.isOutOfMemory());
                for (Enum enum_ : set) {
                    long l = simulationPerformance.getTimeMeasureResult((TimeMeasure)enum_, MultipleDataOption.ADDITIVE);
                    if (l == -1L) {
                        object3 = NO_VALUE;
                    } else {
                        float f = ComparisonTables.millisToSeconds(l);
                        object3 = Float.toString(f);
                    }
                    stringBuilder2.append(string).append((String)object3);
                }
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Enum enum_;
                    enum_ = (CountingMeasure)((Object)iterator2.next());
                    int n2 = simulationPerformance.getCountingMeasureResult((CountingMeasure)enum_);
                    String string3 = Integer.toString(n2);
                    if (n2 == -1) {
                        string3 = NO_VALUE;
                    } else if (bl3 && (object3 = ComparisonTables.convertTransitionDensityToDouble((CountingMeasure)enum_, n2)) != null) {
                        string3 = Double.toString((Double)object3);
                    }
                    stringBuilder2.append(string).append(string3);
                }
                linkedList2.add(stringBuilder2.toString());
            }
            if (simulationOrMinimizationType != null) continue;
            linkedList2.add("");
        }
        return linkedList2;
    }

    public static List<String> createInstanceTimePartitioningTable(LinkedList<LinkedList<SimulationPerformance>> linkedList, String string) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        StringBuilder stringBuilder = new StringBuilder("NAME").append(string).append("TYPE").append(string).append("USED_SCCS").append(string).append("TIMED_OUT").append(string).append("OOM");
        stringBuilder.append(string).append((Object)CountingMeasure.BUCHI_STATES);
        stringBuilder.append(string).append((Object)TimeMeasure.OVERALL);
        Pair<Set<TimeMeasure>, Set<CountingMeasure>> pair = ComparisonTables.getCompleteHeaderMeasures(linkedList);
        Set set = (Set)pair.getFirst();
        for (TimeMeasure object : set) {
            if (object.equals((Object)TimeMeasure.OVERALL)) continue;
            stringBuilder.append(string).append((Object)object).append("(%)");
        }
        linkedList2.add(stringBuilder.toString());
        for (LinkedList linkedList3 : linkedList) {
            for (SimulationPerformance simulationPerformance : linkedList3) {
                String string2;
                SimulationOrMinimizationType simulationOrMinimizationType = simulationPerformance.getSimType();
                String string3 = simulationPerformance.getName();
                StringBuilder stringBuilder2 = new StringBuilder().append(string3).append(string).append((Object)simulationOrMinimizationType).append(string).append(simulationPerformance.isUsingSccs()).append(string).append(simulationPerformance.hasTimedOut()).append(string).append(simulationPerformance.isOutOfMemory());
                int n = simulationPerformance.getCountingMeasureResult(CountingMeasure.BUCHI_STATES);
                String string4 = n == -1 ? NO_VALUE : Integer.toString(n);
                stringBuilder2.append(string).append(string4);
                long l = simulationPerformance.getTimeMeasureResult(TimeMeasure.OVERALL, MultipleDataOption.ADDITIVE);
                long l2 = 0L;
                if (l == -1L) {
                    string2 = NO_VALUE;
                } else {
                    float f = ComparisonTables.millisToSeconds(l);
                    string2 = Float.toString(f);
                    l2 = l;
                }
                stringBuilder2.append(string).append(string2);
                for (TimeMeasure timeMeasure : set) {
                    int n2;
                    if (timeMeasure.equals((Object)TimeMeasure.OVERALL)) continue;
                    l = simulationPerformance.getTimeMeasureResult(timeMeasure, MultipleDataOption.ADDITIVE);
                    string2 = l == -1L || l2 == 0L ? NO_VALUE : ((n2 = ComparisonTables.percentageOf(l, l2)) == 0 ? NO_VALUE : Integer.toString(n2));
                    stringBuilder2.append(string).append(string2);
                }
                linkedList2.add(stringBuilder2.toString());
            }
            linkedList2.add("");
        }
        return linkedList2;
    }

    public static List<String> createLongerThanOneSecondNamesTable(LinkedList<LinkedList<SimulationPerformance>> linkedList) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        linkedList2.add("NAME");
        for (LinkedList linkedList3 : linkedList) {
            boolean bl = false;
            String string = "";
            for (SimulationPerformance simulationPerformance : linkedList3) {
                string = simulationPerformance.getName();
                long l = simulationPerformance.getTimeMeasureResult(TimeMeasure.OVERALL, MultipleDataOption.ADDITIVE);
                if (l == -1L || l <= 1000L) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            linkedList2.add(string);
        }
        return linkedList2;
    }

    public static List<String> createNoRemoveNamesTable(LinkedList<LinkedList<SimulationPerformance>> linkedList) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        linkedList2.add("NAME");
        for (LinkedList linkedList3 : linkedList) {
            boolean bl = false;
            String string = "";
            for (SimulationPerformance simulationPerformance : linkedList3) {
                string = simulationPerformance.getName();
                int n = simulationPerformance.getCountingMeasureResult(CountingMeasure.REMOVED_STATES);
                if (n == -1 || n <= 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            linkedList2.add(string);
        }
        return linkedList2;
    }

    public static List<String> createSmallSizeNamesTable(LinkedList<LinkedList<SimulationPerformance>> linkedList) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        linkedList2.add("NAME");
        for (LinkedList linkedList3 : linkedList) {
            boolean bl = false;
            String string = "";
            for (SimulationPerformance simulationPerformance : linkedList3) {
                string = simulationPerformance.getName();
                int n = simulationPerformance.getCountingMeasureResult(CountingMeasure.BUCHI_STATES);
                if (n != -1 && n >= 20) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            linkedList2.add(string);
        }
        return linkedList2;
    }

    public static List<String> createTimedOutNamesTable(LinkedList<LinkedList<SimulationPerformance>> linkedList) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        if (linkedList.isEmpty()) {
            return linkedList2;
        }
        linkedList2.add("NAME");
        for (LinkedList linkedList3 : linkedList) {
            boolean bl = false;
            String string = "";
            for (SimulationPerformance simulationPerformance : linkedList3) {
                string = simulationPerformance.getName();
                if (!simulationPerformance.hasTimedOut()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            linkedList2.add(string);
        }
        return linkedList2;
    }

    public static float millisToSeconds(long l) {
        return ComparisonTables.roundTo(((double)l + 0.0) / 1000.0, 3);
    }

    public static long secondsToMillis(float f) {
        return Math.round(f * 1000.0f);
    }

    private static NestedMap2<String, Pair<SimulationOrMinimizationType, Boolean>, LinkedList<SimulationPerformance>> calcDirAndSimToPerformances(LinkedList<LinkedList<SimulationPerformance>> linkedList) {
        NestedMap2 nestedMap2 = new NestedMap2();
        for (LinkedList linkedList2 : linkedList) {
            boolean bl = false;
            boolean bl2 = false;
            LinkedList<SimulationPerformance> linkedList3 = new LinkedList<SimulationPerformance>();
            for (SimulationPerformance simulationPerformance : linkedList2) {
                if (simulationPerformance.hasTimedOut()) {
                    bl = true;
                    break;
                }
                if (simulationPerformance.isOutOfMemory()) {
                    bl2 = true;
                    break;
                }
                linkedList3.add(simulationPerformance);
            }
            if (bl || bl2) continue;
            for (SimulationPerformance simulationPerformance : linkedList3) {
                Pair pair;
                SimulationOrMinimizationType simulationOrMinimizationType = simulationPerformance.getSimType();
                String string = simulationPerformance.getName();
                String string2 = File.separator;
                Pattern pattern = Pattern.compile("(.*)\\" + string2 + "[^\\" + string2 + "]*");
                Matcher matcher = pattern.matcher(string);
                String string3 = matcher.find() ? matcher.group(1) : string;
                LinkedList<SimulationPerformance> linkedList4 = (LinkedList<SimulationPerformance>)nestedMap2.get((Object)string3, (Object)(pair = new Pair((Object)simulationOrMinimizationType, (Object)simulationPerformance.isUsingSccs())));
                if (linkedList4 == null) {
                    linkedList4 = new LinkedList<SimulationPerformance>();
                    nestedMap2.put((Object)string3, (Object)pair, linkedList4);
                }
                linkedList4.add(simulationPerformance);
            }
        }
        return nestedMap2;
    }

    private static LinkedHashMap<Pair<SimulationOrMinimizationType, Boolean>, LinkedList<SimulationPerformance>> calcSimToPerformances(LinkedList<LinkedList<SimulationPerformance>> linkedList) {
        LinkedHashMap<Pair<SimulationOrMinimizationType, Boolean>, LinkedList<SimulationPerformance>> linkedHashMap = new LinkedHashMap<Pair<SimulationOrMinimizationType, Boolean>, LinkedList<SimulationPerformance>>();
        for (LinkedList linkedList2 : linkedList) {
            boolean bl = false;
            boolean bl2 = false;
            LinkedList<SimulationPerformance> linkedList3 = new LinkedList<SimulationPerformance>();
            for (SimulationPerformance simulationPerformance : linkedList2) {
                if (simulationPerformance.hasTimedOut()) {
                    bl = true;
                    break;
                }
                if (simulationPerformance.isOutOfMemory()) {
                    bl2 = true;
                    break;
                }
                linkedList3.add(simulationPerformance);
            }
            if (bl || bl2) continue;
            for (SimulationPerformance simulationPerformance : linkedList3) {
                SimulationOrMinimizationType simulationOrMinimizationType = simulationPerformance.getSimType();
                Pair pair = new Pair((Object)simulationOrMinimizationType, (Object)simulationPerformance.isUsingSccs());
                LinkedList<SimulationPerformance> linkedList4 = linkedHashMap.get(pair);
                if (linkedList4 == null) {
                    linkedList4 = new LinkedList();
                    linkedHashMap.put((Pair<SimulationOrMinimizationType, Boolean>)pair, linkedList4);
                }
                linkedList4.add(simulationPerformance);
            }
        }
        return linkedHashMap;
    }

    private static Double convertTransitionDensityToDouble(CountingMeasure countingMeasure, long l) {
        if (countingMeasure == CountingMeasure.BUCHI_TRANSITION_DENSITY_MILLION || countingMeasure == CountingMeasure.BUCHI_TRANSITION_INTERNAL_DENSITY_MILLION || countingMeasure == CountingMeasure.BUCHI_TRANSITION_CALL_DENSITY_MILLION || countingMeasure == CountingMeasure.BUCHI_TRANSITION_RETURN_DENSITY_MILLION || countingMeasure == CountingMeasure.RESULT_TRANSITION_DENSITY_MILLION || countingMeasure == CountingMeasure.RESULT_TRANSITION_INTERNAL_DENSITY_MILLION || countingMeasure == CountingMeasure.RESULT_TRANSITION_CALL_DENSITY_MILLION || countingMeasure == CountingMeasure.RESULT_TRANSITION_RETURN_DENSITY_MILLION) {
            return ((double)l + 0.0) / 1000000.0;
        }
        return null;
    }

    private static Pair<Set<TimeMeasure>, Set<CountingMeasure>> getCompleteHeaderMeasures(LinkedList<LinkedList<SimulationPerformance>> linkedList) {
        HashSet<TimeMeasure> hashSet = new HashSet<TimeMeasure>();
        HashSet<CountingMeasure> hashSet2 = new HashSet<CountingMeasure>();
        for (LinkedList linkedList2 : linkedList) {
            for (SimulationPerformance simulationPerformance : linkedList2) {
                Set<TimeMeasure> set = simulationPerformance.getTimeMeasures().keySet();
                hashSet.addAll(set);
                Set<CountingMeasure> set2 = simulationPerformance.getCountingMeasures().keySet();
                hashSet2.addAll(set2);
            }
        }
        return new Pair(hashSet, hashSet2);
    }

    private static int percentageOf(long l, long l2) {
        return (int)Math.round(((double)l + 0.0) / (double)l2 * 100.0);
    }

    private static float roundTo(double d, int n) {
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        return bigDecimal.floatValue();
    }
}

