/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin;

import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IUltimatePlugin;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceBinder;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public final class SettingsManager {
    private static final String SAVING_PREFERENCES_FAILED_WITH_EXCEPTION = "Saving preferences failed with exception: ";
    private final ILogger mLogger;
    private final Map<String, LogPreferenceChangeListener> mActivePreferenceListener;

    public SettingsManager(ILogger iLogger) {
        this.mLogger = iLogger;
        this.mActivePreferenceListener = new HashMap<String, LogPreferenceChangeListener>();
    }

    public void registerPlugin(IUltimatePlugin iUltimatePlugin) {
        if (iUltimatePlugin == null) {
            return;
        }
        String string = iUltimatePlugin.getPluginName();
        IPreferenceInitializer iPreferenceInitializer = iUltimatePlugin.getPreferences();
        if (iPreferenceInitializer == null) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Plugin " + string + " does not have preferences"));
            }
            return;
        }
        String string2 = iUltimatePlugin.getPluginID();
        RcpPreferenceBinder.registerDefaultPreferences(string2, iPreferenceInitializer.getPreferenceItems());
        this.attachLogPreferenceChangeListenerToPlugin(string2, string);
        this.logDefaultPreferences(string2, string);
    }

    private void checkPreferences(ICore<RunDefinition> iCore, String string) throws CoreException, BackingStoreException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            Set<String> set = RcpPreferenceProvider.validatePreferences(iCore, fileInputStream);
            if (!set.isEmpty()) {
                this.mLogger.warn((Object)"Preference file contains the following unknown settings:");
                for (String string2 : set) {
                    this.mLogger.warn((Object)("  * " + string2));
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void loadPreferencesFromFile(ICore<RunDefinition> iCore, String string, boolean bl) {
        Consumer<Object> consumer;
        Consumer<Object> consumer2 = consumer = bl ? object -> {} : arg_0 -> ((ILogger)this.mLogger).info(arg_0);
        if (string != null && !string.isEmpty()) {
            this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
            consumer.accept("Loading settings from " + string);
            if (this.mLogger.isDebugEnabled()) {
                consumer.accept("Preferences different from defaults before loading file:");
                this.logPreferencesDifferentFromDefaults(iCore);
            }
            try {
                try {
                    IStatus iStatus;
                    this.checkPreferences(iCore, string);
                    Throwable throwable = null;
                    Object var8_7 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(string);){
                        iStatus = RcpPreferenceProvider.importPreferences(fileInputStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        } else {
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    if (!iStatus.isOK()) {
                        this.mLogger.warn((Object)("Failed to load preferences. Status is: " + String.valueOf(iStatus)));
                    } else {
                        this.mLogger.debug((Object)"Loading preferences was successful");
                    }
                    consumer.accept("Preferences different from defaults after loading the file:");
                    if (bl) return;
                    this.logPreferencesDifferentFromDefaults(iCore);
                    return;
                }
                catch (IOException | CoreException | BackingStoreException throwable) {
                    this.mLogger.error((Object)("Could not load preferences: " + throwable.getMessage()));
                    this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
                }
                return;
            }
            finally {
                this.mLogger.debug((Object)"--------------------------------------------------------------------------------");
            }
        }
        this.mLogger.warn((Object)"Loading settings from empty filename is not possible");
    }

    private void logPreferencesDifferentFromDefaults(ICore<RunDefinition> iCore) {
        boolean bl = false;
        IUltimatePlugin[] iUltimatePluginArray = iCore.getRegisteredUltimatePlugins();
        int n = iUltimatePluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUltimatePlugin iUltimatePlugin = iUltimatePluginArray[n2];
            String string = iUltimatePlugin.getPluginID();
            String[] stringArray = new RcpPreferenceProvider(string).getDeltaPreferencesStrings();
            if (stringArray != null && stringArray.length > 0) {
                bl = true;
                this.mLogger.info((Object)("Preferences of " + iUltimatePlugin.getPluginName() + " differ from their defaults:"));
                String[] stringArray2 = stringArray;
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string2 = stringArray2[n4];
                    this.mLogger.info((Object)(" * " + string2));
                    ++n4;
                }
            }
            ++n2;
        }
        if (!bl) {
            this.mLogger.info((Object)"All preferences are set to their defaults");
        }
    }

    void savePreferences(ICore<RunDefinition> iCore, String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        this.mLogger.info((Object)("Saving preferences to file " + string));
        try {
            File file = new File(string);
            if (file.isFile() && file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            IUltimatePlugin[] iUltimatePluginArray = iCore.getRegisteredUltimatePlugins();
            int n = iUltimatePluginArray.length;
            int n2 = 0;
            while (n2 < n) {
                IUltimatePlugin iUltimatePlugin = iUltimatePluginArray[n2];
                new RcpPreferenceProvider(iUltimatePlugin.getPluginID()).exportPreferences(fileOutputStream);
                ++n2;
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException | CoreException throwable) {
            this.mLogger.error((Object)SAVING_PREFERENCES_FAILED_WITH_EXCEPTION, throwable);
        }
    }

    void resetPreferences(ICore<RunDefinition> iCore, boolean bl) {
        Consumer<Object> consumer = bl ? object -> {} : arg_0 -> ((ILogger)this.mLogger).info(arg_0);
        consumer.accept("Resetting all preferences to default values...");
        IUltimatePlugin[] iUltimatePluginArray = iCore.getRegisteredUltimatePlugins();
        int n = iUltimatePluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUltimatePlugin iUltimatePlugin = iUltimatePluginArray[n2];
            IPreferenceInitializer iPreferenceInitializer = iUltimatePlugin.getPreferences();
            if (iPreferenceInitializer != null) {
                this.mLogger.debug((Object)("Resetting " + iUltimatePlugin.getPluginName() + " preferences to default values"));
                RcpPreferenceBinder.resetToDefaultPreferences(iUltimatePlugin.getPluginID(), iPreferenceInitializer.getPreferenceItems());
            } else {
                this.mLogger.debug((Object)(iUltimatePlugin.getPluginName() + " provides no preferences, ignoring..."));
            }
            ++n2;
        }
    }

    private void logDefaultPreferences(String string, String string2) {
        if (!this.mLogger.isDebugEnabled()) {
            return;
        }
        RcpPreferenceProvider rcpPreferenceProvider = new RcpPreferenceProvider(string);
        try {
            IEclipsePreferences iEclipsePreferences = rcpPreferenceProvider.getDefaultEclipsePreferences();
            String string3 = "[" + string2 + " (Current)] Preference \"";
            String[] stringArray = iEclipsePreferences.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string4 = stringArray[n2];
                this.mLogger.debug((Object)(string3 + string4 + "\" = " + rcpPreferenceProvider.getString(string4, "NOT DEFINED")));
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            this.mLogger.fatal((Object)("An exception occurred during printing of default preferences for plugin " + string2), (Throwable)backingStoreException);
        }
    }

    private void attachLogPreferenceChangeListenerToPlugin(String string, String string2) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Attaching preference change listener for plugin " + string2));
        }
        LogPreferenceChangeListener logPreferenceChangeListener = this.retrieveListener(string, string2, "Instance");
        LogPreferenceChangeListener logPreferenceChangeListener2 = this.retrieveListener(string, string2, "Configuration");
        LogPreferenceChangeListener logPreferenceChangeListener3 = this.retrieveListener(string, string2, "Default");
        InstanceScope.INSTANCE.getNode(string).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)logPreferenceChangeListener);
        InstanceScope.INSTANCE.getNode(string).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)logPreferenceChangeListener);
        ConfigurationScope.INSTANCE.getNode(string).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)logPreferenceChangeListener2);
        ConfigurationScope.INSTANCE.getNode(string).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)logPreferenceChangeListener2);
        DefaultScope.INSTANCE.getNode(string).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)logPreferenceChangeListener3);
        DefaultScope.INSTANCE.getNode(string).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)logPreferenceChangeListener3);
    }

    private LogPreferenceChangeListener retrieveListener(String string, String string2, String string3) {
        String string4 = string + string3;
        if (this.mActivePreferenceListener.containsKey(string4)) {
            return this.mActivePreferenceListener.get(string4);
        }
        LogPreferenceChangeListener logPreferenceChangeListener = new LogPreferenceChangeListener(string3, string, string2);
        this.mActivePreferenceListener.put(string4, logPreferenceChangeListener);
        return logPreferenceChangeListener;
    }

    class LogPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final String mScope;
        private final RcpPreferenceProvider mPreferences;
        private final String mPrefix;

        public LogPreferenceChangeListener(String string, String string2, String string3) {
            this.mScope = string;
            this.mPreferences = new RcpPreferenceProvider(string2);
            this.mPrefix = "[" + string3 + " (" + this.mScope + ")] Preference \"";
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
            SettingsManager.this.mLogger.debug((Object)(this.mPrefix + preferenceChangeEvent.getKey() + "\" changed: " + String.valueOf(preferenceChangeEvent.getOldValue()) + " -> " + String.valueOf(preferenceChangeEvent.getNewValue()) + " (actual value in store: " + this.mPreferences.getString(preferenceChangeEvent.getKey()) + ")"));
        }
    }
}

