/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.InstanceCounting;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class MotzkinTransformation
extends InstanceCounting {
    private static final String MOTZKIN_PREFIX = "motzkin_";
    private final Script mScript;
    private final AnalysisType mAnalysisType;
    private boolean mAnnotateTerms;
    private final List<LinearInequality> mInequalities;
    private int mNumberSINeeded = 0;
    private boolean mTransformed = false;
    public String mAnnotation = null;
    private Term[] mCoefficients = null;
    private final Map<String, LinearInequality> mMotzkinCoefficients2LinearInequalities;
    private final IUltimateServiceProvider mServices;

    public MotzkinTransformation(IUltimateServiceProvider iUltimateServiceProvider, Script script, AnalysisType analysisType, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        this.mScript = script;
        this.mInequalities = new ArrayList<LinearInequality>();
        this.mAnnotateTerms = bl;
        this.mAnalysisType = analysisType;
        this.mMotzkinCoefficients2LinearInequalities = new HashMap<String, LinearInequality>();
    }

    public int getNumberSINeeded() {
        return this.mNumberSINeeded;
    }

    public void setNumberSINeeded(int n) {
        assert (n >= 0);
        this.mNumberSINeeded = n;
    }

    public void addInequality(LinearInequality linearInequality) {
        this.mInequalities.add(linearInequality);
    }

    public void addInequalities(Collection<LinearInequality> collection) {
        this.mInequalities.addAll(collection);
    }

    private boolean needsMotzkinCoefficient(LinearInequality linearInequality) {
        if (this.mAnalysisType.isLinear()) {
            return linearInequality.allAffineTermsAreConstant();
        }
        if (this.mAnalysisType == AnalysisType.NONLINEAR) {
            return linearInequality.mMotzkinCoefficient != LinearInequality.PossibleMotzkinCoefficients.ONE;
        }
        assert (false);
        return true;
    }

    private void registerMotzkinCoefficients() {
        if (this.mCoefficients != null) {
            return;
        }
        int n = this.mInequalities.size();
        this.mCoefficients = new Term[n];
        int n2 = 0;
        while (n2 < n) {
            LinearInequality linearInequality = this.mInequalities.get(n2);
            if (this.needsMotzkinCoefficient(linearInequality)) {
                String string = MOTZKIN_PREFIX + this.getInstanceNumber() + "_" + n2;
                ApplicationTerm applicationTerm = SmtUtils.buildNewConstant((Script)this.mScript, (String)string, (String)"Real");
                this.mCoefficients[n2] = applicationTerm;
                this.mMotzkinCoefficients2LinearInequalities.put(string, linearInequality);
            } else {
                this.mCoefficients[n2] = this.mScript.decimal(BigDecimal.ONE);
            }
            ++n2;
        }
    }

    public Map<String, LinearInequality> getMotzkinCoefficients2LinearInequalities() {
        return this.mMotzkinCoefficients2LinearInequalities;
    }

    private Term product(AffineTerm affineTerm, Term term) {
        if (affineTerm.isConstant() && affineTerm.getConstant().equals((Object)Rational.ONE)) {
            return term;
        }
        if (!affineTerm.isZero()) {
            return this.mScript.term("*", new Term[]{term, affineTerm.asRealTerm(this.mScript)});
        }
        return null;
    }

    private Term doTransform(Term[] termArray, Collection<Term> collection) {
        Term term4;
        Object object;
        Serializable serializable;
        int n = termArray.length;
        assert (n == this.mInequalities.size());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Term object22 : collection) {
            serializable = new ArrayList();
            int n2 = 0;
            while (n2 < n) {
                object = this.product(this.mInequalities.get(n2).getCoefficient(object22), termArray[n2]);
                if (object != null) {
                    serializable.add(object);
                }
                ++n2;
            }
            term4 = SmtUtils.sum((Script)this.mScript, (Sort)SmtSortUtils.getRealSort((Script)this.mScript), (Term[])serializable.toArray(new Term[serializable.size()]));
            arrayList.add(this.mScript.term("=", new Term[]{term4, this.mScript.decimal("0")}));
        }
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        int n3 = 0;
        while (n3 < n) {
            serializable = this.mInequalities.get(n3);
            term4 = this.product(((LinearInequality)serializable).getConstant(), termArray[n3]);
            if (term4 != null) {
                arrayList2.add(term4);
            }
            ++n3;
        }
        Term term2 = SmtUtils.sum((Script)this.mScript, (Sort)SmtSortUtils.getRealSort((Script)this.mScript), (Term[])arrayList2.toArray(new Term[arrayList2.size()]));
        arrayList.add(this.mScript.term("<=", new Term[]{term2, this.mScript.decimal("0")}));
        ArrayList<Term> arrayList3 = new ArrayList<Term>();
        int n4 = 0;
        while (n4 < n) {
            serializable = this.mInequalities.get(n4);
            term4 = this.product(((LinearInequality)serializable).getConstant(), termArray[n4]);
            if (!((LinearInequality)serializable).isStrict() && term4 != null) {
                arrayList3.add(term4);
            }
            ++n4;
        }
        Term term3 = SmtUtils.sum((Script)this.mScript, (Sort)SmtSortUtils.getRealSort((Script)this.mScript), (Term[])arrayList3.toArray(new Term[arrayList3.size()]));
        serializable = this.mScript.term("<", new Term[]{term3, this.mScript.decimal("0")});
        ArrayList<Term> arrayList4 = new ArrayList<Term>();
        int n5 = 0;
        while (n5 < n) {
            object = this.mInequalities.get(n5);
            if (((LinearInequality)object).isStrict()) {
                arrayList4.add(termArray[n5]);
            }
            ++n5;
        }
        Term term = this.mScript.term(">", new Term[]{SmtUtils.sum((Script)this.mScript, (Sort)SmtSortUtils.getRealSort((Script)this.mScript), (Term[])arrayList4.toArray(new Term[arrayList4.size()])), this.mScript.decimal("0")});
        arrayList.add(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{serializable, term}));
        return SmtUtils.and((Script)this.mScript, (Term[])arrayList.toArray(new Term[arrayList.size()]));
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Term transform(Rational[] var1_1) {
        block22: {
            block19: {
                block20: {
                    block21: {
                        this.mTransformed = true;
                        this.registerMotzkinCoefficients();
                        var2_2 = new LinkedHashSet<Term>();
                        for (Serializable var3_6 : this.mInequalities) {
                            var2_2.addAll(var3_6.getVariables());
                        }
                        var3_6 = new ArrayList<E>();
                        var7_7 /* !! */  = this.mCoefficients;
                        var6_8 = this.mCoefficients.length;
                        var5_10 = 0;
                        while (var5_10 < var6_8) {
                            var4_3 = var7_7 /* !! */ [var5_10];
                            if (var4_3 != null) {
                                var3_6.add(this.mScript.term(">=", new Term[]{var4_3, this.mScript.decimal("0")}));
                            }
                            ++var5_10;
                        }
                        if (!this.mAnalysisType.isLinear()) break block19;
                        var4_4 = 0;
                        var5_11 = new int[this.mCoefficients.length];
                        var6_8 = 0;
                        while (var6_8 < this.mInequalities.size()) {
                            var7_7 /* !! */  = this.mInequalities.get(var6_8);
                            if (!this.needsMotzkinCoefficient((LinearInequality)var7_7 /* !! */ ) && var7_7 /* !! */ .mMotzkinCoefficient != LinearInequality.PossibleMotzkinCoefficients.ONE) {
                                var5_11[var4_4] = var6_8;
                                ++var4_4;
                            }
                            ++var6_8;
                        }
                        if (!MotzkinTransformation.$assertionsDisabled && var4_4 >= 31) {
                            throw new AssertionError((Object)"Too many fixed coefficients!");
                        }
                        var6_9 = new Term[this.mCoefficients.length];
                        System.arraycopy(this.mCoefficients, 0, var6_9, 0, this.mCoefficients.length);
                        if (!this.mAnalysisType.wantsGuesses() || var1_1.length <= 0) break block20;
                        var7_7 /* !! */  = new Term[var1_1.length];
                        var8_13 = 0;
                        while (var8_13 < var1_1.length) {
                            var7_7 /* !! */ [var8_13] = var1_1[var8_13].toTerm(SmtSortUtils.getRealSort((Script)this.mScript));
                            ++var8_13;
                        }
                        var8_14 = new int[var4_4];
                        var9_16 = new ArrayList<Term>();
                        if (var4_4 != 0) ** GOTO lbl64
                        var9_16.add(this.doTransform(var6_9, var2_2));
                        break block21;
lbl-1000:
                        // 1 sources

                        {
                            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                                throw new ToolchainCanceledException(this.getClass(), "approximative transformation where we make " + var1_1.length + " guesses");
                            }
                            var10_18 = 0;
                            while (var10_18 < var4_4) {
                                var6_9[var5_11[var10_18]] = var7_7 /* !! */ [var8_14[var10_18]];
                                ++var10_18;
                            }
                            var9_16.add(this.doTransform(var6_9, var2_2));
                            var10_18 = 0;
                            while (var10_18 < var4_4) {
                                v0 = var10_18;
                                var8_14[v0] = var8_14[v0] + 1;
                                if (var10_18 >= var4_4 - 1 || var8_14[var10_18] < var1_1.length) continue block4;
                                var8_14[var10_18] = 0;
                                ++var10_18;
                            }
lbl64:
                            // 3 sources

                            ** while (var8_14[var4_4 - 1] < var1_1.length)
                        }
                    }
                    var3_6.add(SmtUtils.or((Script)this.mScript, (Term[])var9_16.toArray(new Term[var9_16.size()])));
                    break block22;
                }
                var7_7 /* !! */  = this.mScript.decimal("0");
                var8_15 = this.mScript.decimal("1");
                var9_17 = new ArrayList<Term>();
                var10_19 = 0;
                while (var10_19 < 1 << var4_4) {
                    if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                        throw new ToolchainCanceledException(this.getClass(), "approximative transformation where we fixed " + (1 << var4_4) + " coefficients");
                    }
                    var11_20 = 0;
                    while (var11_20 < var4_4) {
                        var6_9[var5_11[var11_20]] = (var10_19 & 1 << var11_20) == 0 ? var7_7 /* !! */  : var8_15;
                        ++var11_20;
                    }
                    var9_17.add(this.doTransform(var6_9, var2_2));
                    ++var10_19;
                }
                var3_6.add(SmtUtils.or((Script)this.mScript, (Term[])var9_17.toArray(new Term[var9_17.size()])));
                break block22;
            }
            if (this.mAnalysisType == AnalysisType.NONLINEAR) {
                var3_6.add(this.doTransform(this.mCoefficients, var2_2));
                var4_4 = 0;
                while (var4_4 < this.mInequalities.size()) {
                    var5_12 = this.mInequalities.get(var4_4);
                    if (var5_12.mMotzkinCoefficient == LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE) {
                        var3_6.add(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{this.mScript.term("=", new Term[]{this.mCoefficients[var4_4], this.mScript.decimal("0")}), this.mScript.term("=", new Term[]{this.mCoefficients[var4_4], this.mScript.decimal("1")})}));
                    }
                    ++var4_4;
                }
            } else {
                throw new AssertionError((Object)("Illegal enum value " + String.valueOf((Object)this.mAnalysisType)));
            }
        }
        var4_5 = SmtUtils.and((Script)this.mScript, (Term[])var3_6.toArray(new Term[var3_6.size()]));
        if (this.mAnnotateTerms && this.mAnnotation != null) {
            var4_5 = this.mScript.annotate(var4_5, new Annotation[]{new Annotation(":named", (Object)this.mAnnotation.replace(" ", "_"))});
        }
        return var4_5;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MotzkinApplication\n");
        if (this.mAnnotation != null) {
            stringBuilder.append("Annotation: ");
            stringBuilder.append(this.mAnnotation);
            stringBuilder.append("\n");
        }
        stringBuilder.append("Inequalities:");
        for (LinearInequality linearInequality : this.mInequalities) {
            stringBuilder.append("\n    ");
            stringBuilder.append(linearInequality);
        }
        if (this.mTransformed) {
            stringBuilder.append("\nConstraints:\n");
            boolean bl = this.mAnnotateTerms;
            this.mAnnotateTerms = false;
            stringBuilder.append(new SMTPrettyPrinter(this.transform(new Rational[0])));
            this.mAnnotateTerms = bl;
        }
        return stringBuilder.toString();
    }
}

