/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.PathProgram;
import de.uni_freiburg.informatik.ultimate.plugins.sifa.SifaBuilder;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class SifaRunner<L extends IIcfgTransition<?>>
implements IInterpolatingTraceCheck<L> {
    private final SifaStats mStats;
    private final IPredicate[] mInterpolants;
    private final Script.LBool mIsCorrect;
    private final IPredicate mPrecondition;
    private final IPredicate mPostcondition;
    private final boolean mTracecheckFinishedNormally;
    private final TraceCheckReasonUnknown mTraceCheckReasonUnknown;
    private final List<L> mTrace;
    private final IPredicateUnifier mPredicateUnifier;
    private final InterpolantComputationStatus mInterpolantComputationStatus;

    public SifaRunner(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, IIcfg<?> iIcfg, Word<L> word, IPredicateUnifier iPredicateUnifier) {
        Map map;
        this.mTrace = word.asList();
        this.mPredicateUnifier = iPredicateUnifier;
        this.mPrecondition = this.mPredicateUnifier.getTruePredicate();
        Set set = word.asSet();
        PathProgram.PathProgramConstructionResult pathProgramConstructionResult = PathProgram.constructPathProgram((String)"sifa-path-program", iIcfg, (Set)set, Collections.emptySet(), icfgLocation -> true);
        PathProgram pathProgram = pathProgramConstructionResult.getPathProgram();
        List list = TraceCheckUtils.getSequenceOfProgramPoints(word).stream().map(icfgLocation -> (IcfgLocation)pathProgramConstructionResult.getLocationMapping().get(icfgLocation)).collect(Collectors.toList());
        HashSet hashSet = new HashSet(list);
        SifaBuilder.SifaComponents sifaComponents = new SifaBuilder(iUltimateServiceProvider, iLogger).construct((IIcfg)pathProgram, (IProgressAwareTimer)iUltimateServiceProvider.getProgressMonitorService(), hashSet);
        try {
            map = sifaComponents.getIcfgInterpreter().interpret();
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            this.mTracecheckFinishedNormally = false;
            this.mPostcondition = null;
            this.mInterpolants = null;
            this.mStats = null;
            this.mIsCorrect = Script.LBool.UNKNOWN;
            this.mTraceCheckReasonUnknown = new TraceCheckReasonUnknown(TraceCheckReasonUnknown.Reason.ULTIMATE_TIMEOUT, (Exception)((Object)toolchainCanceledException), TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_IGNORE);
            this.mInterpolantComputationStatus = new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.OTHER, (Throwable)toolchainCanceledException);
            return;
        }
        IcfgLocation icfgLocation2 = (IcfgLocation)list.get(list.size() - 1);
        this.mPostcondition = iPredicateUnifier.getOrConstructPredicate(((IPredicate)map.get(icfgLocation2)).getFormula());
        assert (this.mPostcondition != null);
        this.mInterpolants = SifaRunner.generateInterpolants(list, map, iPredicateUnifier);
        assert (TraceCheckUtils.checkInterpolantsInductivityForward(Arrays.asList(this.mInterpolants), (NestedWord)NestedWord.nestedWord(word), (IPredicate)this.mPrecondition, (IPredicate)this.mPostcondition, Collections.emptyMap(), (String)this.getClass().getSimpleName(), (CfgSmtToolkit)iIcfg.getCfgSmtToolkit(), (ILogger)iLogger));
        this.mStats = sifaComponents.getStats();
        if (iPredicateUnifier.getFalsePredicate() == this.mPostcondition) {
            this.mIsCorrect = Script.LBool.UNSAT;
            this.mTraceCheckReasonUnknown = null;
            this.mInterpolantComputationStatus = new InterpolantComputationStatus();
        } else {
            this.mIsCorrect = Script.LBool.UNKNOWN;
            this.mTraceCheckReasonUnknown = new TraceCheckReasonUnknown(TraceCheckReasonUnknown.Reason.SOLVER_RESPONSE_OTHER, null, TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_IGNORE);
            this.mInterpolantComputationStatus = new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.ALGORITHM_FAILED, null);
            iLogger.info("Sifa could not show that error location is unreachable, found '%s' at error location", new Object[]{this.mPostcondition});
        }
        this.mTracecheckFinishedNormally = true;
    }

    private static IPredicate[] generateInterpolants(List<? extends IcfgLocation> list, Map<IcfgLocation, IPredicate> map, IPredicateUnifier iPredicateUnifier) {
        int n = list.size();
        IPredicate[] iPredicateArray = new IPredicate[n - 2];
        int n2 = 0;
        int n3 = 0;
        for (IcfgLocation icfgLocation : list) {
            IPredicate iPredicate = map.get(icfgLocation);
            assert (iPredicate != null);
            if (n2 != 0 && n2 != n - 1) {
                iPredicateArray[n3] = iPredicateUnifier.getOrConstructPredicate(iPredicate.getFormula());
                ++n3;
            }
            ++n2;
        }
        return iPredicateArray;
    }

    public Script.LBool isCorrect() {
        return this.mIsCorrect;
    }

    public IPredicate getPrecondition() {
        return this.mPrecondition;
    }

    public IPredicate getPostcondition() {
        return this.mPostcondition;
    }

    public Map<Integer, IPredicate> getPendingContexts() {
        throw new UnsupportedOperationException();
    }

    public boolean providesRcfgProgramExecution() {
        return false;
    }

    public IProgramExecution<L, Term> getRcfgProgramExecution() {
        throw new UnsupportedOperationException();
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStats;
    }

    public TraceCheckReasonUnknown getTraceCheckReasonUnknown() {
        return this.mTraceCheckReasonUnknown;
    }

    public boolean wasTracecheckFinishedNormally() {
        return this.mTracecheckFinishedNormally;
    }

    public List<L> getTrace() {
        return this.mTrace;
    }

    public IPredicate[] getInterpolants() {
        return this.mInterpolants;
    }

    public IPredicateUnifier getPredicateUnifier() {
        return this.mPredicateUnifier;
    }

    public boolean isPerfectSequence() {
        return this.isCorrect() == Script.LBool.UNSAT;
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        return this.mInterpolantComputationStatus;
    }
}

