/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class FormulaUnLet
extends TermTransformer {
    private final ScopedHashMap<TermVariable, Term> mLetMap = new ScopedHashMap(false);
    private final UnletType mType;
    private final ArrayList<TermVariable[]> mMatchVars = new ArrayList();

    public FormulaUnLet() {
        this(UnletType.SMTLIB);
    }

    public FormulaUnLet(UnletType unletType) {
        this.mType = unletType;
    }

    public void addSubstitutions(Map<TermVariable, Term> map) {
        this.mLetMap.putAll(map);
    }

    public Term unlet(Term term) {
        return this.transform(term);
    }

    private boolean isRenamedVar(String string) {
        return string.charAt(0) == '.' && string.charAt(1) >= '1' && string.charAt(1) <= '9';
    }

    private void noteUsage(Map<String, Integer> map, TermVariable termVariable) {
        Integer n;
        String string = termVariable.getName();
        int n2 = 0;
        if (this.isRenamedVar(string)) {
            int n3 = string.indexOf(46, 2);
            n2 = Integer.valueOf(string.substring(1, n3));
            string = string.substring(n3 + 1);
        }
        if ((n = map.put(string, n2)) != null && n > n2) {
            map.put(string, n);
        }
    }

    private String boundedRename(Map<String, Integer> map, String string) {
        Integer n;
        if (this.isRenamedVar(string)) {
            string = string.substring(string.indexOf(46, 2) + 1);
        }
        if ((n = map.get(string)) == null) {
            return string;
        }
        return "." + (n + 1) + "." + string;
    }

    public void startVarScope(Term term, TermVariable[] termVariableArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        hashSet.addAll(Arrays.asList(term.getFreeVars()));
        Object object = termVariableArray;
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = object[n2];
            hashSet.remove(termVariable);
            ++n2;
        }
        for (TermVariable termVariable : hashSet) {
            Term term2 = (Term)this.mLetMap.get((Object)termVariable);
            if (term2 == null) {
                this.noteUsage(hashMap, termVariable);
                continue;
            }
            TermVariable[] termVariableArray2 = term2.getFreeVars();
            int n3 = termVariableArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                object = termVariableArray2[n4];
                this.noteUsage(hashMap, (TermVariable)object);
                ++n4;
            }
        }
        this.mLetMap.beginScope();
        int n5 = 0;
        while (n5 < termVariableArray.length) {
            String string = termVariableArray[n5].getName();
            String string2 = this.boundedRename(hashMap, string);
            if (string2.equals(string)) {
                if (this.mLetMap.containsKey((Object)termVariableArray[n5])) {
                    this.mLetMap.remove((Object)termVariableArray[n5]);
                }
            } else {
                this.mLetMap.put((Object)termVariableArray[n5], (Object)termVariableArray[n5].getTheory().createTermVariable(string2, termVariableArray[n5].getSort()));
            }
            ++n5;
        }
    }

    public TermVariable[] endVarScope(TermVariable[] termVariableArray) {
        TermVariable[] termVariableArray2 = termVariableArray;
        int n = 0;
        while (n < termVariableArray.length) {
            Term term = (Term)this.mLetMap.get((Object)termVariableArray[n]);
            if (term != null) {
                if (termVariableArray == termVariableArray2) {
                    termVariableArray2 = (TermVariable[])termVariableArray.clone();
                }
                termVariableArray2[n] = (TermVariable)term;
            }
            ++n;
        }
        this.mLetMap.endScope();
        return termVariableArray2;
    }

    @Override
    public void convert(Term term) {
        if (term instanceof TermVariable) {
            Term term2 = (Term)this.mLetMap.get((Object)term);
            if (term2 == null) {
                this.setResult(term);
            } else if (this.mType.mIsLazy) {
                this.pushTerm(term2);
            } else {
                this.setResult(term2);
            }
        } else if (this.mType.mIsLazy && term instanceof LetTerm) {
            LetTerm letTerm = (LetTerm)term;
            this.preConvertLet(letTerm, letTerm.getValues());
        } else if (term instanceof LambdaTerm) {
            LambdaTerm lambdaTerm = (LambdaTerm)term;
            this.startVarScope(lambdaTerm.getSubterm(), lambdaTerm.getVariables());
            super.convert(term);
        } else if (term instanceof QuantifiedFormula) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
            this.startVarScope(quantifiedFormula.getSubformula(), quantifiedFormula.getVariables());
            super.convert(term);
        } else if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (this.mType.mExpandDefinitions && applicationTerm.getFunction().getDefinition() != null) {
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                Term term3 = applicationTerm.getTheory().let(functionSymbol.getDefinitionVars(), applicationTerm.getParameters(), functionSymbol.getDefinition());
                this.pushTerm(term3);
                return;
            }
            super.convert(term);
        } else {
            super.convert(term);
        }
    }

    @Override
    public void preConvertLet(LetTerm letTerm, Term[] termArray) {
        this.mLetMap.beginScope();
        TermVariable[] termVariableArray = letTerm.getVariables();
        int n = 0;
        while (n < termVariableArray.length) {
            this.mLetMap.put((Object)termVariableArray[n], (Object)termArray[n]);
            ++n;
        }
        super.preConvertLet(letTerm, termArray);
    }

    @Override
    public void postConvertLet(LetTerm letTerm, Term[] termArray, Term term) {
        this.setResult(term);
        this.mLetMap.endScope();
    }

    @Override
    public void postConvertLambda(LambdaTerm lambdaTerm, Term term) {
        TermVariable[] termVariableArray;
        TermVariable[] termVariableArray2 = lambdaTerm.getVariables();
        if (termVariableArray2 == (termVariableArray = this.endVarScope(termVariableArray2)) && lambdaTerm.getSubterm() == term) {
            this.setResult(lambdaTerm);
        } else {
            Theory theory = lambdaTerm.getTheory();
            this.setResult(theory.lambda(termVariableArray, term));
        }
    }

    @Override
    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        TermVariable[] termVariableArray;
        TermVariable[] termVariableArray2 = quantifiedFormula.getVariables();
        if (termVariableArray2 == (termVariableArray = this.endVarScope(termVariableArray2)) && quantifiedFormula.getSubformula() == term) {
            this.setResult(quantifiedFormula);
        } else {
            Theory theory = quantifiedFormula.getTheory();
            this.setResult(quantifiedFormula.getQuantifier() == 0 ? theory.exists(termVariableArray, term) : theory.forall(termVariableArray, term));
        }
    }

    @Override
    public void preConvertMatchCase(MatchTerm matchTerm, int n) {
        if (n > 0) {
            this.mMatchVars.add(this.endVarScope(matchTerm.getVariables()[n - 1]));
        }
        this.startVarScope(matchTerm.getCases()[n], matchTerm.getVariables()[n]);
        super.preConvertMatchCase(matchTerm, n);
    }

    @Override
    public void postConvertMatch(MatchTerm matchTerm, Term term, Term[] termArray) {
        assert (matchTerm.getCases().length > 0);
        this.mMatchVars.add(this.endVarScope(matchTerm.getVariables()[matchTerm.getVariables().length - 1]));
        TermVariable[][] termVariableArray = matchTerm.getVariables();
        TermVariable[][] termVariableArray2 = null;
        int n = termVariableArray.length - 1;
        while (n >= 0) {
            TermVariable[] termVariableArray3 = this.mMatchVars.remove(this.mMatchVars.size() - 1);
            if (termVariableArray3 != termVariableArray[n]) {
                if (termVariableArray2 == null) {
                    termVariableArray2 = (TermVariable[][])termVariableArray.clone();
                }
                termVariableArray2[n] = termVariableArray3;
            }
            --n;
        }
        if (termVariableArray2 != null) {
            this.setResult(matchTerm.getTheory().match(term, termVariableArray2, termArray, matchTerm.getConstructors()));
        } else {
            super.postConvertMatch(matchTerm, term, termArray);
        }
    }

    public static enum UnletType {
        SMTLIB(false, false),
        LAZY(true, false),
        EXPAND_DEFINITIONS(false, true);

        final boolean mIsLazy;
        final boolean mExpandDefinitions;

        private UnletType(boolean bl, boolean bl2) {
            this.mIsLazy = bl;
            this.mExpandDefinitions = bl2;
        }
    }
}

