/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.SymbolCollector;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SymbolChecker {
    private Map<FunctionSymbol, Integer> mSubtreeOccurrences;
    private final Map<FunctionSymbol, Integer> mAllOccurences;
    private HashSet<FunctionSymbol> mALocal;
    private HashSet<FunctionSymbol> mBLocal;
    private final Set<FunctionSymbol> mGlobals;
    private final SymbolCollector mCollector = new SymbolCollector();

    public SymbolChecker(Set<FunctionSymbol> set, Map<FunctionSymbol, Integer> map) {
        this.mGlobals = set;
        this.mAllOccurences = map;
    }

    public final boolean check(Term term, Map<FunctionSymbol, Integer> map) {
        this.mSubtreeOccurrences = map;
        this.mALocal = new HashSet();
        this.mBLocal = new HashSet();
        this.mCollector.collect(term);
        for (FunctionSymbol functionSymbol : this.mCollector.getSymbols()) {
            if (this.mGlobals.contains(functionSymbol)) continue;
            Integer n = this.mSubtreeOccurrences.get(functionSymbol);
            Integer n2 = this.mAllOccurences.get(functionSymbol);
            if (n2 == null) {
                throw new InternalError("Detected new symbol in interpolant: " + String.valueOf(functionSymbol));
            }
            if (n == null) {
                this.mBLocal.add(functionSymbol);
                continue;
            }
            if (n2 - n > 0) continue;
            this.mALocal.add(functionSymbol);
        }
        this.mSubtreeOccurrences = null;
        return !this.mALocal.isEmpty() || !this.mBLocal.isEmpty();
    }

    public Set<FunctionSymbol> getALocals() {
        return this.mALocal;
    }

    public Set<FunctionSymbol> getBLocals() {
        return this.mBLocal;
    }
}

