/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class Translator {
    HashMap<String, Integer> mNameOfConstraint2Index = new HashMap();
    ArrayList<NamedAtom> mIndex2AtomOfConstraint = new ArrayList();
    int mPushPopLevel = 0;

    public void declareConstraint(NamedAtom namedAtom) throws SMTLIBException {
        String string = this.getName(namedAtom);
        if (this.mNameOfConstraint2Index.containsKey(string)) {
            throw new SMTLIBException("This name already exists.");
        }
        int n = this.mIndex2AtomOfConstraint.size();
        this.mNameOfConstraint2Index.put(string, n);
        this.mIndex2AtomOfConstraint.add(namedAtom);
    }

    public Term translate2Constraint(int n) {
        return this.getTerm(this.mIndex2AtomOfConstraint.get(n));
    }

    public NamedAtom translate2Atom(int n) {
        return this.mIndex2AtomOfConstraint.get(n);
    }

    public Integer translate2Index(Term term) {
        return this.mNameOfConstraint2Index.get(Translator.getName(term));
    }

    public int translate2Index(NamedAtom namedAtom) {
        return this.mNameOfConstraint2Index.get(this.getName(namedAtom));
    }

    public BitSet translateToBitSet(Term[] termArray) {
        BitSet bitSet = new BitSet(this.getNumberOfConstraints());
        int n = 0;
        while (n < termArray.length) {
            Integer n2 = this.translate2Index(termArray[n]);
            if (this.translate2Index(termArray[n]) != null) {
                bitSet.set(n2);
            }
            ++n;
        }
        return bitSet;
    }

    public Term[] translateToTerms(BitSet bitSet) {
        Term[] termArray = new Term[bitSet.cardinality()];
        int n = 0;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            termArray[n] = this.translate2Constraint(n2);
            ++n;
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return termArray;
    }

    public int getNumberOfConstraints() {
        return this.mIndex2AtomOfConstraint.size();
    }

    public ArrayList<NamedAtom> getIndex2AtomOfConstraint() {
        return this.mIndex2AtomOfConstraint;
    }

    private Term getTerm(NamedAtom namedAtom) {
        return namedAtom.getSMTFormula(null);
    }

    private String getName(NamedAtom namedAtom) {
        return Translator.getName(namedAtom.getSMTFormula(null));
    }

    public static String getName(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName();
        }
        if (term instanceof AnnotatedTerm) {
            return Translator.getName(((AnnotatedTerm)term).getAnnotations());
        }
        throw new SMTLIBException("Unknown type of term.");
    }

    private static String getName(Annotation ... annotationArray) throws SMTLIBException {
        String string = null;
        int n = 0;
        while (n < annotationArray.length) {
            if (annotationArray[n].getKey().equals(":named")) {
                string = (String)annotationArray[n].getValue();
            }
            ++n;
        }
        if (string == null) {
            throw new SMTLIBException("No name for the constraint has been found.");
        }
        return string;
    }
}

