/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;

import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import com.github.jhoenicke.javacup.runtime.SymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.FrontEndOptions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Lexer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Parser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SExpression;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.zip.GZIPInputStream;

public class ParseEnvironment {
    final Script mScript;
    private File mCwd = null;
    private Deque<Long> mTiming;
    private final FrontEndOptions mOptions;
    private Lexer mLexer = null;
    private boolean mVersion25 = true;

    public ParseEnvironment(Script script, OptionMap optionMap) {
        this.mScript = script;
        this.mOptions = optionMap.getFrontEndOptions();
        if (!this.mOptions.isFrontEndActive()) {
            throw new IllegalArgumentException("Front End not active!");
        }
    }

    public boolean isSMTLIB25() {
        return this.mVersion25;
    }

    public Script getScript() {
        return this.mScript;
    }

    public void parseScript(String string) throws SMTLIBException {
        File file = this.mCwd;
        InputStreamReader inputStreamReader = null;
        boolean bl = false;
        try {
            if (string.equals("<stdin>")) {
                inputStreamReader = new InputStreamReader(System.in);
            } else {
                File file2 = new File(string);
                if (!file2.isAbsolute()) {
                    file2 = new File(this.mCwd, string);
                }
                this.mCwd = file2.getParentFile();
                try {
                    inputStreamReader = string.endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(new FileInputStream(file2))) : new FileReader(file2);
                    bl = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new SMTLIBException("File not found: " + string, (Throwable)fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new SMTLIBException("Cannot read file: " + string, (Throwable)iOException);
                }
            }
            this.parseStream(inputStreamReader, string);
        }
        catch (Throwable throwable) {
            this.mCwd = file;
            if (bl) {
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        this.mCwd = file;
        if (bl) {
            try {
                ((Reader)inputStreamReader).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void parseStream(Reader reader, String string) throws SMTLIBException {
        SimpleSymbolFactory simpleSymbolFactory = new SimpleSymbolFactory();
        Lexer lexer = this.mLexer;
        this.mLexer = new Lexer(reader);
        this.mLexer.setSymbolFactory(simpleSymbolFactory);
        Parser parser = new Parser(this.mLexer, (SymbolFactory)simpleSymbolFactory);
        parser.setFileName(string);
        parser.setParseEnvironment(this);
        try {
            try {
                parser.parse();
            }
            catch (Exception exception) {
                System.err.println("Unexpected Exception: " + String.valueOf(exception));
                throw new SMTLIBException((Throwable)exception);
            }
        }
        finally {
            this.mLexer = lexer;
        }
    }

    public void include(String string) throws SMTLIBException {
        this.parseScript(string);
    }

    public void printSuccess() {
        if (this.mOptions.isPrintSuccess()) {
            this.printResponse("success");
        }
    }

    public void printError(String string) {
        this.printResponse(new SExpression(new Object[]{"error", new QuotedObject(string, this.mVersion25)}));
        if (!this.mOptions.continueOnError()) {
            this.exitWithStatus(1);
        }
    }

    public void printUnsupported() {
        this.printResponse("unsupported");
        if (!this.mOptions.continueOnError()) {
            this.exitWithStatus(1);
        }
    }

    public void printResponse(Object object) {
        PrintWriter printWriter = this.mOptions.getOutChannel();
        if (object instanceof Term && ProofRules.isProof((Term)object)) {
            Term term = (Term)object;
            if (this.mOptions.isPrintTermsCSE()) {
                term = new FormulaLet().let(term);
            }
            ProofRules.printProof(printWriter, term);
            printWriter.println();
            printWriter.flush();
            return;
        }
        if (!this.mOptions.isPrintTermsCSE()) {
            if (object instanceof Term) {
                new PrintTerm().append((Appendable)printWriter, (Term)object);
                printWriter.println();
                printWriter.flush();
                return;
            }
            if (object instanceof SExpression && ((SExpression)object).getData() instanceof Term[]) {
                new PrintTerm().append((Appendable)printWriter, (Object[])((Term[])((SExpression)object).getData()));
                printWriter.println();
                printWriter.flush();
                return;
            }
        }
        printWriter.println(object);
        printWriter.flush();
    }

    public void exitWithStatus(int n) {
        System.exit(n);
    }

    public void exit() {
        this.mScript.exit();
        this.exitWithStatus(0);
    }

    public void setInfo(String string, Object object) {
        block12: {
            block10: {
                block13: {
                    String string2;
                    block11: {
                        if (!string.equals(":smt-lib-version")) break block10;
                        string2 = String.valueOf(object);
                        if (!"2.5".equals(string2) && !"2.6".equals(string2)) break block11;
                        this.mVersion25 = true;
                        this.mLexer.setVersion25(true);
                        break block12;
                    }
                    if (!"2.0".equals(string2)) break block13;
                    this.mVersion25 = false;
                    this.mLexer.setVersion25(false);
                    break block12;
                }
                throw new SMTLIBException("Unknown SMT-LIB version");
            }
            if (!string.equals(":error-behavior")) break block12;
            switch ((String)object) {
                case "immediate-exit": {
                    this.mScript.setOption(":continue-on-error", (Object)false);
                    break;
                }
                case "continued-execution": {
                    this.mScript.setOption(":continue-on-error", (Object)true);
                    break;
                }
                default: {
                    throw new SMTLIBException("Value should be continued-execution or immediate-exit");
                }
            }
        }
        this.mScript.setInfo(string, object);
    }

    public Object getInfo(String string) {
        if (string.equals(":error-behavior")) {
            return this.mOptions.continueOnError() ? "continued-execution" : "immediate-exit";
        }
        return this.mScript.getInfo(string);
    }

    public void startTiming() {
        if (this.mTiming == null) {
            this.mTiming = new ArrayDeque<Long>();
        }
        this.printResponse("(");
        this.mTiming.push(System.nanoTime());
    }

    public void endTiming() {
        long l = this.mTiming.pop();
        long l2 = System.nanoTime() - l;
        long l3 = l2 / 1000000L;
        this.printResponse(String.format(" :time %d.%03d)", l3 / 1000L, l3 % 1000L));
    }

    public boolean isContinueOnError() {
        return this.mOptions.continueOnError();
    }
}

