/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;

public class CommuhashUtils {
    public static final String[] COMMUTATIVE_OPERATORS = new String[]{"and", "or", "=", "distinct", "+", "*", "bvadd", "bvmul", "bvand", "bvor", "bvxor"};
    public static final Comparator<Term> HASH_BASED_COMPERATOR = (term, term2) -> {
        if (term == term2) {
            return 0;
        }
        if (term.hashCode() == term2.hashCode()) {
            return term.toString().compareTo(term2.toString());
        }
        return Integer.compare(term.hashCode(), term2.hashCode());
    };

    private CommuhashUtils() {
    }

    public static boolean isKnownToBeCommutative(String string) {
        switch (string) {
            case "*": 
            case "+": 
            case "=": 
            case "or": 
            case "and": 
            case "bvor": 
            case "bvadd": 
            case "bvand": 
            case "bvmul": 
            case "bvxor": 
            case "distinct": {
                return true;
            }
        }
        return false;
    }

    public static Term[] sortByHashCode(Term ... termArray) {
        Term[] termArray2 = (Term[])termArray.clone();
        Arrays.sort(termArray2, HASH_BASED_COMPERATOR);
        return termArray2;
    }

    public static Term term(Script script, String string, String[] stringArray, Sort sort, Term ... termArray) {
        if (CommuhashUtils.isKnownToBeCommutative(string)) {
            return script.term(string, stringArray, sort, CommuhashUtils.sortByHashCode(termArray));
        }
        return script.term(string, stringArray, sort, termArray);
    }

    public static boolean isInCommuhashNormalForm(Term term2, String ... stringArray) {
        Predicate<Term> predicate = term -> !CommuhashUtils.rootInCommuhashNormalForm(term, stringArray);
        return !new SubtermPropertyChecker(predicate).isSatisfiedBySomeSubterm(term2);
    }

    private static boolean rootInCommuhashNormalForm(Term term, String ... stringArray) {
        boolean bl;
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            bl = Arrays.asList(stringArray).contains(applicationTerm.getFunction().getName()) ? CommuhashUtils.areParamsSorted(applicationTerm.getParameters()) : true;
        } else {
            bl = true;
        }
        return bl;
    }

    private static boolean areParamsSorted(Term[] termArray) {
        Object[] objectArray = CommuhashUtils.sortByHashCode(termArray);
        return Arrays.equals(termArray, objectArray);
    }
}

