/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.Literal;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XJunction {
    private final Map<Term, Literal.Polarity> mPolarityMap;

    public XJunction(Term[] termArray) throws AtomAndNegationException {
        this.mPolarityMap = new HashMap<Term, Literal.Polarity>(termArray.length);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            this.addTermWithUnknownPolarity(term);
            ++n2;
        }
    }

    public XJunction(XJunction xJunction) {
        this.mPolarityMap = new HashMap<Term, Literal.Polarity>(xJunction.mPolarityMap);
    }

    public XJunction() {
        this.mPolarityMap = new HashMap<Term, Literal.Polarity>();
    }

    public XJunction(Term term, Literal.Polarity polarity) {
        this.mPolarityMap = new HashMap<Term, Literal.Polarity>();
        this.mPolarityMap.put(term, polarity);
    }

    public boolean addTermWithUnknownPolarity(Term term) throws AtomAndNegationException {
        Literal literal = new Literal(term);
        return this.add(literal.getAtom(), literal.getPolarity());
    }

    boolean add(Term term, Literal.Polarity polarity) throws AtomAndNegationException {
        boolean bl = this.containsNegation(term, polarity);
        if (bl) {
            throw new AtomAndNegationException();
        }
        return this.mPolarityMap.put(term, polarity) == null;
    }

    public boolean contains(Term term, Literal.Polarity polarity) {
        return this.mPolarityMap.get(term) == polarity;
    }

    public boolean containsNegation(Term term, Literal.Polarity polarity) {
        Literal.Polarity polarity2 = this.mPolarityMap.get(term);
        if (polarity2 != null) {
            return polarity2 != polarity;
        }
        return false;
    }

    public List<Term> toTermList(Script script) {
        ArrayList<Term> arrayList = new ArrayList<Term>(this.mPolarityMap.size());
        for (Map.Entry<Term, Literal.Polarity> entry : this.mPolarityMap.entrySet()) {
            if (entry.getValue() == Literal.Polarity.POSITIVE) {
                arrayList.add(entry.getKey());
                continue;
            }
            arrayList.add(SmtUtils.not(script, entry.getKey()));
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        XJunction xJunction = (XJunction)object;
        return !(this.mPolarityMap == null ? xJunction.mPolarityMap != null : !this.mPolarityMap.equals(xJunction.mPolarityMap));
    }

    public int hashCode() {
        return this.mPolarityMap.hashCode();
    }

    public Set<Map.Entry<Term, Literal.Polarity>> entrySet() {
        return Collections.unmodifiableSet(this.mPolarityMap.entrySet());
    }

    public int size() {
        return this.mPolarityMap.size();
    }

    public Literal.Polarity getPolarity(Term term) {
        return this.mPolarityMap.get(term);
    }

    public Literal.Polarity remove(Term term) {
        return this.mPolarityMap.remove(term);
    }

    public String toString() {
        return this.mPolarityMap.toString();
    }

    public boolean isSubset(XJunction xJunction) {
        if (xJunction.size() < this.size()) {
            return false;
        }
        return xJunction.mPolarityMap.entrySet().containsAll(this.mPolarityMap.entrySet());
    }

    public static XJunction disjointUnion(XJunction xJunction, XJunction xJunction2) throws AtomAndNegationException {
        XJunction xJunction3 = new XJunction(xJunction);
        for (Map.Entry<Term, Literal.Polarity> entry : xJunction2.entrySet()) {
            boolean bl = xJunction3.add(entry.getKey(), entry.getValue());
            if (bl) continue;
            throw new IllegalArgumentException("inputs were not disjoint");
        }
        return xJunction3;
    }

    public static class AtomAndNegationException
    extends Exception {
        private static final long serialVersionUID = -5506932837927008768L;
    }
}

