/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class TermTransducer<E> {
    private Map<Term, E> mSubtermResult;

    public E transduce(Term term) {
        this.mSubtermResult = new HashMap<Term, E>();
        TermTransducerHelper termTransducerHelper = new TermTransducerHelper();
        termTransducerHelper.transform(term);
        E e = this.mSubtermResult.get(term);
        this.mSubtermResult = null;
        return e;
    }

    protected abstract E transduceImmediately(Term var1);

    protected abstract E transduce(ApplicationTerm var1, List<E> var2);

    private class TermTransducerHelper
    extends TermTransformer {
        private TermTransducerHelper() {
        }

        protected void convert(Term term) {
            Object e = TermTransducer.this.transduceImmediately(term);
            if (e == null) {
                super.convert(term);
            } else {
                this.setResult(term);
                TermTransducer.this.mSubtermResult.put(term, e);
            }
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            List list = Arrays.stream(applicationTerm.getParameters()).map(TermTransducer.this.mSubtermResult::get).collect(Collectors.toList());
            Object t = TermTransducer.this.transduce(applicationTerm, list);
            TermTransducer.this.mSubtermResult.put((Term)applicationTerm, t);
            super.convertApplicationTerm(applicationTerm, termArray);
        }

        public void preConvertLet(LetTerm letTerm, Term[] termArray) {
            super.preConvertLet(letTerm, termArray);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void postConvertLet(LetTerm letTerm, Term[] termArray, Term term) {
            super.postConvertLet(letTerm, termArray, term);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
            super.postConvertQuantifier(quantifiedFormula, term);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void postConvertAnnotation(AnnotatedTerm annotatedTerm, Annotation[] annotationArray, Term term) {
            super.postConvertAnnotation(annotatedTerm, annotationArray, term);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void preConvertMatchCase(MatchTerm matchTerm, int n) {
            super.preConvertMatchCase(matchTerm, n);
            throw new UnsupportedOperationException("not yet implemented");
        }

        public void postConvertMatch(MatchTerm matchTerm, Term term, Term[] termArray) {
            super.postConvertMatch(matchTerm, term, termArray);
            throw new UnsupportedOperationException("not yet implemented");
        }
    }
}

