/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.parser;

import de.uni_freiburg.informatik.ultimate.cdt.parser.MultiparseSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class IncludeSorter {
    private final ILogger mLogger;
    private final MultiparseSymbolTable mSymTab;
    private final Map<String, IASTTranslationUnit> mResolver;
    private final Set<String> mVisited;
    private final Set<String> mOpen;
    private final List<IASTTranslationUnit> mResult;

    public IncludeSorter(ILogger iLogger, Collection<IASTTranslationUnit> collection, MultiparseSymbolTable multiparseSymbolTable) {
        this.mLogger = iLogger;
        this.mSymTab = multiparseSymbolTable;
        this.mResolver = new HashMap<String, IASTTranslationUnit>();
        for (IASTTranslationUnit iASTTranslationUnit : collection) {
            this.mResolver.put(multiparseSymbolTable.normalizeCDTFilename(iASTTranslationUnit.getFilePath()), iASTTranslationUnit);
        }
        this.mVisited = new HashSet<String>();
        this.mOpen = new HashSet<String>();
        this.mResult = new ArrayList<IASTTranslationUnit>();
        this.sort();
    }

    private void sort() {
        for (String string : this.mResolver.keySet()) {
            if (this.mVisited.contains(string)) continue;
            assert (this.mOpen.isEmpty());
            this.traverse(string);
        }
    }

    private void traverse(String string) {
        if (this.mOpen.contains(string)) {
            this.mLogger.warn((Object)("Cycle detected: Second visit in path for " + string));
            this.mLogger.warn((Object)"This might happen because include guards ('#ifndef #define...') or other mechanisms were not handled.");
            return;
        }
        this.mOpen.add(string);
        for (String string2 : this.mSymTab.getIncludesFor(string)) {
            if (this.mVisited.contains(string2)) continue;
            this.traverse(string2);
        }
        this.mVisited.add(string);
        this.mOpen.remove(string);
        this.visit(string);
    }

    private void visit(String string) {
        this.mResult.add(this.mResolver.get(string));
    }

    public List<IASTTranslationUnit> getResult() {
        return this.mResult;
    }
}

