/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.NoSuchElementException;

public class DataType
extends SortSymbol {
    Constructor[] mConstructors;
    Sort[] mSortVariables;

    public DataType(Theory theory, String string, int n) {
        super(theory, string, n, null, 32);
    }

    public void setConstructors(Sort[] sortArray, Constructor[] constructorArray) {
        assert (this.mConstructors == null);
        this.mSortVariables = sortArray;
        this.mConstructors = constructorArray;
        if (sortArray != null) {
            Constructor[] constructorArray2 = constructorArray;
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor constructor = constructorArray2[n2];
                constructor.mNeedsReturnOverload = this.checkReturnOverload(sortArray, constructor.mArgumentSorts);
                ++n2;
            }
        }
    }

    public Sort[] getSortVariables() {
        return this.mSortVariables;
    }

    public Constructor findConstructor(String string) {
        int n = 0;
        while (n < this.mConstructors.length) {
            if (this.mConstructors[n].getName().equals(string)) {
                return this.mConstructors[n];
            }
            ++n;
        }
        return null;
    }

    public Constructor getConstructor(String string) {
        Constructor constructor = this.findConstructor(string);
        if (constructor == null) {
            throw new NoSuchElementException();
        }
        return constructor;
    }

    public Constructor[] getConstructors() {
        return this.mConstructors;
    }

    private boolean checkReturnOverload(Sort[] sortArray, Sort[] sortArray2) {
        BitSet bitSet = new BitSet();
        bitSet.set(0, sortArray.length);
        ArrayDeque<Sort> arrayDeque = new ArrayDeque<Sort>();
        HashSet<Sort> hashSet = new HashSet<Sort>();
        arrayDeque.addAll(Arrays.asList(sortArray2));
        block0: while (!arrayDeque.isEmpty()) {
            Sort sort = (Sort)arrayDeque.removeFirst();
            if (!hashSet.add(sort)) continue;
            if (sort.isSortVariable()) {
                int n = 0;
                while (n < sortArray.length) {
                    if (sort == sortArray[n]) {
                        bitSet.clear(n);
                        continue block0;
                    }
                    ++n;
                }
                continue;
            }
            arrayDeque.addAll(Arrays.asList(sort.getArguments()));
        }
        return !bitSet.isEmpty();
    }

    public static class Constructor {
        private final String mName;
        private final Sort[] mArgumentSorts;
        private final String[] mSelectors;
        private boolean mNeedsReturnOverload;

        public Constructor(String string, String[] stringArray, Sort[] sortArray) {
            this.mName = string;
            this.mSelectors = stringArray;
            this.mArgumentSorts = sortArray;
        }

        public String getName() {
            return this.mName;
        }

        public Sort[] getArgumentSorts() {
            return this.mArgumentSorts;
        }

        public int getSelectorIndex(String string) {
            int n = 0;
            while (n < this.mSelectors.length) {
                if (this.mSelectors[n].equals(string)) {
                    return n;
                }
                ++n;
            }
            throw new NoSuchElementException();
        }

        public String[] getSelectors() {
            return this.mSelectors;
        }

        public boolean needsReturnOverload() {
            return this.mNeedsReturnOverload;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(this.mName);
            if (this.mSelectors.length != 0) {
                int n = 0;
                while (n < this.mSelectors.length) {
                    stringBuilder.append(" ");
                    stringBuilder.append("(");
                    stringBuilder.append(this.mSelectors[n]);
                    stringBuilder.append(" ");
                    stringBuilder.append(this.mArgumentSorts[n]);
                    stringBuilder.append(")");
                    ++n;
                }
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

