/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class MatchTerm
extends Term {
    private final Term mDataTerm;
    private final TermVariable[][] mVariables;
    private final Term[] mCases;
    private final DataType.Constructor[] mConstructors;

    MatchTerm(int n, Term term, TermVariable[][] termVariableArray, Term[] termArray, DataType.Constructor[] constructorArray) {
        super(n);
        this.mDataTerm = term;
        this.mVariables = termVariableArray;
        this.mCases = termArray;
        this.mConstructors = constructorArray;
    }

    @Override
    public Sort getSort() {
        return this.mCases[0].getSort();
    }

    public Term getDataTerm() {
        return this.mDataTerm;
    }

    public DataType.Constructor[] getConstructors() {
        return this.mConstructors;
    }

    public TermVariable[][] getVariables() {
        return this.mVariables;
    }

    public Term[] getCases() {
        return this.mCases;
    }

    public static final int hashMatch(Term term, TermVariable[][] termVariableArray, Term[] termArray) {
        return HashUtils.hashJenkins((int)term.hashCode(), (Object[])termArray);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> arrayDeque) {
        arrayDeque.addLast("))");
        int n = this.mCases.length - 1;
        while (n >= 0) {
            arrayDeque.addLast(")");
            arrayDeque.addLast(this.mCases[n]);
            if (this.mConstructors[n] == null) {
                arrayDeque.addLast(" ");
                arrayDeque.addLast(this.mVariables[n][0]);
            } else if (this.mVariables[n].length > 0) {
                arrayDeque.addLast(") ");
                int n2 = this.mVariables[n].length - 1;
                while (n2 >= 0) {
                    arrayDeque.addLast(this.mVariables[n][n2]);
                    arrayDeque.addLast(" ");
                    --n2;
                }
                arrayDeque.addLast(this.mConstructors[n].getName());
                arrayDeque.addLast("(");
            } else {
                arrayDeque.addLast(" ");
                arrayDeque.addLast(this.mConstructors[n].getName());
            }
            arrayDeque.addLast(n > 0 ? " (" : "(");
            --n;
        }
        arrayDeque.addLast(" (");
        arrayDeque.addLast(this.mDataTerm);
        arrayDeque.addLast("(match ");
    }
}

