/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class VMUtils {
    public static String getVMInfos() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("VM Information is:").append(string);
        stringBuilder.append(" * Name: ").append(runtimeMXBean.getName()).append(string);
        try {
            stringBuilder.append(" * VM name: ").append(runtimeMXBean.getVmName()).append(string);
            stringBuilder.append(" * VM vendor: ").append(runtimeMXBean.getVmVendor()).append(string);
            stringBuilder.append(" * VM version: ").append(runtimeMXBean.getVmVersion()).append(string);
            stringBuilder.append(" * VM arguments: ").append(CoreUtil.join(runtimeMXBean.getInputArguments(), ",")).append(string);
            stringBuilder.append(" * Spec name: ").append(runtimeMXBean.getSpecName()).append(string);
            stringBuilder.append(" * Spec vendor: ").append(runtimeMXBean.getSpecVendor()).append(string);
            stringBuilder.append(" * Spec version: ").append(runtimeMXBean.getSpecVersion()).append(string);
            stringBuilder.append(" * Management spec version: ").append(runtimeMXBean.getManagementSpecVersion()).append(string);
            stringBuilder.append(" * Library : ").append(runtimeMXBean.getLibraryPath()).append(string);
        }
        catch (Error error) {
            stringBuilder.append("Error accessing VM information: ").append(error).append(string);
        }
        return stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length()).toString();
    }

    public static boolean areAssertionsEnabled() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return bl;
    }
}

