/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import java.util.Comparator;
import java.util.Objects;

@FunctionalInterface
public interface IPartialComparator<T> {
    public ComparisonResult compare(T var1, T var2);

    public static <T> IPartialComparator<T> fromNonPartialComparator(Comparator<T> comparator, boolean bl) {
        if (bl) {
            return (object, object2) -> ComparisonResult.fromNonPartialComparison(comparator.compare(object, object2));
        }
        return (object, object2) -> {
            ComparisonResult comparisonResult = ComparisonResult.fromNonPartialComparison(comparator.compare(object, object2));
            if (comparisonResult == ComparisonResult.EQUAL && !Objects.equals(object, object2)) {
                return ComparisonResult.INCOMPARABLE;
            }
            return comparisonResult;
        };
    }

    public static enum ComparisonResult {
        STRICTLY_SMALLER,
        EQUAL,
        STRICTLY_GREATER,
        INCOMPARABLE;


        public ComparisonResult invert() {
            return switch (this) {
                case STRICTLY_SMALLER -> STRICTLY_GREATER;
                case EQUAL -> EQUAL;
                case STRICTLY_GREATER -> STRICTLY_SMALLER;
                case INCOMPARABLE -> INCOMPARABLE;
                default -> throw new MatchException(null, null);
            };
        }

        private static ComparisonResult fromNonPartialComparison(int n) {
            if (n == 0) {
                return EQUAL;
            }
            if (n > 0) {
                return STRICTLY_GREATER;
            }
            return STRICTLY_SMALLER;
        }

        public static ComparisonResult aggregate(ComparisonResult comparisonResult, ComparisonResult comparisonResult2) {
            return switch (comparisonResult) {
                case EQUAL -> comparisonResult2;
                case INCOMPARABLE -> INCOMPARABLE;
                case STRICTLY_SMALLER, STRICTLY_GREATER -> {
                    if (comparisonResult2 == INCOMPARABLE || comparisonResult2 == comparisonResult.invert()) {
                        yield INCOMPARABLE;
                    }
                    yield comparisonResult;
                }
                default -> throw new MatchException(null, null);
            };
        }

        public boolean isLessOrEqual() {
            return this == STRICTLY_SMALLER || this == EQUAL;
        }
    }
}

