/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.TimeMemoryTracker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Benchmark
implements ICsvProviderProvider<Double> {
    private long mMaxMemorySizeBytes;
    private Map<String, TimeMemoryTracker> mWatches;
    private TimeMemoryTracker mGlobalWatch;

    public Benchmark() {
        this.reset();
    }

    public void register(String string) {
        if (!this.mWatches.containsKey(string)) {
            this.mWatches.put(string, new TimeMemoryTracker(string, this.mMaxMemorySizeBytes));
        }
    }

    public void unregister(String string) {
        this.mWatches.remove(string);
    }

    public void start(String string2) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.computeIfAbsent(string2, string -> new TimeMemoryTracker((String)string, this.mMaxMemorySizeBytes));
        timeMemoryTracker.reset();
        timeMemoryTracker.start();
    }

    public void startAll() {
        this.mGlobalWatch.reset();
        this.mGlobalWatch.start();
    }

    public void stop(String string) {
        this.stopInternal(string, System.nanoTime());
    }

    public void stopAll() {
        long l = System.nanoTime();
        for (String string : this.mWatches.keySet()) {
            this.stopInternal(string, l);
        }
    }

    private void stopInternal(String string, long l) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.get(string);
        if (timeMemoryTracker == null) {
            return;
        }
        if (timeMemoryTracker.mStartTime == -1L && this.mGlobalWatch.mStartTime == -1L) {
            return;
        }
        if (timeMemoryTracker.mStartTime == -1L) {
            timeMemoryTracker.mStartTime = this.mGlobalWatch.mStartTime;
            timeMemoryTracker.mStartMemorySizeBytes = this.mGlobalWatch.mStartMemorySizeBytes;
            timeMemoryTracker.mStartMemoryFreeSizeBytes = this.mGlobalWatch.mStartMemoryFreeSizeBytes;
            timeMemoryTracker.mStartPeakMemorySizeBytes = this.mGlobalWatch.mStartPeakMemorySizeBytes;
        }
        timeMemoryTracker.stop(l);
    }

    public void pause(String string) {
        this.stop(string);
    }

    public void unpause(String string) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.get(string);
        if (timeMemoryTracker == null) {
            return;
        }
        timeMemoryTracker.start();
    }

    public void reset() {
        this.mMaxMemorySizeBytes = Runtime.getRuntime().maxMemory();
        this.mGlobalWatch = new TimeMemoryTracker("Global", this.mMaxMemorySizeBytes);
        this.mWatches = new LinkedHashMap<String, TimeMemoryTracker>();
    }

    public void printResult(ILogger iLogger) {
        for (TimeMemoryTracker timeMemoryTracker : this.mWatches.values()) {
            iLogger.info((Object)timeMemoryTracker);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        stringBuilder.append("Benchmark results are:").append(string);
        for (TimeMemoryTracker timeMemoryTracker : this.mWatches.values()) {
            stringBuilder.append(" * ").append(timeMemoryTracker).append(string);
        }
        stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length());
        return stringBuilder.toString();
    }

    public String getReportString(String string) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.get(string);
        if (timeMemoryTracker == null) {
            return "";
        }
        return timeMemoryTracker.toString();
    }

    public double getElapsedTime(String string, TimeUnit timeUnit) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.get(string);
        if (timeMemoryTracker == null) {
            return -1.0;
        }
        return CoreUtil.convertTimeUnit(timeMemoryTracker.mElapsedTimeNs, TimeUnit.NANOSECONDS, timeUnit);
    }

    public long getStartHeapSize(String string) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.get(string);
        if (timeMemoryTracker == null) {
            return -1L;
        }
        return timeMemoryTracker.mStartMemorySizeBytes;
    }

    public long getStopHeapSize(String string) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.get(string);
        if (timeMemoryTracker == null) {
            return -1L;
        }
        return timeMemoryTracker.mStopMemorySizeBytes;
    }

    public long getStartMemoryFreeSize(String string) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.get(string);
        if (timeMemoryTracker == null) {
            return -1L;
        }
        return timeMemoryTracker.mStartMemoryFreeSizeBytes;
    }

    public long getStopMemoryFreeSize(String string) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.get(string);
        if (timeMemoryTracker == null) {
            return -1L;
        }
        return timeMemoryTracker.mStopMemoryFreeSizeBytes;
    }

    public long getPeakMemoryConsumed(String string) {
        TimeMemoryTracker timeMemoryTracker = this.mWatches.get(string);
        if (timeMemoryTracker == null) {
            return -1L;
        }
        return timeMemoryTracker.mPeakMemorySizeBytes - timeMemoryTracker.mStartPeakMemorySizeBytes;
    }

    public long getMaxHeapSize(String string) {
        return this.mMaxMemorySizeBytes;
    }

    public List<String> getTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TimeMemoryTracker timeMemoryTracker : this.mWatches.values()) {
            arrayList.add(timeMemoryTracker.mTitle);
        }
        return arrayList;
    }

    static boolean isHeap(String string) {
        switch (string) {
            case "Perm Gen [shared-ro]": 
            case "Perm Gen [shared-rw]": 
            case "CodeHeap 'non-nmethods'": 
            case "CodeHeap 'profiled nmethods'": 
            case "Code Cache": 
            case "CodeHeap 'non-profiled nmethods'": 
            case "Perm Gen": 
            case "Metaspace": 
            case "PS Perm Gen": 
            case "Compressed Class Space": {
                return false;
            }
            case "Survivor Space": 
            case "Tenured Gen": 
            case "Eden Space": 
            case "G1 Eden Space": 
            case "G1 Old Gen": 
            case "PS Survivor Space": 
            case "PS Eden Space": 
            case "G1 Survivor Space": 
            case "PS Old Gen": {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown memory pool name \"" + string + "\"");
    }

    @Override
    public ICsvProvider<Double> createCsvProvider() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Runtime (ns)");
        arrayList.add("Peak memory consumption (bytes)");
        arrayList.add("Allocated memory start (bytes)");
        arrayList.add("Allocated memory end (bytes)");
        arrayList.add("Free memory start (bytes)");
        arrayList.add("Free memory end (bytes)");
        arrayList.add("Max. memory available (bytes)");
        SimpleCsvProvider<Double> simpleCsvProvider = new SimpleCsvProvider<Double>(arrayList);
        for (TimeMemoryTracker timeMemoryTracker : this.mWatches.values()) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(Double.valueOf(timeMemoryTracker.mElapsedTimeNs));
            arrayList2.add(Double.valueOf(timeMemoryTracker.getPeakMemoryDelta()));
            arrayList2.add(Double.valueOf(timeMemoryTracker.mStartMemorySizeBytes));
            arrayList2.add(Double.valueOf(timeMemoryTracker.mStopMemorySizeBytes));
            arrayList2.add(Double.valueOf(timeMemoryTracker.mStartMemoryFreeSizeBytes));
            arrayList2.add(Double.valueOf(timeMemoryTracker.mStopMemoryFreeSizeBytes));
            arrayList2.add(Double.valueOf(this.mMaxMemorySizeBytes));
            simpleCsvProvider.addRow(timeMemoryTracker.mTitle, arrayList2);
        }
        return simpleCsvProvider;
    }
}

