/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.mcr;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.TopologicalSorter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class McrUtils {
    private McrUtils() {
    }

    public static Set<TermVariable> getTermVariables(Collection<IProgramVar> collection) {
        return collection.stream().map(IProgramVar::getTermVariable).collect(Collectors.toSet());
    }

    public static Term abstractVariables(Term term, Set<TermVariable> set, int n, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, SmtUtils.SimplificationTechnique simplificationTechnique) {
        Term term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (SmtUtils.SimplificationTechnique)simplificationTechnique, (Term)term);
        Term term3 = switch (n) {
            case 0 -> SmtUtils.toDnf((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term2);
            case 1 -> SmtUtils.toCnf((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term2);
            default -> throw new AssertionError((Object)"Invalid Quantifier!");
        };
        List list = Arrays.stream(term3.getFreeVars()).filter(termVariable -> !set.contains(termVariable)).collect(Collectors.toList());
        Term term4 = SmtUtils.quantifier((Script)managedScript.getScript(), (int)n, list, (Term)term3);
        return PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (SmtUtils.SimplificationTechnique)simplificationTechnique, (Term)term4);
    }

    public static <STATE> List<STATE> reversedTopologicalOrdering(INestedWordAutomaton<?, STATE> iNestedWordAutomaton, Predicate<STATE> predicate) {
        HashMap hashMap = new HashMap();
        for (Object e : iNestedWordAutomaton.getStates()) {
            if (predicate.test(e)) continue;
            HashSet<Object> hashSet = new HashSet<Object>();
            for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors(e)) {
                Object object = outgoingInternalTransition.getSucc();
                if (predicate.test(object)) continue;
                hashSet.add(object);
            }
            hashMap.put(e, hashSet);
        }
        return (List)new TopologicalSorter(hashMap::get).reversedTopologicalOrdering(hashMap.keySet()).get();
    }
}

