/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopForBehavior;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class LoopAnnot
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(LoopAnnot.class);
    LoopForBehavior[] loopBehavior;
    LoopStatement[] loopStmt;

    public LoopAnnot(LoopForBehavior[] loopForBehaviorArray, LoopStatement[] loopStatementArray) {
        this.loopBehavior = loopForBehaviorArray;
        this.loopStmt = loopStatementArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid LoopAnnot: " + String.valueOf(this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LoopAnnot").append('[');
        if (this.loopBehavior == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.loopBehavior.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.loopBehavior[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.loopStmt == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.loopStmt.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.loopStmt[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public LoopForBehavior[] getLoopBehavior() {
        return this.loopBehavior;
    }

    public LoopStatement[] getLoopStmt() {
        return this.loopStmt;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        if (this.loopBehavior != null) {
            list.addAll(Arrays.asList(this.loopBehavior));
        }
        if (this.loopStmt != null) {
            list.addAll(Arrays.asList(this.loopStmt));
        }
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (aCSLVisitor.visit(this)) {
            ACSLNode aCSLNode;
            int n;
            int n2;
            ACSLNode[] aCSLNodeArray;
            if (this.loopBehavior != null) {
                aCSLNodeArray = this.loopBehavior;
                n2 = this.loopBehavior.length;
                n = 0;
                while (n < n2) {
                    aCSLNode = aCSLNodeArray[n];
                    ((LoopForBehavior)aCSLNode).accept(aCSLVisitor);
                    ++n;
                }
            }
            if (this.loopStmt != null) {
                aCSLNodeArray = this.loopStmt;
                n2 = this.loopStmt.length;
                n = 0;
                while (n < n2) {
                    aCSLNode = aCSLNodeArray[n];
                    ((LoopStatement)aCSLNode).accept(aCSLVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public LoopAnnot accept(ACSLTransformer aCSLTransformer) {
        Object object;
        Object object2;
        int n;
        LoopAnnot loopAnnot = aCSLTransformer.transform(this);
        if (loopAnnot != this) {
            return loopAnnot;
        }
        boolean bl = false;
        ArrayList<LoopStatement[]> arrayList = new ArrayList<LoopStatement[]>();
        if (this.loopBehavior != null) {
            LoopForBehavior[] loopForBehaviorArray = this.loopBehavior;
            n = this.loopBehavior.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = loopForBehaviorArray[n2];
                object = ((LoopForBehavior)object2).accept(aCSLTransformer);
                bl = bl || object != object2;
                arrayList.add((LoopStatement[])object);
                ++n2;
            }
        }
        object2 = new ArrayList();
        if (this.loopStmt != null) {
            object = this.loopStmt;
            int n3 = this.loopStmt.length;
            n = 0;
            while (n < n3) {
                LoopStatement loopStatement = object[n];
                LoopStatement loopStatement2 = loopStatement.accept(aCSLTransformer);
                bl = bl || loopStatement2 != loopStatement;
                ((ArrayList)object2).add(loopStatement2);
                ++n;
            }
        }
        if (bl) {
            return new LoopAnnot(arrayList.toArray(new LoopForBehavior[0]), ((ArrayList)object2).toArray(new LoopStatement[0]));
        }
        return this;
    }
}

