/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementSvwStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;

public class BuchiComplementAutomatonSVW<LETTER, STATE>
implements INestedWordAutomaton<LETTER, STATE> {
    private static final String IS_NOT_YET_KNOWN = " is not (yet) known.";
    private static final String STATE_STRING = "State ";
    private static final String UNSUPPORTED_OPERATION_MESSAGE = "Transform to NestedWordAutomaton to get full support.";
    protected final IBuchiComplementSvwStateFactory<STATE> mStateFactory;
    protected final STATE mEmptyStackState;
    protected final AutomataLibraryServices mServices;
    private final TransitionMonoidAutomaton mTma;
    private final VpAlphabet<LETTER> mVpAlphabet;
    private SizeInfoContainer mSizeInfo;
    private boolean mBuildCompleted;
    private final STATE mInitialState;
    private final Set<STATE> mInitialStateSet = new HashSet<STATE>(1);
    private final Set<STATE> mFinalStateSet = null;
    private final Map<STATE, Map<LETTER, Set<STATE>>> mTransitionsOut = new HashMap<STATE, Map<LETTER, Set<STATE>>>();
    private final Map<STATE, Map<LETTER, Set<STATE>>> mTransitionsIn = new HashMap<STATE, Map<LETTER, Set<STATE>>>();
    private final Map<STATE, MetaState> mMapState2Ms = new HashMap<STATE, MetaState>();
    private final ILogger mLogger;

    public <FACTORY extends IBuchiComplementSvwStateFactory<STATE> & IEmptyStackStateFactory<STATE>> BuchiComplementAutomatonSVW(AutomataLibraryServices automataLibraryServices, FACTORY FACTORY, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mTma = new TransitionMonoidAutomaton(iNestedWordAutomaton);
        this.mVpAlphabet = iNestedWordAutomaton.getVpAlphabet();
        if (!NestedWordAutomataUtils.isFiniteAutomaton(iNestedWordAutomaton)) {
            throw new IllegalArgumentException("only applicable to Buchi automata (not BuchiNWA)");
        }
        this.mStateFactory = FACTORY;
        this.mEmptyStackState = FACTORY.createEmptyStackState();
        MetaState metaState = this.getMetaState1(this.mTma.getInitialState(), this.mTma.getInitialTma());
        this.mInitialState = metaState.getOutputState();
        this.mInitialStateSet.add(this.mInitialState);
    }

    public INestedWordAutomaton<LETTER, STATE> toNestedWordAutomaton() throws AutomataOperationCanceledException {
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, this.mVpAlphabet, this.mStateFactory);
        int n = this.getSizeInfo().mTotalSize;
        HashSet<STATE> hashSet = new HashSet<STATE>(n);
        LinkedList<STATE> linkedList = new LinkedList<STATE>();
        hashSet.add(this.mInitialState);
        linkedList.add(this.mInitialState);
        nestedWordAutomaton.addState(true, false, this.mInitialState);
        while (!linkedList.isEmpty()) {
            Object e = linkedList.remove();
            for (Object LETTER : this.getAlphabet()) {
                Collection collection = this.succInternal(e, LETTER);
                for (Object e2 : collection) {
                    this.addIfNotContained1(nestedWordAutomaton, hashSet, linkedList, e2);
                    nestedWordAutomaton.addInternalTransition(e, LETTER, e2);
                }
            }
            if (this.mServices.getProgressAwareTimer().continueProcessing()) continue;
            throw new AutomataOperationCanceledException(this.getClass());
        }
        this.mBuildCompleted = true;
        return nestedWordAutomaton;
    }

    @Override
    public int size() {
        return this.getSizeInfo().mTotalSize;
    }

    @Override
    public String sizeInformation() {
        SizeInfoContainer sizeInfoContainer = this.getSizeInfo();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("has ").append(sizeInfoContainer.mTotalSize).append(" states. Size of a transition monoid automaton (TMA): ").append(sizeInfoContainer.mTmaSize).append(". Number of reachable TMAs: ").append(sizeInfoContainer.mNumOfReachableTmas).append('.');
        return stringBuilder.toString();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public Set<STATE> getStates() {
        if (this.mBuildCompleted) {
            return this.mTransitionsOut.keySet();
        }
        int n = this.getSizeInfo().mTotalSize;
        HashSet<STATE> hashSet = new HashSet<STATE>(n);
        LinkedList<STATE> linkedList = new LinkedList<STATE>();
        hashSet.add(this.mInitialState);
        linkedList.add(this.mInitialState);
        while (!linkedList.isEmpty()) {
            Object e = linkedList.remove();
            for (Object LETTER : this.getAlphabet()) {
                Collection collection = this.succInternal(e, LETTER);
                for (Object e2 : collection) {
                    this.addIfNotContained2(hashSet, linkedList, e2);
                }
            }
        }
        this.mBuildCompleted = true;
        return this.mTransitionsOut.keySet();
    }

    @Override
    public Set<STATE> getInitialStates() {
        return this.mInitialStateSet;
    }

    @Override
    public Collection<STATE> getFinalStates() {
        if (this.mFinalStateSet == null) {
            Set<Integer> set = this.mTma.statesWithLeftRejectingPartners();
            for (Integer n : set) {
                MetaState metaState = this.getMetaState1(this.mTma.getInitialState(), n);
                this.mFinalStateSet.add(metaState.getOutputState());
            }
        }
        return this.mFinalStateSet;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        if (!this.knows(STATE)) {
            throw new IllegalArgumentException(STATE_STRING + String.valueOf(STATE) + IS_NOT_YET_KNOWN);
        }
        return STATE.equals(this.mInitialState);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        MetaState metaState = this.getMetaState2(STATE);
        if (metaState == null) {
            throw new IllegalArgumentException(STATE_STRING + String.valueOf(STATE) + IS_NOT_YET_KNOWN);
        }
        return metaState.getStateNb().equals(this.mTma.getInitialState()) && !metaState.getTmaNb().equals(this.mTma.getInitialTma());
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mEmptyStackState;
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        if (!this.knows(STATE)) {
            throw new IllegalArgumentException(STATE_STRING + String.valueOf(STATE) + IS_NOT_YET_KNOWN);
        }
        return this.getAlphabet();
    }

    @Override
    public Set<LETTER> lettersInternalIncoming(STATE STATE) {
        if (!this.knows(STATE)) {
            throw new IllegalArgumentException(STATE_STRING + String.valueOf(STATE) + IS_NOT_YET_KNOWN);
        }
        HashSet hashSet = new HashSet();
        for (Object LETTER : this.getAlphabet()) {
            Collection<STATE> collection = this.predInternal(STATE, LETTER);
            if (collection.isEmpty()) continue;
            hashSet.add(LETTER);
        }
        return hashSet;
    }

    private Collection<STATE> succInternal(STATE STATE, LETTER LETTER) {
        Set<STATE> set;
        Map<LETTER, Set<STATE>> map = this.mTransitionsOut.get(STATE);
        if (map == null) {
            map = new HashMap<LETTER, Set<STATE>>();
            this.mTransitionsOut.put(STATE, map);
        }
        if ((set = map.get(LETTER)) == null) {
            if (!this.getAlphabet().contains(LETTER)) {
                throw new IllegalArgumentException("Letter " + String.valueOf(LETTER) + " is not in the alphabet.");
            }
            MetaState metaState = this.getMetaState2(STATE);
            if (metaState == null) {
                throw new IllegalArgumentException(STATE_STRING + String.valueOf(STATE) + IS_NOT_YET_KNOWN);
            }
            set = new HashSet<STATE>();
            map.put(LETTER, set);
            HashSet<MetaState> hashSet = new HashSet<MetaState>();
            Integer n = this.mTma.successor(metaState.getStateNb(), LETTER);
            hashSet.add(this.getMetaState1(n, metaState.getTmaNb()));
            if (metaState.getTmaNb().equals(this.mTma.getInitialTma())) {
                for (Integer object : this.mTma.rightRejectingPartners(n)) {
                    hashSet.add(this.getMetaState1(this.mTma.getInitialState(), object));
                }
            } else if (n.equals(metaState.getTmaNb())) {
                hashSet.add(this.getMetaState1(this.mTma.getInitialState(), metaState.getTmaNb()));
            }
            for (MetaState metaState2 : hashSet) {
                set.add(metaState2.getOutputState());
            }
        }
        return set;
    }

    private Collection<STATE> predInternal(STATE STATE, LETTER LETTER) {
        Set<STATE> set;
        Map<LETTER, Set<STATE>> map = this.mTransitionsIn.get(STATE);
        if (map == null) {
            map = new HashMap<LETTER, Set<STATE>>();
            this.mTransitionsIn.put(STATE, map);
        }
        if ((set = map.get(LETTER)) != null) {
            return set;
        }
        if (!this.getAlphabet().contains(LETTER)) {
            throw new IllegalArgumentException("Letter " + String.valueOf(LETTER) + " is not in the alphabet.");
        }
        MetaState metaState = this.getMetaState2(STATE);
        if (metaState == null) {
            throw new IllegalArgumentException(STATE_STRING + String.valueOf(STATE) + IS_NOT_YET_KNOWN);
        }
        set = new HashSet<STATE>();
        map.put(LETTER, set);
        Set<Integer> set2 = this.mTma.predecessors(metaState.getStateNb(), LETTER);
        if (set2 == null) {
            throw new AssertionError((Object)"20160830 Matthias: This NPE is a known and old bug. I will fix it only when I revise the Ramsey-based complementation.");
        }
        HashSet<MetaState> hashSet = new HashSet<MetaState>();
        for (Integer n : set2) {
            hashSet.add(this.getMetaState1(n, metaState.getTmaNb()));
        }
        if (metaState.getStateNb().equals(this.mTma.getInitialState()) && !metaState.getTmaNb().equals(this.mTma.getInitialTma())) {
            Set<Integer> set3 = this.mTma.leftRejectingPartners(metaState.getTmaNb());
            for (Integer n : set3) {
                Set<Integer> set4 = this.mTma.predecessors(n, LETTER);
                Iterator iterator = set4.iterator();
                while (iterator.hasNext()) {
                    Integer n2 = (Integer)iterator.next();
                    hashSet.add(this.getMetaState1(n2, this.mTma.mInitialTma));
                }
            }
            Set<Integer> set5 = this.mTma.predecessors(metaState.getTmaNb(), LETTER);
            for (Integer n : set5) {
                hashSet.add(this.getMetaState1(n, metaState.getTmaNb()));
            }
        }
        for (MetaState metaState2 : hashSet) {
            set.add(metaState2.getOutputState());
        }
        return set;
    }

    private static boolean finalIsTrap() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    private static boolean isDeterministic() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    private static boolean isTotal() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        return Collections.emptySet();
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        return Collections.emptySet();
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE) {
        return Collections.emptySet();
    }

    @Override
    public Set<LETTER> lettersCallIncoming(STATE STATE) {
        return Collections.emptySet();
    }

    @Override
    public Set<LETTER> lettersReturnIncoming(STATE STATE) {
        return Collections.emptySet();
    }

    @Override
    public Set<LETTER> lettersSummary(STATE STATE) {
        return Collections.emptySet();
    }

    @Override
    public Collection<STATE> hierarchicalPredecessorsOutgoing(STATE STATE, LETTER LETTER) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(STATE STATE, LETTER LETTER) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<SummaryReturnTransition<LETTER, STATE>> summarySuccessors(STATE STATE) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE, LETTER LETTER) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(STATE STATE, LETTER LETTER) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(STATE STATE) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, STATE>>();
        for (STATE STATE2 : this.succInternal(STATE, LETTER)) {
            arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(LETTER, STATE2));
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, STATE>>();
        for (LETTER LETTER : this.lettersInternal(STATE)) {
            for (STATE STATE2 : this.succInternal(STATE, LETTER)) {
                arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(LETTER, STATE2));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        return Collections.emptyList();
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        return Collections.emptyList();
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE, LETTER LETTER) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE STATE) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        return Collections.emptyList();
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE) {
        return Collections.emptyList();
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        return Collections.emptyList();
    }

    private SizeInfoContainer getSizeInfo() {
        if (this.mSizeInfo == null) {
            int n = this.mTma.size();
            int n2 = this.mTma.statesWithLeftRejectingPartners().size() + 1;
            int n3 = n2 * n;
            this.mSizeInfo = new SizeInfoContainer(n, n2, n3);
        }
        return this.mSizeInfo;
    }

    private boolean knows(STATE STATE) {
        return this.mMapState2Ms.containsKey(STATE);
    }

    private MetaState getMetaState1(Integer n, Integer n2) {
        MetaState metaState = new MetaState(n, n2);
        if (this.mMapState2Ms.containsKey(metaState.getOutputState())) {
            metaState = this.mMapState2Ms.get(metaState.getOutputState());
        } else {
            this.mMapState2Ms.put(metaState.getOutputState(), metaState);
        }
        return metaState;
    }

    private MetaState getMetaState2(STATE STATE) {
        return this.mMapState2Ms.get(STATE);
    }

    private void addIfNotContained1(NestedWordAutomaton<LETTER, STATE> nestedWordAutomaton, Set<STATE> set, Queue<STATE> queue, STATE STATE) {
        if (!set.contains(STATE)) {
            set.add(STATE);
            queue.add(STATE);
            if (this.isFinal(STATE)) {
                nestedWordAutomaton.addState(false, true, STATE);
            } else {
                nestedWordAutomaton.addState(false, false, STATE);
            }
        }
    }

    private void addIfNotContained2(Set<STATE> set, Queue<STATE> queue, STATE STATE) {
        if (!set.contains(STATE)) {
            set.add(STATE);
            queue.add(STATE);
        }
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mVpAlphabet;
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        return null;
    }

    private final class MetaState {
        private final Integer mStateNb;
        private final Integer mTmaNb;
        private final STATE mOutputState;

        public MetaState(Integer n, Integer n2) {
            this.mStateNb = n;
            this.mTmaNb = n2;
            this.mOutputState = BuchiComplementAutomatonSVW.this.mStateFactory.buchiComplementSvw(n, n2);
        }

        Integer getStateNb() {
            return this.mStateNb;
        }

        Integer getTmaNb() {
            return this.mTmaNb;
        }

        STATE getOutputState() {
            return this.mOutputState;
        }

        public int hashCode() {
            int n = 31 + (this.mStateNb == null ? 0 : this.mStateNb.hashCode());
            n = 31 * n + (this.mTmaNb == null ? 0 : this.mTmaNb.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MetaState metaState = (MetaState)object;
            if (this.mStateNb == null ? metaState.mStateNb != null : !this.mStateNb.equals(metaState.mStateNb)) {
                return false;
            }
            return !(this.mTmaNb == null ? metaState.mTmaNb != null : !this.mTmaNb.equals(metaState.mTmaNb));
        }
    }

    private static class SizeInfoContainer {
        protected final int mTotalSize;
        protected final int mTmaSize;
        protected final int mNumOfReachableTmas;

        public SizeInfoContainer(int n, int n2, int n3) {
            this.mTmaSize = n;
            this.mNumOfReachableTmas = n2;
            this.mTotalSize = n3;
        }
    }

    private class TransitionMonoidAutomaton {
        private final Integer mInitialStateTma;
        private final Integer mInitialTma;
        private final INestedWordAutomaton<LETTER, STATE> mOrigAutomaton;
        private final Map<Integer, Map<LETTER, Integer>> mTransitionsOutTma;
        private final Map<Integer, Map<LETTER, Set<Integer>>> mTransitionsInTma;
        private final Map<Integer, Set<Integer>> mRejectingPairsL2R;
        private final Map<Integer, Set<Integer>> mRejectingPairsR2L;
        private Set<Integer> mStatesWithLeftRejectingPartners;

        public TransitionMonoidAutomaton(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
            Object object;
            Object object2;
            TransitionProfile transitionProfile;
            Integer n2;
            this.mInitialTma = this.mInitialStateTma = Integer.valueOf(0);
            this.mTransitionsOutTma = new HashMap();
            this.mTransitionsInTma = new HashMap();
            this.mOrigAutomaton = iNestedWordAutomaton;
            Set set = iNestedWordAutomaton.getVpAlphabet().getInternalAlphabet();
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
            HashMap<Integer, TransitionProfile> hashMap3 = new HashMap<Integer, TransitionProfile>();
            for (Integer n2 : set) {
                hashMap3.put(n2, new TransitionProfile(n2));
            }
            n2 = this.mInitialStateTma;
            TransitionProfile transitionProfile2 = new TransitionProfile();
            hashMap.put(n2, transitionProfile2);
            hashMap2.put(transitionProfile2, n2);
            this.mTransitionsOutTma.put(n2, new HashMap());
            this.mTransitionsInTma.put(n2, new HashMap());
            int n3 = 1;
            Serializable serializable = n2;
            while ((Integer)serializable < n3) {
                TransitionProfile transitionProfile3 = (TransitionProfile)hashMap.get(serializable);
                for (Object object3 : set) {
                    transitionProfile = new TransitionProfile(this, transitionProfile3, (TransitionProfile)hashMap3.get(object3));
                    object2 = (Integer)hashMap2.get(transitionProfile);
                    if (object2 == null) {
                        object2 = n3;
                        ++n3;
                        hashMap.put((Integer)object2, transitionProfile);
                        hashMap2.put(transitionProfile, (Integer)object2);
                        this.mTransitionsOutTma.put((Integer)object2, new HashMap());
                        this.mTransitionsInTma.put((Integer)object2, new HashMap());
                    }
                    this.mTransitionsOutTma.get(serializable).put(object3, (Integer)object2);
                    object = this.mTransitionsInTma.get(object2).get(object3);
                    if (object == null) {
                        object = new HashSet<Integer>();
                        this.mTransitionsInTma.get(object2).put((Object)object3, (Set<Integer>)object);
                    }
                    object.add((Integer)serializable);
                }
                serializable = Integer.valueOf((Integer)serializable + 1);
            }
            serializable = new ArrayList();
            for (TransitionProfile transitionProfile3 : hashMap2.keySet()) {
                if (!transitionProfile3.isIdempotent()) continue;
                serializable.add(transitionProfile3);
            }
            this.mRejectingPairsL2R = new HashMap<Integer, Set<Integer>>(n3);
            this.mRejectingPairsR2L = new HashMap<Integer, Set<Integer>>(n3);
            int n4 = n2;
            while (n4 < n3) {
                this.mRejectingPairsL2R.put(n4, new HashSet(0));
                this.mRejectingPairsR2L.put(n4, new HashSet(0));
                ++n4;
            }
            Integer n5 = n2;
            while (n5 < n3) {
                Object object3;
                if (!BuchiComplementAutomatonSVW.this.mServices.getProgressAwareTimer().continueProcessing()) {
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                object3 = (TransitionProfile)hashMap.get(n5);
                Set<Integer> set2 = this.mRejectingPairsL2R.get(n5);
                object2 = serializable.iterator();
                while (object2.hasNext()) {
                    transitionProfile = (TransitionProfile)object2.next();
                    if (!((TransitionProfile)object3).isInvariantUnder(transitionProfile) || ((TransitionProfile)object3).hasAcceptingLasso(transitionProfile)) continue;
                    object = (Integer)hashMap2.get(transitionProfile);
                    Set<Integer> set3 = this.mRejectingPairsR2L.get(object);
                    set2.add((Integer)object);
                    set3.add(n5);
                }
                n5 = n5 + 1;
            }
        }

        public Integer getInitialState() {
            return this.mInitialStateTma;
        }

        public Integer getInitialTma() {
            return this.mInitialTma;
        }

        protected INestedWordAutomaton<LETTER, STATE> getOrigAutomaton() {
            return this.mOrigAutomaton;
        }

        public int size() {
            return this.mTransitionsOutTma.size();
        }

        public Integer successor(Integer n, LETTER LETTER) {
            return this.mTransitionsOutTma.get(n).get(LETTER);
        }

        public Set<Integer> predecessors(Integer n, LETTER LETTER) {
            return this.mTransitionsInTma.get(n).get(LETTER);
        }

        public Set<Integer> rightRejectingPartners(Integer n) {
            return this.mRejectingPairsL2R.get(n);
        }

        public Set<Integer> leftRejectingPartners(Integer n) {
            return this.mRejectingPairsR2L.get(n);
        }

        public Set<Integer> statesWithLeftRejectingPartners() {
            if (this.mStatesWithLeftRejectingPartners == null) {
                this.mStatesWithLeftRejectingPartners = new HashSet<Integer>();
                for (Map.Entry<Integer, Set<Integer>> entry : this.mRejectingPairsR2L.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    this.mStatesWithLeftRejectingPartners.add(entry.getKey());
                }
            }
            return this.mStatesWithLeftRejectingPartners;
        }

        private final class Transition {
            private final STATE mQ1;
            private final STATE mQ2;

            public Transition(STATE STATE, STATE STATE2) {
                this.mQ1 = STATE;
                this.mQ2 = STATE2;
            }

            STATE getQ1() {
                return this.mQ1;
            }

            STATE getQ2() {
                return this.mQ2;
            }

            public int hashCode() {
                return Objects.hash(this.mQ1, this.mQ2);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Transition transition = (Transition)object;
                if (this.mQ1 == null ? transition.mQ1 != null : !this.mQ1.equals(transition.mQ1)) {
                    return false;
                }
                return !(this.mQ2 == null ? transition.mQ2 != null : !this.mQ2.equals(transition.mQ2));
            }
        }

        private class TransitionProfile {
            private boolean mIsInitial;
            private final Map<de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition, Boolean> mTransitions;

            public TransitionProfile() {
                this.mTransitions = new HashMap<de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition, Boolean>();
                this.mIsInitial = true;
                for (Object STATE : TransitionMonoidAutomaton.this.getOrigAutomaton().getStates()) {
                    if (TransitionMonoidAutomaton.this.getOrigAutomaton().isFinal(STATE)) {
                        this.mTransitions.put((de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition)new Transition(STATE, STATE), Boolean.TRUE);
                        continue;
                    }
                    this.mTransitions.put((de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition)new Transition(STATE, STATE), Boolean.FALSE);
                }
            }

            public TransitionProfile(LETTER LETTER) {
                this.mTransitions = new HashMap<de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition, Boolean>();
                for (Object STATE : TransitionMonoidAutomaton.this.getOrigAutomaton().getStates()) {
                    boolean bl = TransitionMonoidAutomaton.this.getOrigAutomaton().isFinal(STATE);
                    for (OutgoingInternalTransition outgoingInternalTransition : TransitionMonoidAutomaton.this.getOrigAutomaton().internalSuccessors(STATE, LETTER)) {
                        Object STATE2 = outgoingInternalTransition.getSucc();
                        if (bl || TransitionMonoidAutomaton.this.getOrigAutomaton().isFinal(STATE2)) {
                            this.mTransitions.put((de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition)new Transition(STATE, STATE2), Boolean.TRUE);
                            continue;
                        }
                        this.mTransitions.put((de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition)new Transition(STATE, STATE2), Boolean.FALSE);
                    }
                }
            }

            public TransitionProfile(de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.TransitionProfile transitionProfile, de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.TransitionProfile transitionProfile2) {
                this.mTransitions = new HashMap<de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition, Boolean>();
                for (Transition transition : transitionProfile.mTransitions.keySet()) {
                    for (Transition transition2 : transitionProfile2.mTransitions.keySet()) {
                        if (!transition.getQ2().equals(transition2.getQ1())) continue;
                        Transition transition3 = new Transition(transition.getQ1(), transition2.getQ2());
                        if (transitionProfile.getTransitions().get(transition).booleanValue() || transitionProfile2.getTransitions().get(transition2).booleanValue()) {
                            this.mTransitions.put((de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition)transition3, Boolean.TRUE);
                            continue;
                        }
                        if (this.mTransitions.containsKey(transition3)) continue;
                        this.mTransitions.put((de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition)transition3, Boolean.FALSE);
                    }
                }
            }

            protected Map<de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementAutomatonSVW$TransitionMonoidAutomaton.Transition, Boolean> getTransitions() {
                return this.mTransitions;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public boolean isInvariantUnder(TransitionProfile transitionProfile) {
                return new TransitionProfile(TransitionMonoidAutomaton.this, this, transitionProfile).equals(this);
            }

            public boolean isIdempotent() {
                return new TransitionProfile(TransitionMonoidAutomaton.this, this, this).equals(this);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public boolean hasAcceptingLasso(TransitionProfile transitionProfile) {
                for (Transition transition : this.mTransitions.keySet()) {
                    if (!TransitionMonoidAutomaton.this.getOrigAutomaton().isInitial(transition.getQ1())) continue;
                    Transition transition2 = new Transition(transition.getQ2(), transition.getQ2());
                    if (!transitionProfile.getTransitions().containsKey(transition2) || !transitionProfile.getTransitions().get(transition2).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            public int hashCode() {
                int n = 1;
                n = 31 * n + this.mTransitions.hashCode();
                return n;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                TransitionProfile transitionProfile = (TransitionProfile)object;
                return this.mTransitions.equals(transitionProfile.mTransitions) && this.mIsInitial == transitionProfile.mIsInitial;
            }
        }
    }
}

