/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaCombinator;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;

public class MinimizeNwaMulti<LETTER, STATE>
extends MinimizeNwaCombinator<LETTER, STATE> {
    private static final int DEFAULT_MINIMIZE_MAX_SAT_SIZE = 10000;
    private static final int SIMULATION_BASED_DIRECT_SIZE = 2000;

    public MinimizeNwaMulti(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, ISetOfPairs<STATE, ?> iSetOfPairs, boolean bl) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, iSetOfPairs, bl, Strategy.DEFAULT);
    }

    public MinimizeNwaMulti(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, ISetOfPairs<STATE, ?> iSetOfPairs, boolean bl, Strategy strategy) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton);
        this.mMode = this.chooseMinimization(iDoubleDeckerAutomaton, strategy);
        super.run(iSetOfPairs, bl);
    }

    private MinimizeNwaCombinator.MinimizationMethods chooseMinimization(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, Strategy strategy) {
        switch (strategy) {
            case DEFAULT: {
                return this.chooseDefaultMinimization(iDoubleDeckerAutomaton);
            }
            case SIMULATION_BASED: {
                return this.chooseSimulationBasedMinimization(iDoubleDeckerAutomaton);
            }
        }
        throw new IllegalArgumentException("Undefined enum state.");
    }

    private MinimizeNwaCombinator.MinimizationMethods chooseDefaultMinimization(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) {
        if (iDoubleDeckerAutomaton.size() <= 10000) {
            return MinimizeNwaCombinator.MinimizationMethods.NWA_MAX_SAT2;
        }
        return MinimizeNwaCombinator.MinimizationMethods.NONE;
    }

    private MinimizeNwaCombinator.MinimizationMethods chooseSimulationBasedMinimization(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) {
        if (iDoubleDeckerAutomaton.size() <= 2000) {
            return MinimizeNwaCombinator.MinimizationMethods.NWA_RAQ_DIRECT;
        }
        return MinimizeNwaCombinator.MinimizationMethods.NONE;
    }

    public static enum Strategy {
        DEFAULT,
        SIMULATION_BASED;

    }
}

