/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetSuccessorProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ConfigurationOrder;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.DepthBasedOrder;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.EsparzaRoemerVoglerOrder;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.IPossibleExtensions;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.McMillanOrder;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.PetriNetUnfolder;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.PossibleExtensions;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PetriNetUnfolderBase<L, P, R> {
    protected static final boolean EXTENDED_ASSERTION_CHECKING = false;
    private static final boolean B32_OPTIMIZATION = true;
    private static final boolean USE_FIRSTBORN_CUTOFF_CHECK = true;
    private static final boolean DEBUG_LOG_CO_RELATION_DEGREE_HISTOGRAM = false;
    protected final AutomataLibraryServices mServices;
    protected final ILogger mLogger;
    protected final IPetriNetSuccessorProvider<L, P> mOperand;
    private final boolean mStopIfAcceptingRunFound;
    private final boolean mSameTransitionCutOff;
    private final ConfigurationOrder<L, P> mOrder;
    private final IPossibleExtensions<L, P> mPossibleExtensions;
    protected final BranchingProcess<L, P> mUnfolding;
    private R mRun;
    private final Statistics mStatistics = new Statistics();

    public PetriNetUnfolderBase(AutomataLibraryServices automataLibraryServices, IPetriNetSuccessorProvider<L, P> iPetriNetSuccessorProvider, PetriNetUnfolder.EventOrderEnum eventOrderEnum, boolean bl, boolean bl2) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mOperand = iPetriNetSuccessorProvider;
        this.mStopIfAcceptingRunFound = bl2;
        this.mSameTransitionCutOff = bl;
        this.mLogger.debug((Object)("Start unfolding. Net " + this.mOperand.sizeInformation() + (this.mStopIfAcceptingRunFound ? "We stop if some accepting run was found" : "We compute complete finite Prefix")));
        this.mOrder = switch (eventOrderEnum) {
            case PetriNetUnfolder.EventOrderEnum.KMM -> new McMillanOrder();
            case PetriNetUnfolder.EventOrderEnum.ERV -> new EsparzaRoemerVoglerOrder();
            case PetriNetUnfolder.EventOrderEnum.DBO -> new DepthBasedOrder();
            default -> throw new MatchException(null, null);
        };
        this.mUnfolding = new BranchingProcess<L, P>(this.mServices, iPetriNetSuccessorProvider, this.mOrder, true, true);
        this.mPossibleExtensions = new PossibleExtensions<L, P>(this.mUnfolding, this.mOrder, true, true);
        this.computeUnfolding();
        this.mLogger.info((Object)this.mStatistics.prettyprintCutOffInformation());
        this.mLogger.info((Object)this.mStatistics.prettyprintCoRelationInformation());
    }

    public Statistics getUnfoldingStatistics() {
        return this.mStatistics;
    }

    public R getAcceptingRun() {
        return this.mRun;
    }

    protected abstract boolean checkInitialPlaces();

    protected abstract R constructInitialRun() throws PetriNetNot1SafeException;

    protected abstract boolean addAndCheck(Event<L, P> var1) throws PetriNetNot1SafeException;

    protected abstract R constructRun(Event<L, P> var1) throws PetriNetNot1SafeException;

    private void computeUnfolding() throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        if (this.checkInitialPlaces()) {
            this.mRun = this.constructInitialRun();
            if (this.mStopIfAcceptingRunFound) {
                return;
            }
        }
        this.mPossibleExtensions.update(this.mUnfolding.getDummyRoot());
        while (!this.mPossibleExtensions.isEmpy()) {
            Event<L, P> event = this.mPossibleExtensions.remove();
            boolean bl = this.computeUnfoldingHelper(event);
            if (bl) {
                this.mLogger.info((Object)"Found word, exiting Unfolder.");
                return;
            }
            if (this.mServices.getProgressAwareTimer().continueProcessing()) continue;
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "constructing finite prefix that currently has " + this.mUnfolding.getConditions().size() + " conditions, " + this.mUnfolding.getEvents().size() + " events (" + this.mStatistics.prettyprintCutOffInformation() + " " + this.mStatistics.prettyprintCoRelationInformation() + " " + this.mStatistics.prettyprintPossibleExtensionsMaximalSize() + " " + this.mStatistics.prettyprintNumberOfEventComparisons() + " " + this.mStatistics.prettyprintPossibleExtensionCandidatesInformation() + " " + this.mStatistics.prettyprintCoRelationMaximalDegree() + " " + this.mStatistics.prettyprintConditionPerPlaceMax() + ")");
            throw new AutomataOperationCanceledException(runningTaskInfo);
        }
    }

    private boolean computeUnfoldingHelper(Event<L, P> event) throws PetriNetNot1SafeException {
        assert (!this.parentIsCutoffEvent(event)) : "We must not construct successors of cut-off events.";
        boolean bl = event.isCutoffEvent();
        if (this.addAndCheck(event)) {
            if (this.mRun == null) {
                this.mRun = this.constructRun(event);
            }
            if (this.mStopIfAcceptingRunFound) {
                return true;
            }
        }
        if (bl) {
            this.mLogger.debug((Object)("Constructed     Cut-off-Event: " + event.toString()));
        } else {
            long l = this.mPossibleExtensions.size();
            this.mPossibleExtensions.update(event);
            long l2 = (long)this.mPossibleExtensions.size() - l;
            this.mLogger.debug((Object)("Constructed Non-cut-off-Event: " + event.toString()));
            this.mLogger.debug((Object)("The Event lead to " + l2 + " new possible extensions."));
        }
        this.mLogger.debug((Object)("Possible Extension size: " + this.mPossibleExtensions.size() + ", total #Events: " + this.mUnfolding.getEvents().size() + ", total #Conditions: " + this.mUnfolding.getConditions().size()));
        this.mStatistics.add(event);
        return false;
    }

    private boolean parentIsCutoffEvent(Event<L, P> event) {
        for (Condition<L, P> condition : event.getPredecessorConditions()) {
            if (!condition.getPredecessorEvent().isCutoffEvent()) continue;
            return true;
        }
        return false;
    }

    public BranchingProcess<L, P> getFinitePrefix() {
        return this.mUnfolding;
    }

    public BranchingProcess<L, P> getResult() {
        return this.mUnfolding;
    }

    public boolean checkResult(IPetriNet2FiniteAutomatonStateFactory<P> iPetriNet2FiniteAutomatonStateFactory) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        return this.checkRun(iPetriNet2FiniteAutomatonStateFactory, this.mRun);
    }

    protected abstract boolean checkRun(IPetriNet2FiniteAutomatonStateFactory<P> var1, R var2) throws AutomataOperationCanceledException, PetriNetNot1SafeException;

    public class Statistics {
        private final Map<Transition<L, P>, Map<Marking<P>, Set<Event<L, P>>>> mTrans2Mark2Events = new HashMap();
        private int mCutOffEvents;
        private int mNonCutOffEvents;

        public void add(Event<L, P> event) {
            Set set;
            Marking marking = event.getMark();
            Transition transition = event.getTransition();
            Map map = this.mTrans2Mark2Events.get(transition);
            if (map == null) {
                map = new HashMap();
                this.mTrans2Mark2Events.put(transition, map);
            }
            if ((set = map.get(marking)) == null) {
                set = new HashSet();
                map.put(marking, set);
            }
            if (set.size() > 2) {
                PetriNetUnfolderBase.this.mLogger.info((Object)("inserting event number " + (set.size() + 1) + " for the transition-marking pair (" + String.valueOf(transition) + ", " + String.valueOf(marking) + ")"));
                PetriNetUnfolderBase.this.mLogger.info((Object)("this new event has " + event.getAncestors() + " ancestors and is " + (event.isCutoffEvent() ? "" : "not ") + "cut-off event"));
                for (Event event2 : set) {
                    PetriNetUnfolderBase.this.mLogger.info((Object)("  existing Event has " + event2.getAncestors() + " ancestors and is " + (event.isCutoffEvent() ? "" : "not ") + "cut-off event"));
                    assert (event2.getAncestors() == event.getAncestors() || event.isCutoffEvent() || event2.isCutoffEvent()) : "if there is already an event that has the same marking and a different size of local configuration then the new event must be cut-off event";
                }
            }
            set.add(event);
            if (event.isCutoffEvent()) {
                ++this.mCutOffEvents;
            } else {
                ++this.mNonCutOffEvents;
            }
        }

        public String prettyprintCutOffInformation() {
            return this.getCutOffEvents() + "/" + (this.getCutOffEvents() + this.getNonCutOffEvents()) + " cut-off events.";
        }

        public String prettyprintCoRelationInformation() {
            return "For " + this.getCoRelationQueriesYes() + "/" + (this.getCoRelationQueriesYes() + this.getCoRelationQueriesNo()) + " co-relation queries the response was YES.";
        }

        public String prettyprintPossibleExtensionCandidatesInformation() {
            return this.getNumberOfUselessExtensionCandidates() + "/" + this.getNumberOfExtensionCandidates() + " useless extension candidates.";
        }

        public String prettyprintPossibleExtensionsMaximalSize() {
            return "Maximal size of possible extension queue " + this.getMaximalSizeOfPossibleExtensions() + ".";
        }

        public String prettyprintCoRelationMaximalDegree() {
            return "Maximal degree in co-relation " + this.computeCoRelationMaximalDegree() + ".";
        }

        public String prettyprintConditionPerPlaceMax() {
            return "Up to " + this.computeConditionPerPlaceMax() + " conditions per place.";
        }

        public String prettyprintNumberOfEventComparisons() {
            return "Compared " + this.getNumberOfConfigurationComparisons() + " event pairs, " + this.getNumberOfFoataBasedConfigurationComparisons() + " based on Foata normal form.";
        }

        public long getCoRelationQueriesYes() {
            return PetriNetUnfolderBase.this.mUnfolding.getCoRelation().getQueryCounterYes();
        }

        public long getCoRelationQueriesNo() {
            return PetriNetUnfolderBase.this.mUnfolding.getCoRelation().getQueryCounterNo();
        }

        public int getCutOffEvents() {
            return this.mCutOffEvents;
        }

        public int getNonCutOffEvents() {
            return this.mNonCutOffEvents;
        }

        public int getNumberOfConfigurationComparisons() {
            return PetriNetUnfolderBase.this.mOrder.getNumberOfComparisons();
        }

        public int getNumberOfFoataBasedConfigurationComparisons() {
            return PetriNetUnfolderBase.this.mOrder.getFotateNormalFormComparisons();
        }

        public long unreachableTransitionsInOperand() {
            int n = ((IPetriNet)PetriNetUnfolderBase.this.mOperand).getTransitions().size();
            long l = RemoveUnreachable.reachableTransitions(PetriNetUnfolderBase.this.mUnfolding).size();
            return (long)n - l;
        }

        public int getNumberOfUselessExtensionCandidates() {
            return PetriNetUnfolderBase.this.mPossibleExtensions.getUselessExtensionCandidates();
        }

        public int getNumberOfExtensionCandidates() {
            return PetriNetUnfolderBase.this.mPossibleExtensions.getUsefulExtensionCandidates() + this.getNumberOfUselessExtensionCandidates();
        }

        public int computeCoRelationMaximalDegree() {
            return PetriNetUnfolderBase.this.mUnfolding.getCoRelation().computeMaximalDegree();
        }

        public int computeConditionPerPlaceMax() {
            return PetriNetUnfolderBase.this.mUnfolding.computeConditionPerPlaceMax();
        }

        public int getMaximalSizeOfPossibleExtensions() {
            return PetriNetUnfolderBase.this.mPossibleExtensions.getMaximalSize();
        }
    }
}

