/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IndexedStatement;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefEdgeAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVar;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag.DataflowDAG;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataflowDAGGenerator
extends BaseObserver {
    private final ILogger mLogger;
    private final IAnnotationProvider<ReachDefStatementAnnotation> mStatementProvider;
    private final LinkedHashMap<IcfgEdge, List<AssumeStatement>> mEdgesWithAssumes;
    private List<DataflowDAG<Statement>> mForest;

    public DataflowDAGGenerator(ILogger iLogger, IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider, IAnnotationProvider<ReachDefEdgeAnnotation> iAnnotationProvider2, LinkedHashMap<IcfgEdge, List<AssumeStatement>> linkedHashMap) {
        this.mLogger = iLogger;
        this.mStatementProvider = iAnnotationProvider;
        this.mEdgesWithAssumes = linkedHashMap;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (this.mEdgesWithAssumes == null || this.mEdgesWithAssumes.isEmpty()) {
            return false;
        }
        if (iElement instanceof BoogieIcfgContainer) {
            BoogieIcfgContainer boogieIcfgContainer = (BoogieIcfgContainer)iElement;
            this.mForest = this.process(boogieIcfgContainer);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"DataflowDAGGenerator results:");
                this.mLogger.debug((Object)("#" + this.mForest.size() + " trees generated"));
                this.printDebugForest();
            }
        }
        return false;
    }

    public List<DataflowDAG<Statement>> getDAGs() {
        return this.mForest;
    }

    private List<DataflowDAG<Statement>> process(BoogieIcfgContainer boogieIcfgContainer) {
        ArrayList<DataflowDAG<Statement>> arrayList = new ArrayList<DataflowDAG<Statement>>();
        for (Map.Entry<IcfgEdge, List<AssumeStatement>> entry : this.mEdgesWithAssumes.entrySet()) {
            for (AssumeStatement assumeStatement : entry.getValue()) {
                arrayList.add(this.buildDAG(entry.getKey(), assumeStatement));
            }
        }
        return arrayList;
    }

    private DataflowDAG<Statement> buildDAG(IcfgEdge icfgEdge, AssumeStatement assumeStatement) {
        DataflowDAG dataflowDAG;
        LinkedList<DataflowDAG<Statement>> linkedList = new LinkedList<DataflowDAG<Statement>>();
        DataflowDAG dataflowDAG2 = dataflowDAG = new DataflowDAG(assumeStatement);
        linkedList.add(dataflowDAG);
        while (!linkedList.isEmpty()) {
            dataflowDAG = (DataflowDAG)((Object)linkedList.removeFirst());
            Set<Map.Entry<ScopedBoogieVar, HashSet<IndexedStatement>>> set = this.getUse(dataflowDAG);
            for (Map.Entry<ScopedBoogieVar, HashSet<IndexedStatement>> entry : set) {
                for (IndexedStatement indexedStatement : entry.getValue()) {
                    DataflowDAG<Statement> dataflowDAG3 = new DataflowDAG<Statement>(indexedStatement.getStatement());
                    dataflowDAG.addOutgoingNode(dataflowDAG3, entry.getKey());
                    linkedList.addFirst(dataflowDAG3);
                }
            }
        }
        return dataflowDAG2;
    }

    private Set<Map.Entry<ScopedBoogieVar, HashSet<IndexedStatement>>> getUse(DataflowDAG<Statement> dataflowDAG) {
        ReachDefStatementAnnotation reachDefStatementAnnotation = this.mStatementProvider.getAnnotation((IElement)dataflowDAG.getNodeLabel());
        assert (reachDefStatementAnnotation != null);
        HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> hashMap = reachDefStatementAnnotation.getUse();
        assert (hashMap != null);
        return hashMap.entrySet();
    }

    private void printDebugForest() {
        if (this.mForest == null) {
            return;
        }
        for (DataflowDAG<Statement> dataflowDAG : this.mForest) {
            dataflowDAG.printGraphDebug(this.mLogger);
        }
    }
}

