/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag;

import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Regex;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagNode;
import de.uni_freiburg.informatik.ultimate.util.datastructures.GraphToTgf;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class RegexDag<L> {
    private RegexDagNode<L> mSource;
    private RegexDagNode<L> mSink;

    public RegexDag(RegexDagNode<L> regexDagNode) {
        this(regexDagNode, regexDagNode);
    }

    public RegexDag(RegexDagNode<L> regexDagNode, RegexDagNode<L> regexDagNode2) {
        this.mSource = regexDagNode;
        this.mSink = regexDagNode2;
    }

    public static <L> RegexDag<L> makeEpsilon() {
        return RegexDag.singleNodeDag(Regex.epsilon());
    }

    public static <L> RegexDag<L> makeEmptySet() {
        return RegexDag.singleNodeDag(Regex.emptySet());
    }

    public static <L> RegexDag<L> singleNodeDag(IRegex<L> iRegex) {
        return new RegexDag<L>(new RegexDagNode<L>(iRegex));
    }

    public RegexDagNode<L> getSource() {
        return this.mSource;
    }

    public RegexDagNode<L> getSink() {
        return this.mSink;
    }

    public void setSource(RegexDagNode<L> regexDagNode) {
        this.mSource = regexDagNode;
    }

    public void setSink(RegexDagNode<L> regexDagNode) {
        this.mSink = regexDagNode;
    }

    public String toString() {
        return GraphToTgf.graph(this.mSource).includeComponentOf(this.mSink).getTgf();
    }

    public Collection<RegexDagNode<L>> collectNodes() {
        LinkedHashSet<RegexDagNode<L>> linkedHashSet = new LinkedHashSet<RegexDagNode<L>>();
        this.collectNodes(linkedHashSet, this.mSource);
        return linkedHashSet;
    }

    private void collectNodes(Set<RegexDagNode<L>> set, RegexDagNode<L> regexDagNode2) {
        if (set.add(regexDagNode2)) {
            regexDagNode2.getOutgoingNodes().forEach(regexDagNode -> this.collectNodes(set, (RegexDagNode<L>)((Object)regexDagNode)));
        }
    }
}

