/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.CachedIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MonotonicIndependenceCache<L>
implements CachedIndependenceRelation.IIndependenceCache<IPredicate, L> {
    private final Map<L, Map<L, Set<IPredicate>>> mIndependentCache = new HashMap<L, Map<L, Set<IPredicate>>>();
    private final Map<L, Map<L, Set<IPredicate>>> mDependentCache = new HashMap<L, Map<L, Set<IPredicate>>>();
    private final Map<L, Map<L, Set<IPredicate>>> mUnknownCache = new HashMap<L, Map<L, Set<IPredicate>>>();
    private final IPredicateCoverageChecker mCoverageChecker;

    public MonotonicIndependenceCache(IPredicateCoverageChecker iPredicateCoverageChecker) {
        this.mCoverageChecker = iPredicateCoverageChecker;
    }

    public IIndependenceRelation.Dependence contains(IPredicate iPredicate, L l, L l2) {
        Set<IPredicate> set = this.getCacheEntry(this.mIndependentCache, l, l2);
        boolean bl = set.stream().anyMatch(iPredicate2 -> this.mCoverageChecker.isCovered(iPredicate, iPredicate2) == IncrementalPlicationChecker.Validity.VALID);
        if (bl) {
            return IIndependenceRelation.Dependence.INDEPENDENT;
        }
        Set<IPredicate> set2 = this.getCacheEntry(this.mDependentCache, l, l2);
        boolean bl2 = set2.stream().anyMatch(iPredicate2 -> this.mCoverageChecker.isCovered(iPredicate2, iPredicate) == IncrementalPlicationChecker.Validity.VALID);
        if (bl2) {
            return IIndependenceRelation.Dependence.DEPENDENT;
        }
        Set<IPredicate> set3 = this.getCacheEntry(this.mUnknownCache, l, l2);
        if (set3.contains(iPredicate)) {
            return IIndependenceRelation.Dependence.UNKNOWN;
        }
        return null;
    }

    private Set<IPredicate> getCacheEntry(Map<L, Map<L, Set<IPredicate>>> map, L l, L l2) {
        Map<L, Set<IPredicate>> map2 = map.get(l);
        if (map2 == null) {
            return Collections.emptySet();
        }
        Set<IPredicate> set = map2.get(l2);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public void remove(L l) {
        this.removeFromCache(this.mIndependentCache, l);
        this.removeFromCache(this.mDependentCache, l);
        this.removeFromCache(this.mUnknownCache, l);
    }

    private void removeFromCache(Map<L, Map<L, Set<IPredicate>>> map, L l) {
        map.remove(l);
        for (Map<L, Set<IPredicate>> map2 : map.values()) {
            map2.remove(l);
        }
    }

    public void cacheResult(IPredicate iPredicate, L l, L l2, IIndependenceRelation.Dependence dependence) {
        switch (dependence) {
            case INDEPENDENT: {
                this.addPositiveCacheEntry(iPredicate, l, l2);
                break;
            }
            case DEPENDENT: {
                this.addNegativeCacheEntry(iPredicate, l, l2);
                break;
            }
            case UNKNOWN: {
                this.addUnknownCacheEntry(iPredicate, l, l2);
            }
        }
    }

    private void addPositiveCacheEntry(IPredicate iPredicate, L l, L l2) {
        Map map = this.mIndependentCache.computeIfAbsent(l, object -> new HashMap());
        Set set = map.computeIfAbsent(l2, object -> new HashSet());
        set.removeIf(iPredicate2 -> this.mCoverageChecker.isCovered(iPredicate2, iPredicate) == IncrementalPlicationChecker.Validity.VALID);
        set.add(iPredicate);
    }

    private void addNegativeCacheEntry(IPredicate iPredicate, L l, L l2) {
        Map map = this.mDependentCache.computeIfAbsent(l, object -> new HashMap());
        Set set = map.computeIfAbsent(l2, object -> new HashSet());
        set.removeIf(iPredicate2 -> this.mCoverageChecker.isCovered(iPredicate, iPredicate2) == IncrementalPlicationChecker.Validity.VALID);
        set.add(iPredicate);
    }

    private void addUnknownCacheEntry(IPredicate iPredicate, L l, L l2) {
        Map map = this.mUnknownCache.computeIfAbsent(l, object -> new HashMap());
        Set set = map.computeIfAbsent(l2, object -> new HashSet());
        set.add(iPredicate);
    }

    public void mergeIndependencies(L l, L l2, L l3) {
        throw new UnsupportedOperationException("This cache does not yet implement independence merging");
    }
}

