/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pdr;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsGeneratorWithStopwatches;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.Collection;
import java.util.function.Function;

public final class PdrBenchmark
extends StatisticsGeneratorWithStopwatches
implements IStatisticsDataProvider {
    private static final String[] STOPWATCHES = new String[]{PdrStatisticsDefinitions.PDR_RUNTIME.toString()};

    public Collection<String> getKeys() {
        return this.getBenchmarkType().getKeys();
    }

    public Object getValue(String string) {
        Long l;
        PdrStatisticsDefinitions pdrStatisticsDefinitions = PdrStatisticsDefinitions.valueOf(string);
        switch (pdrStatisticsDefinitions) {
            case PDR_RUNTIME: {
                try {
                    l = this.getElapsedTime(string);
                    break;
                }
                catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
                    throw new AssertionError((Object)("clock still running: " + string));
                }
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        return l;
    }

    public IStatisticsType getBenchmarkType() {
        return PdrStatisticsType.getInstance();
    }

    public String[] getStopwatches() {
        return STOPWATCHES;
    }

    public static enum PdrStatisticsDefinitions implements IStatisticsElement
    {
        PDR_RUNTIME(Long.class, StatisticsType.LONG_ADDITION, StatisticsType.NANOS_BEFORE_KEY);

        private final Class<?> mClazz;
        private final Function<Object, Function<Object, Object>> mAggr;
        private final Function<String, Function<Object, String>> mPrettyprinter;

        private PdrStatisticsDefinitions(Class<?> clazz, Function<Object, Function<Object, Object>> function, Function<String, Function<Object, String>> function2) {
            this.mClazz = clazz;
            this.mAggr = function;
            this.mPrettyprinter = function2;
        }

        public Object aggregate(Object object, Object object2) {
            return this.mAggr.apply(object).apply(object2);
        }

        public String prettyprint(Object object) {
            return this.mPrettyprinter.apply(CoreUtil.getUpperToCamelCase((String)this.name())).apply(object);
        }
    }

    private static final class PdrStatisticsType
    extends StatisticsType<PdrStatisticsDefinitions> {
        private static final PdrStatisticsType INSTANCE = new PdrStatisticsType();

        public PdrStatisticsType() {
            super(PdrStatisticsDefinitions.class);
        }

        public static PdrStatisticsType getInstance() {
            return INSTANCE;
        }
    }
}

