/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.TimeUnit;

public class FastUPRBenchmark
implements ICsvProviderProvider<String> {
    private final Deque<FastUPRRun> mRuns = new ArrayDeque<FastUPRRun>();
    private int mPathsFound = 0;
    private int mPathsTried = 0;
    private int mSuccesses = 0;

    public void startRun(IcfgLocation icfgLocation) {
        this.mRuns.add(new FastUPRRun(icfgLocation));
    }

    public void endRun(boolean bl) {
        ++this.mPathsTried;
        if (bl) {
            ++this.mSuccesses;
        }
        this.mRuns.getLast().endRun(bl);
    }

    public void setPathsFound(int n) {
        this.mPathsFound = n;
    }

    static double getNanosecondsToUnit(long l, TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return l;
            }
            case MICROSECONDS: {
                return (double)l / 1000.0;
            }
            case MILLISECONDS: {
                return (double)l / 1000000.0;
            }
            case SECONDS: {
                return (double)l / 1.0E9;
            }
            case MINUTES: {
                return (double)l / 6.0E10;
            }
            case HOURS: {
                return (double)l / 3.6E12;
            }
            case DAYS: {
                return (double)l / 8.64E13;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Benchmark Results are:\n");
        stringBuilder.append(this.createCsvProvider().toString());
        stringBuilder.append(" * FastUPR found: " + this.mPathsFound + " loopPaths and tried to accelerate " + this.mPathsTried + ".\n");
        stringBuilder.append(" * FastUPR accelerated " + this.mSuccesses + "/" + this.mPathsTried + " paths.");
        return stringBuilder.toString();
    }

    public ICsvProvider<String> createCsvProvider() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Success");
        arrayList.add(" Time elapsed ");
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(arrayList);
        for (FastUPRRun fastUPRRun : this.mRuns) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(fastUPRRun.mSuccessful ? "TRUE" : "FALSE");
            arrayList2.add("" + (double)Math.round(100.0 * FastUPRBenchmark.getNanosecondsToUnit(fastUPRRun.mTimeElapsed, TimeUnit.MILLISECONDS)) / 100.0);
            simpleCsvProvider.addRow(fastUPRRun.mLoopHead.toString(), arrayList2);
        }
        return simpleCsvProvider;
    }

    private static final class FastUPRRun {
        public boolean mSuccessful;
        public final IcfgLocation mLoopHead;
        public long mTimeElapsed;
        private final long mStartTime;

        FastUPRRun(IcfgLocation icfgLocation) {
            this.mLoopHead = icfgLocation;
            this.mStartTime = System.nanoTime();
        }

        public void endRun(boolean bl) {
            this.mSuccessful = bl;
            this.mTimeElapsed = System.nanoTime() - this.mStartTime;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Loop Head:" + this.mLoopHead.toString() + ", ");
            stringBuilder.append("Success: " + this.mSuccessful + ", ");
            stringBuilder.append("Time elapsed: " + (double)Math.round(100.0 * FastUPRBenchmark.getNanosecondsToUnit(this.mTimeElapsed, TimeUnit.MILLISECONDS)) / 100.0);
            return stringBuilder.toString();
        }
    }
}

