/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class SymbolicMemory {
    private final IUltimateServiceProvider mServices;
    private final Map<IProgramVar, Term> mMemoryMapping;
    private final ManagedScript mScript;
    private final IIcfgSymbolTable mOldSymbolTable;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;

    public SymbolicMemory(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, TransFormula transFormula, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mOldSymbolTable = iIcfgSymbolTable;
        this.mInVars = transFormula.getInVars();
        this.mOutVars = transFormula.getOutVars();
        this.mMemoryMapping = new HashMap<IProgramVar, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mInVars.entrySet()) {
            this.mMemoryMapping.put(entry.getKey(), (Term)entry.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mOutVars.entrySet()) {
            if (this.mMemoryMapping.containsKey(entry.getKey())) continue;
            this.mMemoryMapping.put(entry.getKey(), (Term)entry.getValue());
        }
    }

    public void updateVars(Map<IProgramVar, Term> map) {
        for (Map.Entry<IProgramVar, Term> entry : map.entrySet()) {
            ApplicationTerm applicationTerm;
            Term term = entry.getValue();
            HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
            if (term instanceof TermVariable && this.mMemoryMapping.containsKey(entry.getKey())) {
                hashMap.put(term, this.mMemoryMapping.get(entry.getKey()));
            }
            if (term instanceof TermVariable && !this.mMemoryMapping.containsKey(entry.getKey())) {
                this.mMemoryMapping.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (term instanceof ConstantTerm) {
                hashMap.put(this.mMemoryMapping.get(entry.getKey()), term);
            } else if (hashMap.isEmpty()) {
                applicationTerm = (ApplicationTerm)term;
                hashMap.putAll(this.termUnravel((Term)applicationTerm));
            }
            applicationTerm = Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)term);
            this.mMemoryMapping.replace(entry.getKey(), (Term)applicationTerm);
        }
    }

    public UnmodifiableTransFormula updateCondition(UnmodifiableTransFormula unmodifiableTransFormula) {
        Term term = unmodifiableTransFormula.getFormula();
        if (term instanceof QuantifiedFormula) {
            return null;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)unmodifiableTransFormula.getFormula();
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>(this.termUnravel((Term)applicationTerm, unmodifiableTransFormula.getInVars()));
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(this.mInVars, this.mOutVars, true, null, true, null, true);
        Term term2 = Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)unmodifiableTransFormula.getFormula());
        transFormulaBuilder.setFormula(SmtUtils.simplify((ManagedScript)this.mScript, (Term)term2, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA));
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(this.mScript);
    }

    private Map<Term, Term> termUnravel(Term term) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        if (term instanceof TermVariable) {
            if (this.mMemoryMapping.containsKey(this.mOldSymbolTable.getProgramVar((TermVariable)term))) {
                hashMap.put(term, this.mMemoryMapping.get(this.mOldSymbolTable.getProgramVar((TermVariable)term)));
            }
            return hashMap;
        }
        if (term instanceof ConstantTerm) {
            return hashMap;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        Term[] termArray = applicationTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray[n2];
            hashMap.putAll(this.termUnravel(term2));
            ++n2;
        }
        return hashMap;
    }

    private Map<Term, Term> termUnravel(Term term, Map<IProgramVar, TermVariable> map) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        if (term instanceof TermVariable) {
            for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
                if (!entry.getValue().equals(term) || !this.mMemoryMapping.containsKey(entry.getKey()) || this.mMemoryMapping.get(entry.getKey()) instanceof ConstantTerm) continue;
                hashMap.put(term, this.mMemoryMapping.get(entry.getKey()));
            }
            return hashMap;
        }
        if (term instanceof ConstantTerm) {
            return hashMap;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        Term[] termArray = applicationTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray[n2];
            hashMap.putAll(this.termUnravel(term2, map));
            ++n2;
        }
        return hashMap;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public Term getValue(IProgramVar iProgramVar) {
        return this.mMemoryMapping.get(iProgramVar);
    }

    public Map<IProgramVar, Term> getMemory() {
        return this.mMemoryMapping;
    }

    public Map<IProgramVar, TermVariable> getVars() {
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, Term> entry : this.mMemoryMapping.entrySet()) {
            hashMap.put(entry.getKey(), (TermVariable)entry.getValue());
        }
        return hashMap;
    }
}

