/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.IteratedSymbolicMemory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.LoopAcceleratorLite;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.LoopDetector;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class WernerLoopAccelerationIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> {
    private final ILogger mLogger;
    private final Map<IcfgLocation, Loop> mLoopBodies;
    private final LoopDetector<INLOC> mLoopDetector;
    private final IIcfg<OUTLOC> mResult;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final IIcfgSymbolTable mOldSymbolTable;
    private final List<TermVariable> mPathCounter;
    private final Map<TermVariable, TermVariable> mNewPathCounter;
    private final Map<IcfgLocation, Boolean> mOverApproximation;
    private final DealingWithArraysTypes mDealingWithArrays;
    private Set<INLOC> mLoopHeads;
    private final Set<Loop> mAcceleratedLoops;
    private final IcfgTransformationBacktranslator mBackTranslationTracker;

    public WernerLoopAccelerationIcfgTransformer(ILogger iLogger, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string, IUltimateServiceProvider iUltimateServiceProvider, DealingWithArraysTypes dealingWithArraysTypes, int n) {
        IIcfg<INLOC> iIcfg2 = Objects.requireNonNull(iIcfg);
        this.mBackTranslationTracker = icfgTransformationBacktranslator;
        this.mScript = iIcfg2.getCfgSmtToolkit().getManagedScript();
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mServices = iUltimateServiceProvider;
        this.mLoopHeads = new HashSet<INLOC>(iIcfg.getLoopLocations());
        this.mDealingWithArrays = dealingWithArraysTypes;
        this.preprocessIcfg(iIcfg.getInitialNodes());
        this.mOldSymbolTable = iIcfg.getCfgSmtToolkit().getSymbolTable();
        this.mPathCounter = new ArrayList<TermVariable>();
        this.mNewPathCounter = new HashMap<TermVariable, TermVariable>();
        this.mOverApproximation = new HashMap<IcfgLocation, Boolean>();
        this.mAcceleratedLoops = new HashSet<Loop>();
        this.mLoopDetector = new LoopDetector<INLOC>(this.mLogger, iIcfg2, this.mLoopHeads, this.mScript, this.mServices, n);
        this.mLoopBodies = this.mLoopDetector.getLoopBodies();
        this.mResult = this.transform(iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, string);
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string) {
        for (Map.Entry<IcfgLocation, Loop> basicIcfg2 : this.mLoopBodies.entrySet()) {
            Loop loop;
            if (basicIcfg2.getValue().getPath().isEmpty() || (loop = this.summarizeLoop(basicIcfg2.getValue())) == null) continue;
            this.mAcceleratedLoops.add(loop);
        }
        BasicIcfg basicIcfg = new BasicIcfg(string, iIcfg.getCfgSmtToolkit(), clazz);
        TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, iLocationFactory, icfgTransformationBacktranslator, iIcfg, basicIcfg);
        this.processLocations(iIcfg.getInitialNodes(), transformedIcfgBuilder);
        transformedIcfgBuilder.finish();
        return basicIcfg;
    }

    private Loop summarizeLoop(Loop loop) {
        Object object;
        Object object2;
        this.mPathCounter.clear();
        this.mNewPathCounter.clear();
        if (this.mAcceleratedLoops.contains(loop) || SmtUtils.isTrueLiteral((Term)loop.getFormula().getFormula()) || SmtUtils.isFalseLiteral((Term)loop.getFormula().getFormula())) {
            return null;
        }
        if (!loop.getNestedLoops().isEmpty()) {
            for (Loop arrayList2 : loop.getNestedLoops()) {
                this.mOverApproximation.put(arrayList2.getLoophead(), true);
                this.summarizeLoop(arrayList2);
            }
            this.mOverApproximation.put(loop.getLoophead(), true);
        }
        for (Backbone backbone : loop.getBackbones()) {
            this.calculateSymbolicMemory(backbone, loop);
            if (backbone.getCondition() != null) continue;
            return null;
        }
        for (TermVariable termVariable : this.mPathCounter) {
            object2 = this.mScript.constructFreshTermVariable("tau", this.mScript.getScript().sort("Int", new Sort[0]));
            this.mNewPathCounter.put(termVariable, (TermVariable)object2);
        }
        loop.addVar(this.mPathCounter);
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>(this.mNewPathCounter.values());
        loop.addVar(arrayList);
        ArrayList<TermVariable> arrayList3 = new ArrayList<TermVariable>(this.mPathCounter);
        object2 = new IteratedSymbolicMemory(this.mScript, this.mServices, this.mLogger, loop, (List<TermVariable>)arrayList3, this.mNewPathCounter);
        ((IteratedSymbolicMemory)object2).updateMemory();
        ((IteratedSymbolicMemory)object2).updateCondition();
        Term term = ((IteratedSymbolicMemory)object2).getAbstractCondition();
        this.mOverApproximation.putIfAbsent(loop.getLoophead(), ((IteratedSymbolicMemory)object2).isOverapprox());
        if (!loop.getNestedLoops().isEmpty()) {
            for (Loop loop2 : loop.getNestedLoops()) {
                for (UnmodifiableTransFormula unmodifiableTransFormula : loop2.getExitConditions()) {
                    term = SmtUtils.or((Script)this.mScript.getScript(), Arrays.asList(term, unmodifiableTransFormula.getFormula()));
                    object = new ArrayList(unmodifiableTransFormula.getAuxVars());
                    loop.addVar((List<TermVariable>)object);
                    term = loop.updateVars(term, unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars());
                }
                Map<IProgramVar, TermVariable> map = loop.getOutVars();
                for (Map.Entry<IProgramVar, TermVariable> entry : loop2.getOutVars().entrySet()) {
                    if (map.containsKey(entry.getKey())) continue;
                    map.put((IProgramVar)entry.getKey(), (TermVariable)entry.getValue());
                }
            }
        }
        loop.setCondition(term);
        loop.setIteratedSymbolicMemory((IteratedSymbolicMemory)object2);
        for (IcfgEdge icfgEdge : loop.getExitTransitions()) {
            Map.Entry<IProgramVar, TermVariable> entry;
            HashSet<TermVariable> hashSet = new HashSet<TermVariable>(loop.getVars());
            entry = LoopAcceleratorLite.buildFormula(this.mScript, loop.updateVars(icfgEdge.getTransformula().getFormula(), icfgEdge.getTransformula().getInVars(), icfgEdge.getTransformula().getOutVars()), loop.getInVars(), loop.getOutVars(), hashSet);
            object = SmtUtils.and((Script)this.mScript.getScript(), Arrays.asList(term, entry.getFormula()));
            HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>(loop.getVars());
            UnmodifiableTransFormula unmodifiableTransFormula = LoopAcceleratorLite.buildFormula(this.mScript, (Term)object, loop.getInVars(), loop.getOutVars(), hashSet2);
            loop.addExitCondition(unmodifiableTransFormula);
        }
        this.dealWithErrorPaths(loop, term);
        this.mLogger.debug((Object)("LOOP SUMMARY: " + String.valueOf(loop.getExitConditions()) + System.lineSeparator()));
        return loop;
    }

    private void calculateSymbolicMemory(Backbone backbone, Loop loop) {
        SimultaneousUpdate simultaneousUpdate;
        try {
            simultaneousUpdate = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)this.mServices, (TransFormula)backbone.getFormula(), (ManagedScript)this.mScript);
        }
        catch (SimultaneousUpdate.SimultaneousUpdateException simultaneousUpdateException) {
            throw new IllegalArgumentException(simultaneousUpdateException.getMessage());
        }
        if (!simultaneousUpdate.getHavocedVars().isEmpty() || !loop.getNestedLoops().isEmpty()) {
            this.mOverApproximation.put(loop.getLoophead(), true);
        }
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(loop.getVars());
        UnmodifiableTransFormula unmodifiableTransFormula = LoopAcceleratorLite.buildFormula(this.mScript, loop.updateVars(backbone.getFormula().getFormula(), backbone.getFormula().getInVars(), backbone.getFormula().getOutVars()), loop.getInVars(), loop.getOutVars(), hashSet);
        backbone.setFormula((TransFormula)unmodifiableTransFormula);
        SymbolicMemory symbolicMemory = new SymbolicMemory(this.mScript, this.mServices, (TransFormula)unmodifiableTransFormula, this.mOldSymbolTable);
        symbolicMemory.updateVars(simultaneousUpdate.getDeterministicAssignment());
        UnmodifiableTransFormula unmodifiableTransFormula2 = symbolicMemory.updateCondition(TransFormulaUtils.computeGuard((UnmodifiableTransFormula)unmodifiableTransFormula, (ManagedScript)this.mScript, (IUltimateServiceProvider)this.mServices));
        TermVariable termVariable = this.mScript.constructFreshTermVariable("kappa", this.mScript.getScript().sort("Int", new Sort[0]));
        this.mPathCounter.add(termVariable);
        backbone.setPathCounter(termVariable);
        backbone.setCondition(unmodifiableTransFormula2);
        if (backbone.isNested().booleanValue()) {
            for (IcfgLocation icfgLocation : backbone.getNestedLoops()) {
                Loop loop2 = this.mLoopBodies.get(icfgLocation);
                if (loop2.getPath().isEmpty() || loop2.getExitConditions().isEmpty()) continue;
                symbolicMemory.updateVars(loop2.getIteratedMemory().getIteratedMemory());
                loop.addVar(loop2.getVars());
                Map<IProgramVar, TermVariable> map = loop.getInVars();
                map.putAll(loop2.getInVars());
                loop.setInVars(map);
            }
        }
        backbone.setSymbolicMemory(symbolicMemory);
    }

    private void dealWithErrorPaths(Loop loop, Term term) {
        for (Map.Entry<IcfgLocation, Backbone> entry : loop.getErrorPaths().entrySet()) {
            UnmodifiableTransFormula unmodifiableTransFormula;
            Backbone backbone = entry.getValue();
            HashSet<TermVariable> hashSet = new HashSet<TermVariable>(loop.getVars());
            UnmodifiableTransFormula unmodifiableTransFormula2 = unmodifiableTransFormula = LoopAcceleratorLite.buildFormula(this.mScript, loop.updateVars(backbone.getFormula().getFormula(), backbone.getFormula().getInVars(), backbone.getFormula().getOutVars()), loop.getInVars(), loop.getOutVars(), hashSet);
            Term term2 = SmtUtils.or((Script)this.mScript.getScript(), Arrays.asList(term, unmodifiableTransFormula2.getFormula()));
            HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>(loop.getVars());
            UnmodifiableTransFormula unmodifiableTransFormula3 = LoopAcceleratorLite.buildFormula(this.mScript, term2, loop.getInVars(), loop.getOutVars(), hashSet2);
            entry.getValue().setFormula((TransFormula)unmodifiableTransFormula3);
        }
    }

    private void preprocessIcfg(Set<INLOC> set) {
        ArrayDeque<INLOC> arrayDeque = new ArrayDeque<INLOC>(set);
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            TermClassifier termClassifier = new TermClassifier();
            if (!hashSet.add(icfgLocation)) continue;
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                termClassifier.checkTerm(icfgEdge.getTransformula().getClosedFormula());
                if (termClassifier.hasArrays() && this.mDealingWithArrays.equals((Object)DealingWithArraysTypes.EXCEPTION)) {
                    throw new IllegalArgumentException("Cannot deal with Arrays");
                }
                if (!termClassifier.hasArrays() || !this.mDealingWithArrays.equals((Object)DealingWithArraysTypes.SKIP_LOOP)) continue;
                this.mLoopHeads = Collections.emptySet();
            }
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingNodes()) {
                arrayDeque.addLast(icfgEdge);
            }
        }
    }

    private void processLocations(Set<INLOC> set, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder) {
        ArrayDeque<INLOC> arrayDeque = new ArrayDeque<INLOC>(set);
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            if (!hashSet.add(icfgLocation)) continue;
            IcfgLocation OUTLOC = transformedIcfgBuilder.createNewLocation(icfgLocation);
            HashSet<Triple> hashSet3 = new HashSet<Triple>();
            if (this.mLoopBodies.containsKey(icfgLocation) && this.mLoopBodies.get(icfgLocation).getIteratedMemory() != null) {
                Object object22 = this.mLoopBodies.get(icfgLocation);
                if (!((Loop)object22).getErrorPaths().isEmpty()) {
                    this.mLogger.debug((Object)"LOOP WITH ERRORPATH");
                    for (Map.Entry entry : ((Loop)object22).getErrorPaths().entrySet()) {
                        var12_18 = transformedIcfgBuilder.createNewLocation((IcfgLocation)entry.getKey());
                        transformedIcfgBuilder.createNewInternalTransition(OUTLOC, var12_18, (UnmodifiableTransFormula)((Backbone)entry.getValue()).getFormula(), true);
                    }
                }
                for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                    if (((Loop)object22).getLoopExit().equals((Object)icfgEdge.getTarget())) {
                        var12_18 = (IcfgLocation)icfgEdge.getTarget();
                        arrayDeque.add(var12_18);
                        continue;
                    }
                    if (((Loop)object22).getPath().contains(icfgEdge)) {
                        var12_18 = transformedIcfgBuilder.createNewLocation(((Loop)object22).getLoopExit());
                        for (UnmodifiableTransFormula unmodifiableTransFormula : ((Loop)object22).getExitConditions()) {
                            IcfgInternalTransition icfgInternalTransition = transformedIcfgBuilder.createNewInternalTransition(OUTLOC, var12_18, unmodifiableTransFormula, this.mOverApproximation.get(OUTLOC));
                            this.mBackTranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)icfgInternalTransition, (IIcfgTransition<IcfgLocation>)icfgEdge);
                        }
                        continue;
                    }
                    var12_18 = (IcfgLocation)icfgEdge.getTarget();
                    arrayDeque.add(var12_18);
                    IcfgLocation icfgLocation2 = transformedIcfgBuilder.createNewLocation(var12_18);
                    transformedIcfgBuilder.createNewTransition(OUTLOC, icfgLocation2, icfgEdge);
                }
            } else {
                for (Object object22 : icfgLocation.getOutgoingEdges()) {
                    IcfgLocation icfgLocation3 = (IcfgLocation)object22.getTarget();
                    arrayDeque.add(icfgLocation3);
                    var12_18 = transformedIcfgBuilder.createNewLocation(icfgLocation3);
                    if (object22 instanceof IIcfgReturnTransition) {
                        hashSet3.add(new Triple((Object)OUTLOC, (Object)var12_18, (Object)((IIcfgReturnTransition)object22)));
                        continue;
                    }
                    transformedIcfgBuilder.createNewTransition(OUTLOC, var12_18, (IcfgEdge)object22);
                }
            }
            for (Object object22 : hashSet3) {
                if (!transformedIcfgBuilder.isCorrespondingCallContained((IIcfgReturnTransition)object22.getThird())) {
                    hashSet2.add(object22);
                    continue;
                }
                transformedIcfgBuilder.createNewTransition((IcfgLocation)object22.getFirst(), (IcfgLocation)object22.getSecond(), (IcfgEdge)object22.getThird());
            }
        }
        hashSet2.stream().filter(triple -> transformedIcfgBuilder.isCorrespondingCallContained((IIcfgReturnTransition)triple.getThird())).forEach(triple -> {
            IcfgEdge icfgEdge = transformedIcfgBuilder.createNewTransition((IcfgLocation)triple.getFirst(), (IcfgLocation)triple.getSecond(), (IcfgEdge)triple.getThird());
        });
    }

    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }

    public static enum DealingWithArraysTypes {
        EXCEPTION,
        SKIP_LOOP;

    }
}

